/*
 * Decompiled with CFR 0.152.
 */
package jason.infra.centralised;

import jason.infra.centralised.CentralisedAgArch;
import jason.infra.centralised.CentralisedEnvironment;
import jason.infra.centralised.CentralisedExecutionControl;
import jason.infra.centralised.CentralisedRuntimeServices;
import jason.mas2j.MAS2JProject;
import jason.runtime.RuntimeServicesInfraTier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

public abstract class BaseCentralisedMAS {
    public static final String logPropFile = "logging.properties";
    public static final String stopMASFileName = ".stop___MAS";
    public static final String defaultProjectFileName = "default.mas2j";
    protected static Logger logger = Logger.getLogger(BaseCentralisedMAS.class.getName());
    protected static BaseCentralisedMAS runner = null;
    protected static String urlPrefix = "";
    protected static boolean readFromJAR = false;
    protected static MAS2JProject project;
    protected static boolean debug;
    protected CentralisedEnvironment env = null;
    protected CentralisedExecutionControl control = null;
    protected Map<String, CentralisedAgArch> ags = new ConcurrentHashMap<String, CentralisedAgArch>();

    public boolean isDebug() {
        return debug;
    }

    public static BaseCentralisedMAS getRunner() {
        return runner;
    }

    public RuntimeServicesInfraTier getRuntimeServices() {
        return new CentralisedRuntimeServices(runner);
    }

    public CentralisedExecutionControl getControllerInfraTier() {
        return this.control;
    }

    public CentralisedEnvironment getEnvironmentInfraTier() {
        return this.env;
    }

    public MAS2JProject getProject() {
        return project;
    }

    public void setProject(MAS2JProject p) {
        project = p;
    }

    public void addAg(CentralisedAgArch ag) {
        this.ags.put(ag.getAgName(), ag);
    }

    public CentralisedAgArch delAg(String agName) {
        return this.ags.remove(agName);
    }

    public CentralisedAgArch getAg(String agName) {
        return this.ags.get(agName);
    }

    public Map<String, CentralisedAgArch> getAgs() {
        return this.ags;
    }

    public abstract void setupLogger();

    public abstract void finish();

    public abstract boolean hasDebugControl();

    public abstract void enableDebugControl();

    static {
        debug = false;
    }
}

