/*
 * Decompiled with CFR 0.152.
 */
package jason.control;

import jason.control.ExecutionControl;
import jason.infra.centralised.BaseCentralisedMAS;
import jason.util.Config;
import jason.util.asl2html;
import jason.util.asl2tex;
import jason.util.asl2xml;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.w3c.dom.Document;

public class ExecutionControlGUI
extends ExecutionControl {
    String currentAgState = "";
    String currentAgName = "";
    int agShownState = 0;
    private Map<String, Map<Integer, Document>> agsHistory = new HashMap<String, Map<Integer, Document>>();
    private int countCycles = 0;
    private int maxCycles = 0;
    private boolean waitAllAgs = false;
    private boolean waitSelectedAg = false;
    private boolean breakpoint = false;
    asl2xml agTransformerXML = new asl2xml();
    asl2tex agTransformerTex = new asl2tex("/xml/ag2tex.xsl");
    asl2html agTransformerHtml = new asl2html("/xml/agInspection.xsl");
    asl2xml agTransformer = null;
    JFrame frame;
    JTextField jTfSteps = null;
    JComboBox jCbWho = null;
    JButton jBtRun = null;
    JComboBox jCbViewAs = null;
    JSlider jHistory = null;
    JTextPane jTA = null;
    JList jList = null;
    JPanel spList;
    DefaultListModel listModel;
    Document agState = null;
    Map<String, Boolean> show = new HashMap<String, Boolean>();
    public static String title = "..:: Mind Inspector ::..";
    private String previousMind = "--";
    private ExecutorService executor = Executors.newFixedThreadPool(2);

    public ExecutionControlGUI() {
        this.agTransformer = this.agTransformerHtml;
        this.setRunningCycle(false);
        this.initComponents();
    }

    @Override
    public void init(String[] args) {
        this.setListOfAgsFromInfra();
    }

    void initComponents() {
        this.frame = new JFrame(title);
        this.jTfSteps = new JTextField(3);
        this.jTfSteps.setText("1");
        this.jTfSteps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ExecutionControlGUI.this.startRun();
                    }
                });
            }
        });
        this.jCbWho = new JComboBox();
        this.jCbWho.addItem("all agents");
        this.jCbWho.addItem("selected agent");
        this.jBtRun = new JButton("Run", new ImageIcon(ExecutionControlGUI.class.getResource("/images/run.gif")));
        this.jBtRun.setToolTipText("Run the MAS until some agent achieve a breakpoint. Breakpoints are annotations in plans' label");
        this.jBtRun.setEnabled(true);
        this.jBtRun.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ExecutionControlGUI.this.startRun();
                    }
                });
            }
        });
        this.jCbViewAs = new JComboBox();
        this.jCbViewAs.addItem("html");
        this.jCbViewAs.addItem("xml");
        this.jCbViewAs.addItem("LaTeX");
        this.jCbViewAs.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ievt) {
                String mime = ExecutionControlGUI.this.jCbViewAs.getSelectedItem().toString();
                if (mime.equals("html")) {
                    ExecutionControlGUI.this.agTransformer = ExecutionControlGUI.this.agTransformerHtml;
                } else if (mime.equals("xml")) {
                    ExecutionControlGUI.this.agTransformer = ExecutionControlGUI.this.agTransformerXML;
                } else if (mime.equals("LaTeX")) {
                    mime = "xml";
                    ExecutionControlGUI.this.agTransformer = ExecutionControlGUI.this.agTransformerTex;
                }
                ExecutionControlGUI.this.jTA.setContentType("text/" + mime);
                ExecutionControlGUI.this.previousMind = "--";
                ExecutionControlGUI.this.showAgState();
            }
        });
        this.jTA = new JTextPane();
        this.jTA.setEditable(false);
        this.jTA.setContentType("text/html");
        this.jTA.setAutoscrolls(false);
        this.jTA.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent evt) {
                ExecutionControlGUI.this.hyperLink(evt);
            }
        });
        this.jTA.setText("<html><body>Select the agent to inspect.</body></html>");
        JPanel spTA = new JPanel(new BorderLayout());
        JScrollPane scpTA = new JScrollPane(this.jTA);
        spTA.add("Center", scpTA);
        spTA.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Agent Inspection", 1, 2));
        JPanel pHistory = new JPanel(new BorderLayout());
        pHistory.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Agent History", 1, 2));
        this.jHistory = new JSlider();
        this.jHistory.setMaximum(1);
        this.jHistory.setMinimum(0);
        this.jHistory.setValue(0);
        this.jHistory.setPaintTicks(true);
        this.jHistory.setPaintLabels(true);
        this.jHistory.setMajorTickSpacing(10);
        this.jHistory.setMinorTickSpacing(1);
        this.setupSlider();
        this.jHistory.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e2) {
                int c = ExecutionControlGUI.this.jHistory.getValue();
                try {
                    ExecutionControlGUI.this.agState = (Document)((Map)ExecutionControlGUI.this.agsHistory.get(ExecutionControlGUI.this.currentAgName)).get(c);
                    ExecutionControlGUI.this.showAgState();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        pHistory.add("Center", this.jHistory);
        JPanel pAg = new JPanel(new BorderLayout());
        pAg.add("Center", spTA);
        pAg.add("South", pHistory);
        this.listModel = new DefaultListModel();
        this.jList = new JList(this.listModel);
        this.spList = new JPanel(new BorderLayout());
        this.spList.add("Center", new JScrollPane(this.jList));
        this.spList.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Agents", 1, 2));
        this.jList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e2) {
                String ag = ExecutionControlGUI.this.jList.getSelectedValue().toString();
                if (!ag.equals(ExecutionControlGUI.this.currentAgState)) {
                    ExecutionControlGUI.this.currentAgState = ag;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ExecutionControlGUI.this.inspectAgent(ExecutionControlGUI.this.currentAgState);
                        }
                    });
                }
            }
        });
        JPanel pButtons = new JPanel(new FlowLayout(1));
        pButtons.add(this.jBtRun);
        pButtons.add(this.jTfSteps);
        pButtons.add(new JLabel("cycle(s) for "));
        pButtons.add(this.jCbWho);
        pButtons.add(new JLabel("        view as:"));
        pButtons.add(this.jCbViewAs);
        JSplitPane splitPaneHor = new JSplitPane(1);
        splitPaneHor.setTopComponent(this.spList);
        splitPaneHor.setDividerLocation(100);
        splitPaneHor.setBottomComponent(pAg);
        splitPaneHor.setOneTouchExpandable(true);
        this.frame.getContentPane().add("South", pButtons);
        this.frame.getContentPane().add("Center", splitPaneHor);
        this.frame.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int height = (int)((double)screenSize.height * 0.618);
        this.frame.setBounds(80, 30, (int)((double)height * 1.618), height);
        this.frame.setVisible(true);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
            }
        });
        this.show.put("bels", true);
        this.show.put("rules", false);
        this.show.put("evt", true);
        this.show.put("mb", false);
        this.show.put("int", false);
        this.show.put("int-details", false);
        this.show.put("plan", false);
        this.show.put("plan-details", false);
        this.show.put("annots", Config.get().getBoolean("showAnnots"));
    }

    void setListOfAgsFromInfra() {
        try {
            TreeSet<String> ags = new TreeSet<String>(this.getExecutionControlInfraTier().getRuntimeServices().getAgentsNames());
            for (String ag : ags) {
                this.listModel.addElement(ag);
            }
        }
        catch (Exception e2) {
            System.err.println("Error getting list of agents from infrasructure. " + e2);
        }
    }

    private void setupSlider() {
        int size = this.getCycleNumber();
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(0, new JLabel("Cycle 0"));
        labelTable.put(size, new JLabel("Cycle " + size));
        this.jHistory.setLabelTable(labelTable);
        this.jHistory.setMaximum(size);
        this.jHistory.setValue(size);
    }

    @Override
    public void stop() {
        super.stop();
        this.frame.dispose();
        this.frame = null;
    }

    private void inspectAgent(String agName) {
        if (agName == null) {
            return;
        }
        if (agName.length() == 0) {
            return;
        }
        this.currentAgName = agName;
        this.agState = null;
        try {
            this.agState = this.agsHistory.get(this.currentAgName).get(this.getCycleNumber());
        }
        catch (Exception et) {
            // empty catch block
        }
        if (this.agState == null) {
            try {
                this.agState = this.infraControl.getAgState(this.currentAgName);
                this.storeAgHistory(this.currentAgName, this.getCycleNumber(), this.agState);
            }
            catch (Exception e2) {
                this.jTA.setText("Error getting the state of agent " + this.currentAgName);
                logger.log(Level.SEVERE, "Error:", e2);
            }
        }
        this.showAgState();
        this.setupSlider();
    }

    void showAgState() {
        if (this.agState != null) {
            String sMind = null;
            try {
                if (this.jCbViewAs.getSelectedItem().toString().equals("html")) {
                    for (String p : this.show.keySet()) {
                        this.agTransformer.getTransformer().setParameter("show-" + p, this.show.get(p) + "");
                    }
                }
                if (!(sMind = this.agTransformer.transform(this.agState)).equals(this.previousMind)) {
                    this.jTA.setText(sMind);
                }
                this.previousMind = sMind;
            }
            catch (Exception e2) {
                this.jTA.setText("Error in XML transformation!" + e2 + "\nText=" + sMind);
                e2.printStackTrace();
            }
        }
    }

    private void hyperLink(HyperlinkEvent evt) {
        if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            String uri = "show?";
            int pos = evt.getDescription().indexOf(uri);
            if (pos >= 0) {
                String par = evt.getDescription().substring(pos + uri.length());
                this.show.put(par, true);
            } else {
                uri = "hide?";
                pos = evt.getDescription().indexOf(uri);
                if (pos >= 0) {
                    String par = evt.getDescription().substring(pos + uri.length());
                    this.show.put(par, false);
                }
            }
            this.showAgState();
        }
    }

    protected void startRun() {
        this.jBtRun.setEnabled(false);
        this.countCycles = 0;
        this.maxCycles = Integer.parseInt(this.jTfSteps.getText());
        this.breakpoint = false;
        if (this.jCbWho.getSelectedIndex() == 0) {
            this.waitAllAgs = true;
            this.waitSelectedAg = false;
        } else {
            this.waitAllAgs = false;
            this.waitSelectedAg = true;
        }
        if (BaseCentralisedMAS.getRunner() != null && BaseCentralisedMAS.getRunner().hasDebugControl()) {
            BaseCentralisedMAS.getRunner().enableDebugControl();
        }
        this.startNewCycle();
        this.continueRun();
    }

    protected void stopRun() {
        this.waitAllAgs = false;
        this.waitSelectedAg = false;
        this.inspectAgent(this.currentAgName);
        this.jBtRun.setEnabled(true);
        this.setRunningCycle(false);
    }

    protected void continueRun() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                if (ExecutionControlGUI.this.waitAllAgs) {
                    ExecutionControlGUI.this.infraControl.informAllAgsToPerformCycle(ExecutionControlGUI.this.getCycleNumber());
                }
                if (ExecutionControlGUI.this.waitSelectedAg) {
                    ExecutionControlGUI.this.infraControl.informAgToPerformCycle(ExecutionControlGUI.this.currentAgName, ExecutionControlGUI.this.getCycleNumber());
                }
            }
        });
    }

    @Override
    public void receiveFinishedCycle(String agName, boolean breakpoint, int cycle) {
        if (!this.listModel.contains(agName)) {
            logger.fine("New agent " + agName);
            this.listModel.addElement(agName);
        }
        try {
            this.storeAgHistory(agName, cycle, this.infraControl.getAgState(agName));
        }
        catch (Exception e2) {
            this.jTA.setText("Error getting the state of agent " + agName);
            logger.log(Level.SEVERE, "Error:", e2);
        }
        this.breakpoint = breakpoint;
        if (this.waitSelectedAg) {
            ++this.countCycles;
            logger.info("Agent " + agName + " has finished cycle " + cycle);
            if (this.testStop()) {
                this.stopRun();
            } else {
                this.startNewCycle();
                this.continueRun();
            }
        } else {
            super.receiveFinishedCycle(agName, breakpoint, cycle);
        }
    }

    @Override
    protected void allAgsFinished() {
        if (this.waitAllAgs) {
            logger.fine("All agents have finished cycle " + this.getCycleNumber());
            ++this.countCycles;
            if (this.testStop()) {
                this.stopRun();
            } else {
                this.startNewCycle();
                this.frame.setTitle(title + " cycle " + this.getCycleNumber() + " ::");
                this.continueRun();
            }
        }
    }

    protected boolean testStop() {
        return this.breakpoint || this.countCycles >= this.maxCycles;
    }

    protected void storeAgHistory(String agName, int cycle, Document doc) {
        if (doc == null) {
            return;
        }
        Map<Integer, Document> lag = this.agsHistory.get(agName);
        if (lag == null) {
            lag = new HashMap<Integer, Document>();
            this.agsHistory.put(agName, lag);
        }
        lag.put(cycle, doc);
    }
}

