/*
 * Decompiled with CFR 0.152.
 */
package jason.bb;

import jason.asSemantics.Agent;
import jason.asSyntax.Literal;
import jason.bb.BeliefBase;
import jason.bb.ChainBBAdapter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TextPersistentBB
extends ChainBBAdapter {
    private static Logger logger = Logger.getLogger(TextPersistentBB.class.getName());
    private File file = null;

    public TextPersistentBB() {
    }

    public TextPersistentBB(BeliefBase next) {
        super(next);
    }

    @Override
    public void init(Agent ag, String[] args) {
        if (ag != null) {
            try {
                this.file = new File(ag.getTS().getUserAgArch().getAgName() + ".bb");
                logger.fine("reading from file " + this.file);
                if (this.file.exists()) {
                    ag.parseAS(this.file.getAbsoluteFile());
                    ag.addInitialBelsInBB();
                }
            }
            catch (Exception e2) {
                logger.log(Level.SEVERE, "Error initialising TextPersistentBB.", e2);
            }
        }
    }

    @Override
    public void stop() {
        try {
            logger.fine("writting to file " + this.file);
            PrintWriter out = new PrintWriter(new FileWriter(this.file));
            out.println("// BB stored by TextPersistentBB\n");
            for (Literal b : this) {
                if (b.isRule()) continue;
                out.println(b.toString() + ".");
            }
            out.close();
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error writing BB in file " + this.file, e2);
        }
        this.nextBB.stop();
    }
}

