/*
 * Decompiled with CFR 0.152.
 */
package jason.bb;

import jason.asSemantics.Agent;
import jason.asSemantics.Unifier;
import jason.asSyntax.Atom;
import jason.asSyntax.Literal;
import jason.asSyntax.PredicateIndicator;
import jason.bb.BeliefBase;
import jason.bb.StructureWrapperForLiteral;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DefaultBeliefBase
extends BeliefBase {
    private static Logger logger = Logger.getLogger(DefaultBeliefBase.class.getSimpleName());
    private Map<PredicateIndicator, BelEntry> belsMapDefaultNS = new ConcurrentHashMap<PredicateIndicator, BelEntry>();
    private Map<Atom, Map<PredicateIndicator, BelEntry>> nameSpaces = new ConcurrentHashMap<Atom, Map<PredicateIndicator, BelEntry>>();
    private int size = 0;
    protected Set<Literal> percepts = new HashSet<Literal>();

    public DefaultBeliefBase() {
        this.nameSpaces.put(Literal.DefaultNS, this.belsMapDefaultNS);
    }

    @Override
    public void init(Agent ag, String[] args) {
        if (ag != null) {
            logger = Logger.getLogger(ag.getTS().getUserAgArch().getAgName() + "-" + DefaultBeliefBase.class.getSimpleName());
        }
    }

    @Override
    public Set<Atom> getNameSpaces() {
        return this.nameSpaces.keySet();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.percepts.clear();
        this.belsMapDefaultNS.clear();
        this.nameSpaces.clear();
        this.nameSpaces.put(Literal.DefaultNS, this.belsMapDefaultNS);
    }

    @Override
    public Iterator<Literal> getPercepts() {
        final Iterator<Literal> i = this.percepts.iterator();
        return new Iterator<Literal>(){
            Literal current = null;

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public Literal next() {
                this.current = (Literal)i.next();
                return this.current;
            }

            @Override
            public void remove() {
                if (this.current == null) {
                    logger.warning("Trying to remove a perception, but the the next() from the iterator is not called before!");
                }
                i.remove();
                this.current.delAnnot(BeliefBase.TPercept);
                DefaultBeliefBase.this.removeFromEntry(this.current);
            }
        };
    }

    Set<Literal> getPerceptsSet() {
        return this.percepts;
    }

    @Override
    public boolean add(Literal l) {
        return this.add(l, false);
    }

    @Override
    public boolean add(int index, Literal l) {
        return this.add(l, index != 0);
    }

    protected boolean add(Literal l, boolean addInEnd) {
        if (!l.canBeAddedInBB()) {
            logger.log(Level.SEVERE, "Error: '" + l + "' can not be added in the belief base.");
            return false;
        }
        Literal bl = this.contains(l);
        if (bl != null && !bl.isRule()) {
            if (bl.importAnnots(l)) {
                if (l.hasAnnot(TPercept)) {
                    this.percepts.add(bl);
                }
                return true;
            }
        } else {
            l = l.copy();
            BelEntry entry = this.provideBelEntry(l);
            entry.add(l, addInEnd);
            if (l.hasAnnot(TPercept)) {
                this.percepts.add(l);
            }
            ++this.size;
            return true;
        }
        return false;
    }

    private BelEntry provideBelEntry(Literal l) {
        BelEntry entry;
        Map<PredicateIndicator, BelEntry> belsMap = this.belsMapDefaultNS;
        if (l.getNS() != Literal.DefaultNS && (belsMap = this.nameSpaces.get(l.getNS())) == null) {
            belsMap = new ConcurrentHashMap<PredicateIndicator, BelEntry>();
            this.nameSpaces.put(l.getNS(), belsMap);
        }
        if ((entry = belsMap.get(l.getPredicateIndicator())) == null) {
            entry = new BelEntry();
            belsMap.put(l.getPredicateIndicator(), entry);
        }
        return entry;
    }

    @Override
    public boolean remove(Literal l) {
        Literal bl = this.contains(l);
        if (bl != null && l.hasSubsetAnnot(bl)) {
            if (l.hasAnnot(TPercept)) {
                this.percepts.remove(bl);
            }
            boolean result = bl.delAnnots(l.getAnnots());
            return this.removeFromEntry(bl) || result;
        }
        return false;
    }

    private boolean removeFromEntry(Literal l) {
        if (l.hasSource()) {
            return false;
        }
        Map<PredicateIndicator, BelEntry> belsMap = l.getNS() == Literal.DefaultNS ? this.belsMapDefaultNS : this.nameSpaces.get(l.getNS());
        PredicateIndicator key = l.getPredicateIndicator();
        BelEntry entry = belsMap.get(key);
        entry.remove(l);
        if (entry.isEmpty()) {
            belsMap.remove(key);
        }
        --this.size;
        return true;
    }

    @Override
    public Iterator<Literal> iterator() {
        final Iterator<Map<PredicateIndicator, BelEntry>> ins = this.nameSpaces.values().iterator();
        return new Iterator<Literal>(){
            Iterator<BelEntry> ibe;
            Iterator<Literal> il;
            Literal l;
            {
                this.ibe = ((Map)ins.next()).values().iterator();
                this.il = null;
                this.l = null;
                this.goNext();
            }

            @Override
            public boolean hasNext() {
                return this.il != null && this.il.hasNext();
            }

            private void goNext() {
                while (this.il == null || !this.il.hasNext()) {
                    if (this.ibe.hasNext()) {
                        this.il = this.ibe.next().list.iterator();
                        continue;
                    }
                    if (ins.hasNext()) {
                        this.ibe = ((Map)ins.next()).values().iterator();
                        continue;
                    }
                    return;
                }
            }

            @Override
            public Literal next() {
                this.l = this.il.next();
                this.goNext();
                return this.l;
            }

            @Override
            public void remove() {
                this.il.remove();
                if (this.l.hasAnnot(BeliefBase.TPercept)) {
                    DefaultBeliefBase.this.percepts.remove(this.l);
                }
                DefaultBeliefBase.this.size--;
            }
        };
    }

    @Override
    public boolean abolish(Atom namespace2, PredicateIndicator pi2) {
        BelEntry entry = this.nameSpaces.get(namespace2).remove(pi2);
        if (entry != null) {
            this.size -= entry.size();
            Iterator<Literal> i = this.percepts.iterator();
            while (i.hasNext()) {
                Literal l = i.next();
                if (!l.getPredicateIndicator().equals(pi2)) continue;
                i.remove();
            }
            return true;
        }
        return false;
    }

    @Override
    public Literal contains(Literal l) {
        Map<PredicateIndicator, BelEntry> belsMap;
        Map<PredicateIndicator, BelEntry> map = belsMap = l.getNS() == Literal.DefaultNS ? this.belsMapDefaultNS : this.nameSpaces.get(l.getNS());
        if (belsMap == null) {
            return null;
        }
        BelEntry entry = belsMap.get(l.getPredicateIndicator());
        if (entry == null) {
            return null;
        }
        return entry.contains(l);
    }

    @Override
    public Iterator<Literal> getCandidateBeliefs(PredicateIndicator pi2) {
        BelEntry entry = this.nameSpaces.get(pi2.getNS()).get(pi2);
        if (entry != null) {
            return entry.list.iterator();
        }
        return null;
    }

    @Override
    public Iterator<Literal> getCandidateBeliefs(Literal l, Unifier u) {
        if (l.isVar()) {
            return this.iterator();
        }
        Map<PredicateIndicator, BelEntry> belsMap = this.belsMapDefaultNS;
        if (l.getNS() != Literal.DefaultNS) {
            Atom ns = l.getNS();
            if (ns.isVar()) {
                l = (Literal)l.capply(u);
                ns = l.getNS();
            }
            if (ns.isVar()) {
                return this.iterator();
            }
            belsMap = this.nameSpaces.get(ns);
        }
        if (belsMap == null) {
            return null;
        }
        BelEntry entry = belsMap.get(l.getPredicateIndicator());
        if (entry != null) {
            return entry.list.iterator();
        }
        return null;
    }

    public String toString() {
        return this.nameSpaces.toString();
    }

    @Override
    public BeliefBase clone() {
        DefaultBeliefBase bb = new DefaultBeliefBase();
        for (Literal b : this) {
            bb.add(1, b.copy());
        }
        return bb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element getAsDOM(Document document) {
        Element ebels = null;
        for (int tries = 0; tries < 10; ++tries) {
            try {
                Object object = this.getLock();
                synchronized (object) {
                    ebels = document.createElement("beliefs");
                    Element enss = document.createElement("namespaces");
                    Element ens = document.createElement("namespace");
                    ens.setAttribute("id", "default");
                    enss.appendChild(ens);
                    for (Atom ns : this.getNameSpaces()) {
                        if (ns == Literal.DefaultNS) continue;
                        ens = document.createElement("namespace");
                        ens.setAttribute("id", ns.getFunctor());
                        enss.appendChild(ens);
                    }
                    ebels.appendChild(enss);
                    for (Literal l : this) {
                        ebels.appendChild(l.getAsDOM(document));
                    }
                    break;
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
                continue;
            }
        }
        return ebels;
    }

    final class BelEntry {
        private final Deque<Literal> list = new LinkedBlockingDeque<Literal>();
        private final Map<StructureWrapperForLiteral, Literal> map = new ConcurrentHashMap<StructureWrapperForLiteral, Literal>();

        BelEntry() {
        }

        public void add(Literal l, boolean addInEnd) {
            this.map.put(new StructureWrapperForLiteral(l), l);
            if (addInEnd) {
                this.list.addLast(l);
            } else {
                this.list.addFirst(l);
            }
        }

        public void remove(Literal l) {
            Literal linmap = this.map.remove(new StructureWrapperForLiteral(l));
            if (linmap != null) {
                this.list.remove(linmap);
            }
        }

        public int size() {
            return this.map.size();
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        public Literal contains(Literal l) {
            return this.map.get(new StructureWrapperForLiteral(l));
        }

        protected Object clone() {
            BelEntry be = new BelEntry();
            for (Literal l : this.list) {
                be.add(l.copy(), false);
            }
            return be;
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            for (Literal l : this.list) {
                s.append(l + ":" + l.hashCode() + ",");
            }
            return s.toString();
        }
    }
}

