/*
 * Decompiled with CFR 0.152.
 */
package jason.bb;

import jason.asSemantics.Agent;
import jason.asSyntax.StringTerm;
import jason.asSyntax.Structure;
import jason.asSyntax.Term;
import jason.bb.BeliefBase;
import jason.bb.ChainBBAdapter;
import jason.bb.DefaultBeliefBase;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ChainBB
extends ChainBBAdapter {
    private static Logger logger = Logger.getLogger(ChainBB.class.getSimpleName());

    @Override
    public void init(Agent ag, String[] args) {
        this.setNext(null);
        try {
            for (String s : args) {
                Structure bbs = Structure.parse(s);
                ChainBBAdapter bb = (ChainBBAdapter)Class.forName(bbs.getFunctor()).newInstance();
                this.addInChain(bb);
            }
            ChainBBAdapter bb = this.getNextAdapter();
            for (String s : args) {
                Structure bbs = Structure.parse(s);
                String[] bbargs = new String[bbs.getArity()];
                int i = 0;
                if (bbs.hasTerm()) {
                    for (Term t : bbs.getTerms()) {
                        bbargs[i++] = t.isString() ? ((StringTerm)t).getString() : t.toString();
                    }
                }
                bb.init(ag, bbargs);
                bb = bb.getNextAdapter();
            }
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error creating ChainBB", e2);
        }
    }

    public void addInChain(BeliefBase bb) {
        if (this.getNextAdapter() == null) {
            this.setNext(bb);
        } else {
            ChainBBAdapter last = this.getNextAdapter();
            while (last.getNextAdapter() != null) {
                last = last.getNextAdapter();
            }
            last.setNext(bb);
        }
    }

    public List<Class> getChainClasses() {
        ArrayList<Class> r = new ArrayList<Class>();
        for (ChainBBAdapter c = this.getNextAdapter(); c != null; c = c.getNextAdapter()) {
            r.add(c.getClass());
            if (c.nextBB == null || !(c.nextBB instanceof DefaultBeliefBase)) continue;
            r.add(c.nextBB.getClass());
        }
        return r;
    }
}

