/*
 * Decompiled with CFR 0.152.
 */
package jason.asSyntax;

import jason.JasonException;
import jason.asSyntax.ASSyntax;
import jason.asSyntax.Atom;
import jason.asSyntax.Literal;
import jason.asSyntax.Plan;
import jason.asSyntax.Pred;
import jason.asSyntax.PredicateIndicator;
import jason.asSyntax.StringTerm;
import jason.asSyntax.Term;
import jason.asSyntax.Trigger;
import jason.asSyntax.parser.ParseException;
import jason.bb.BeliefBase;
import jason.util.Config;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PlanLibrary
implements Iterable<Plan> {
    private Map<PredicateIndicator, List<Plan>> relPlans = new ConcurrentHashMap<PredicateIndicator, List<Plan>>();
    private List<Plan> plans = new ArrayList<Plan>();
    private List<Plan> varPlans = new ArrayList<Plan>();
    private Map<String, Plan> planLabels = new ConcurrentHashMap<String, Plan>();
    private boolean hasMetaEventPlans = false;
    private static AtomicInteger lastPlanLabel = new AtomicInteger(0);
    private boolean hasUserKqmlReceived = false;
    private final Object lockPL = new Object();
    private final String kqmlReceivedFunctor = Config.get().getKqmlFunctor();
    public static final Trigger TE_JAG_SLEEPING = new Trigger(Trigger.TEOperator.add, Trigger.TEType.achieve, new Atom("jag_sleeping"));
    public static final Trigger TE_JAG_AWAKING = new Trigger(Trigger.TEOperator.add, Trigger.TEType.achieve, new Atom("jag_awaking"));

    public Object getLock() {
        return this.lockPL;
    }

    public Plan add(StringTerm stPlan, Term tSource) throws ParseException, JasonException {
        return this.add(stPlan, tSource, false);
    }

    public Plan add(StringTerm stPlan, Term tSource, boolean before) throws ParseException, JasonException {
        String sPlan = stPlan.getString();
        StringBuilder sTemp = new StringBuilder();
        for (int c = 0; c < sPlan.length(); ++c) {
            if (sPlan.charAt(c) == '\\') continue;
            sTemp.append(sPlan.charAt(c));
        }
        sPlan = sTemp.toString();
        Plan p = ASSyntax.parsePlan(sPlan);
        return this.add(p, tSource, before);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Plan add(Plan p, Term source, boolean before) throws JasonException {
        Object object = this.lockPL;
        synchronized (object) {
            int i = this.plans.indexOf(p);
            if (i < 0) {
                if (p.getLabel() == null) {
                    p.setLabel(this.getUniqueLabel());
                }
                p.getLabel().addSource(source);
                this.add(p, before);
            } else {
                p = this.plans.get(i);
                p.getLabel().addSource(source);
            }
            return p;
        }
    }

    public void add(Plan p) throws JasonException {
        this.add(p, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Plan p, boolean before) throws JasonException {
        Object object = this.lockPL;
        synchronized (object) {
            if (p.getLabel() != null && this.planLabels.keySet().contains(this.getStringForLabel(p.getLabel()))) {
                Plan planInPL = this.get(p.getLabel());
                if (p.equals(planInPL)) {
                    planInPL.getLabel().addSource((Term)p.getLabel().getSources().get(0));
                    return;
                }
                throw new JasonException("There already is a plan with label " + p.getLabel());
            }
            if (p.getLabel() == null) {
                p.setLabel(this.getUniqueLabel());
            }
            if (!p.getLabel().hasSource()) {
                p.getLabel().addAnnot(BeliefBase.TSelf);
            }
            if (p.getTrigger().getLiteral().getFunctor().equals(this.kqmlReceivedFunctor) && (p.getSrcInfo() == null || !"kqmlPlans.asl".equals(p.getSrcInfo().getSrcFile()))) {
                this.hasUserKqmlReceived = true;
            }
            p.setAsPlanTerm(false);
            this.planLabels.put(this.getStringForLabel(p.getLabel()), p);
            Trigger pte = p.getTrigger();
            if (pte.getLiteral().isVar() || pte.getLiteral().getNS().isVar()) {
                if (before) {
                    this.varPlans.add(0, p);
                } else {
                    this.varPlans.add(p);
                }
                for (List<Plan> lp : this.relPlans.values()) {
                    if (lp.isEmpty() || !lp.get(0).getTrigger().sameType(pte)) continue;
                    if (before) {
                        lp.add(0, p);
                        continue;
                    }
                    lp.add(p);
                }
            } else {
                List<Plan> codesList = this.relPlans.get(pte.getPredicateIndicator());
                if (codesList == null) {
                    codesList = new ArrayList<Plan>();
                    for (Plan vp : this.varPlans) {
                        if (!vp.getTrigger().sameType(pte)) continue;
                        codesList.add(vp);
                    }
                    this.relPlans.put(pte.getPredicateIndicator(), codesList);
                }
                if (before) {
                    codesList.add(0, p);
                } else {
                    codesList.add(p);
                }
            }
            if (pte.getOperator() == Trigger.TEOperator.goalState) {
                this.hasMetaEventPlans = true;
            }
            if (before) {
                this.plans.add(0, p);
            } else {
                this.plans.add(p);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(PlanLibrary pl) throws JasonException {
        Object object = this.lockPL;
        synchronized (object) {
            for (Plan p : pl) {
                this.add(p, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(List<Plan> plans) throws JasonException {
        Object object = this.lockPL;
        synchronized (object) {
            for (Plan p : plans) {
                this.add(p, false);
            }
        }
    }

    private String getStringForLabel(Atom p) {
        if (p.getNS() == Literal.DefaultNS) {
            return p.getFunctor();
        }
        return p.getNS() + "::" + p.getFunctor();
    }

    public boolean hasMetaEventPlans() {
        return this.hasMetaEventPlans;
    }

    public boolean hasUserKqmlReceivedPlans() {
        return this.hasUserKqmlReceived;
    }

    private Pred getUniqueLabel() {
        String l;
        do {
            l = "l__" + lastPlanLabel.incrementAndGet();
        } while (this.planLabels.keySet().contains(l));
        return new Pred(l);
    }

    public Plan get(String label) {
        return this.get(new Atom(label));
    }

    public Plan get(Atom label) {
        return this.planLabels.get(this.getStringForLabel(label));
    }

    public int size() {
        return this.plans.size();
    }

    public List<Plan> getPlans() {
        return this.plans;
    }

    @Override
    public Iterator<Plan> iterator() {
        return this.plans.iterator();
    }

    public void clear() {
        this.planLabels.clear();
        this.plans.clear();
        this.varPlans.clear();
        this.relPlans.clear();
    }

    public boolean remove(Atom pLabel, Term source) {
        Plan p = this.get(pLabel);
        if (p != null) {
            boolean hasSource = p.getLabel().delSource(source);
            if (hasSource && !p.getLabel().hasSource()) {
                this.remove(pLabel);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Plan remove(Atom pLabel) {
        Object object = this.lockPL;
        synchronized (object) {
            Plan p = this.planLabels.remove(this.getStringForLabel(pLabel));
            this.plans.remove(p);
            if (p.getTrigger().getLiteral().isVar()) {
                this.varPlans.remove(p);
                Iterator<PredicateIndicator> ipi = this.relPlans.keySet().iterator();
                while (ipi.hasNext()) {
                    PredicateIndicator pi2 = ipi.next();
                    List<Plan> lp = this.relPlans.get(pi2);
                    lp.remove(p);
                    if (!lp.isEmpty()) continue;
                    ipi.remove();
                }
            } else {
                List<Plan> codesList = this.relPlans.get(p.getTrigger().getPredicateIndicator());
                codesList.remove(p);
                if (codesList.isEmpty()) {
                    this.relPlans.remove(p.getTrigger().getPredicateIndicator());
                }
            }
            return p;
        }
    }

    public boolean isRelevant(Trigger te) {
        return this.hasCandidatePlan(te);
    }

    public boolean hasCandidatePlan(Trigger te) {
        if (te == null) {
            return false;
        }
        return this.getCandidatePlans(te) != null;
    }

    public List<Plan> getAllRelevant(Trigger te) {
        return this.getCandidatePlans(te);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Plan> getCandidatePlans(Trigger te) {
        Object object = this.lockPL;
        synchronized (object) {
            List<Plan> l = null;
            if (te.getLiteral().isVar() || te.getNS().isVar()) {
                for (Plan p : this) {
                    if (!p.getTrigger().sameType(te)) continue;
                    if (l == null) {
                        l = new ArrayList<Plan>();
                    }
                    l.add(p);
                }
            } else {
                l = this.relPlans.get(te.getPredicateIndicator());
                if ((l == null || l.isEmpty()) && !this.varPlans.isEmpty() && te != TE_JAG_SLEEPING && te != TE_JAG_AWAKING) {
                    for (Plan p : this.varPlans) {
                        if (!p.getTrigger().sameType(te)) continue;
                        if (l == null) {
                            l = new ArrayList<Plan>();
                        }
                        l.add(p);
                    }
                }
            }
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlanLibrary clone() {
        PlanLibrary pl = new PlanLibrary();
        try {
            Object object = this.lockPL;
            synchronized (object) {
                for (Plan p : this) {
                    pl.add((Plan)p.clone(), false);
                }
            }
        }
        catch (JasonException e2) {
            e2.printStackTrace();
        }
        return pl;
    }

    public String toString() {
        return this.plans.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getAsDOM(Document document) {
        Element eplans = document.createElement("plans");
        String lastFunctor = null;
        Object object = this.lockPL;
        synchronized (object) {
            for (Plan p : this.plans) {
                String currentFunctor = p.getTrigger().getLiteral().getFunctor();
                if (lastFunctor != null && !currentFunctor.equals(lastFunctor)) {
                    eplans.appendChild(document.createElement("new-set-of-plans"));
                }
                lastFunctor = currentFunctor;
                eplans.appendChild(p.getAsDOM(document));
            }
        }
        return eplans;
    }
}

