/*
 * Decompiled with CFR 0.152.
 */
package jason.asSyntax;

import jason.asSemantics.Unifier;
import jason.asSyntax.Atom;
import jason.asSyntax.Literal;
import jason.asSyntax.Pred;
import jason.asSyntax.PredicateIndicator;
import jason.asSyntax.Term;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LiteralImpl
extends Pred {
    private static final long serialVersionUID = 1L;
    private boolean type = true;

    public LiteralImpl(String functor) {
        super(functor);
    }

    public LiteralImpl(boolean pos, String functor) {
        super(functor);
        this.type = pos;
    }

    public LiteralImpl(Literal l) {
        super(l);
        this.type = !l.negated();
    }

    protected LiteralImpl(Literal l, Unifier u) {
        super(l, u);
        this.type = !l.negated();
    }

    public LiteralImpl(boolean pos, Literal l) {
        super(l);
        this.type = pos;
    }

    public LiteralImpl(Atom namespace2, boolean pos, String functor) {
        super(namespace2, functor);
        this.type = pos;
    }

    public LiteralImpl(Atom namespace2, boolean pos, Literal l) {
        super(namespace2, l);
        this.type = pos;
    }

    @Override
    public boolean isAtom() {
        return super.isAtom() && !this.negated();
    }

    @Override
    public boolean canBeAddedInBB() {
        return true;
    }

    @Override
    public boolean negated() {
        return !this.type;
    }

    @Override
    public Literal setNegated(boolean b) {
        this.type = b;
        this.resetHashCodeCache();
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof LiteralImpl) {
            LiteralImpl l = (LiteralImpl)o;
            return this.type == l.type && this.hashCode() == l.hashCode() && super.equals(l);
        }
        if (o instanceof Atom && !this.negated()) {
            return super.equals(o);
        }
        return false;
    }

    @Override
    public String getErrorMsg() {
        String src = this.getSrcInfo() == null ? "" : " (" + this.getSrcInfo() + ")";
        return "Error in '" + this + "'" + src;
    }

    @Override
    public int compareTo(Term t) {
        if (t == null) {
            return -1;
        }
        if (t.isLiteral()) {
            Literal tl = (Literal)t;
            if (!this.negated() && tl.negated()) {
                return -1;
            }
            if (this.negated() && !tl.negated()) {
                return 1;
            }
        }
        return super.compareTo(t);
    }

    @Override
    public Term clone() {
        LiteralImpl l = new LiteralImpl(this);
        l.hashCodeCache = this.hashCodeCache;
        return l;
    }

    @Override
    public Term capply(Unifier u) {
        return new LiteralImpl((Literal)this, u);
    }

    @Override
    public Literal cloneNS(Atom newNameSpace) {
        return new LiteralImpl(newNameSpace, !this.negated(), this);
    }

    @Override
    protected int calcHashCode() {
        int result = super.calcHashCode();
        if (this.negated()) {
            result += 3271;
        }
        return result;
    }

    @Override
    public PredicateIndicator getPredicateIndicator() {
        if (this.predicateIndicatorCache == null) {
            this.predicateIndicatorCache = new PredicateIndicator(this.getNS(), this.type ? this.getFunctor() : "~" + this.getFunctor(), this.getArity());
        }
        return this.predicateIndicatorCache;
    }

    @Override
    public Element getAsDOM(Document document) {
        Element u = document.createElement("literal");
        u.setAttribute("namespace", this.getNS().getFunctor());
        if (this.negated()) {
            u.setAttribute("negated", this.negated() + "");
        }
        u.appendChild(super.getAsDOM(document));
        return u;
    }
}

