/*
 * Decompiled with CFR 0.152.
 */
package jason.asSyntax;

import jason.NoValueException;
import jason.asSemantics.Agent;
import jason.asSemantics.ArithFunction;
import jason.asSemantics.Unifier;
import jason.asSyntax.Literal;
import jason.asSyntax.LogExpr;
import jason.asSyntax.NumberTerm;
import jason.asSyntax.NumberTermImpl;
import jason.asSyntax.Structure;
import jason.asSyntax.Term;
import jason.asSyntax.VarTerm;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ArithFunctionTerm
extends Structure
implements NumberTerm {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(ArithFunctionTerm.class.getName());
    protected NumberTerm value = null;
    private ArithFunction function = null;
    private Agent agent = null;

    public ArithFunctionTerm(ArithFunction function) {
        super(function.getName(), 2);
        this.function = function;
    }

    public ArithFunctionTerm(ArithFunctionTerm af) {
        super(af);
        this.function = af.function;
        this.agent = af.agent;
    }

    public ArithFunctionTerm(String functor, int arity) {
        super(functor, arity);
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public boolean isAtom() {
        return false;
    }

    @Override
    public boolean isStructure() {
        return false;
    }

    @Override
    public boolean isLiteral() {
        return false;
    }

    @Override
    public boolean isArithExpr() {
        return true;
    }

    public void setAgent(Agent ag) {
        this.agent = ag;
    }

    public Agent getAgent() {
        return this.agent;
    }

    @Override
    public Term capply(Unifier u) {
        if (this.function == null) {
            logger.log(Level.SEVERE, this.getErrorMsg() + " -- the function can not be evalutated, it has no function assigned to it!", new Exception());
        } else {
            Term v = super.capply(u);
            if (this.function.allowUngroundTerms() || v.isGround()) {
                try {
                    this.value = new NumberTermImpl(this.function.evaluate(this.agent == null ? null : this.agent.getTS(), ((Literal)v).getTermsArray()));
                    return this.value;
                }
                catch (NoValueException e2) {
                }
                catch (Exception e3) {
                    logger.log(Level.SEVERE, this.getErrorMsg() + " -- error in evaluate!", e3);
                }
            }
        }
        return this.clone();
    }

    @Override
    public double solve() throws NoValueException {
        if (this.value == null) {
            this.capply(null);
        }
        if (this.value == null) {
            throw new NoValueException();
        }
        return this.value.solve();
    }

    public boolean checkArity(int a) {
        return this.function != null && this.function.checkArity(a);
    }

    @Override
    public Iterator<Unifier> logicalConsequence(Agent ag, Unifier un) {
        logger.log(Level.WARNING, "Arithmetic term cannot be used for logical consequence!", new Exception());
        return LogExpr.EMPTY_UNIF_LIST.iterator();
    }

    @Override
    public boolean equals(Object t) {
        if (t == null) {
            return false;
        }
        return super.equals(t);
    }

    @Override
    public int compareTo(Term o) {
        if (o instanceof VarTerm) {
            return o.compareTo(this) * -1;
        }
        return super.compareTo(o);
    }

    @Override
    public String getErrorMsg() {
        return "Error in '" + this + "' (" + super.getErrorMsg() + ")";
    }

    @Override
    public NumberTerm clone() {
        return new ArithFunctionTerm(this);
    }

    @Override
    public Element getAsDOM(Document document) {
        Element u = document.createElement("expression");
        u.setAttribute("type", "arithmetic");
        Element r = document.createElement("right");
        r.appendChild(super.getAsDOM(document));
        u.appendChild(r);
        return u;
    }
}

