/*
 * Decompiled with CFR 0.152.
 */
package jason.asSemantics;

import jason.asSyntax.ASSyntax;
import jason.asSyntax.Atom;
import jason.asSyntax.CyclicTerm;
import jason.asSyntax.ListTerm;
import jason.asSyntax.ListTermImpl;
import jason.asSyntax.Literal;
import jason.asSyntax.LiteralImpl;
import jason.asSyntax.Pred;
import jason.asSyntax.Structure;
import jason.asSyntax.Term;
import jason.asSyntax.Trigger;
import jason.asSyntax.UnnamedVar;
import jason.asSyntax.VarTerm;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Unifier
implements Cloneable,
Iterable<VarTerm> {
    private static Logger logger = Logger.getLogger(Unifier.class.getName());
    protected Map<VarTerm, Term> function = new HashMap<VarTerm, Term>();

    public Term get(String var) {
        return this.get(new VarTerm(var));
    }

    public Term remove(VarTerm v) {
        return this.function.remove(v);
    }

    @Override
    public Iterator<VarTerm> iterator() {
        return this.function.keySet().iterator();
    }

    public Term get(VarTerm vtp) {
        Term vl = this.function.get(vtp);
        if (vl != null && vl.isVar()) {
            return this.get((VarTerm)vl);
        }
        return vl;
    }

    public VarTerm getVarFromValue(Term vl) {
        for (VarTerm v : this.function.keySet()) {
            Term vvl = this.function.get(v);
            if (!vvl.equals(vl)) continue;
            return v;
        }
        return null;
    }

    public boolean unifies(Trigger te1, Trigger te2) {
        return te1.sameType(te2) && this.unifies(te1.getLiteral(), te2.getLiteral());
    }

    public boolean unifiesNoUndo(Trigger te1, Trigger te2) {
        return te1.sameType(te2) && this.unifiesNoUndo(te1.getLiteral(), te2.getLiteral());
    }

    public boolean unifies(Term t1, Term t2) {
        Map<VarTerm, Term> cfunction = this.cloneFunction();
        if (this.unifiesNoUndo(t1, t2)) {
            return true;
        }
        this.function = cfunction;
        return false;
    }

    private Map<VarTerm, Term> cloneFunction() {
        return (Map)((HashMap)this.function).clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unifiesNoUndo(Term t1g, Term t2g) {
        boolean ok;
        Pred np1 = null;
        Pred np2 = null;
        if (t1g instanceof Pred && t2g instanceof Pred) {
            np1 = (Pred)t1g;
            np2 = (Pred)t2g;
            if ((np1.isVar() && np1.hasAnnot() || np2.isVar() && np2.hasAnnot()) && !np1.hasSubsetAnnot(np2, this)) {
                return false;
            }
        }
        if (t1g.isCyclicTerm() && t2g.isCyclicTerm()) {
            VarTerm v1 = t1g.getCyclicVar();
            VarTerm v2 = t2g.getCyclicVar();
            this.remove(v1);
            this.remove(v2);
            try {
                boolean bl = this.unifiesNoUndo(new LiteralImpl((Literal)t1g), new LiteralImpl((Literal)t2g));
                return bl;
            }
            finally {
                this.function.put(v1, t1g);
                this.function.put(v2, t1g);
            }
        }
        if (t1g.isCyclicTerm() && this.get(t1g.getCyclicVar()) == null) {
            this.function.put(t1g.getCyclicVar(), t1g);
        }
        if (t2g.isCyclicTerm() && this.get(t2g.getCyclicVar()) == null) {
            this.function.put(t2g.getCyclicVar(), t2g);
        }
        if ((ok = this.unifyTerms(t1g, t2g)) && np1 != null) {
            Term np2vl;
            Pred pvl;
            Term np1vl;
            if (np1.isVar() && np1.hasAnnot() && (np1vl = this.function.get((VarTerm)(np1 = this.deref((VarTerm)np1)))) != null && np1vl.isPred()) {
                pvl = (Pred)np1vl.clone();
                pvl.clearAnnots();
                this.bind((VarTerm)np1, pvl);
            }
            if (np2.isVar() && np2.hasAnnot() && (np2vl = this.function.get((VarTerm)(np2 = this.deref((VarTerm)np2)))) != null && np2vl.isPred()) {
                pvl = (Pred)np2vl.clone();
                pvl.clearAnnots();
                this.bind((VarTerm)np2, pvl);
            }
        }
        return ok;
    }

    protected boolean unifyTerms(Term t1g, Term t2g) {
        if (t1g.isArithExpr()) {
            t1g = t1g.capply(this);
        }
        if (t2g.isArithExpr()) {
            t2g = t2g.capply(this);
        }
        boolean t1gisvar = t1g.isVar();
        boolean t2gisvar = t2g.isVar();
        if (t1gisvar || t2gisvar) {
            Term t2vl;
            VarTerm t1gv = t1gisvar ? (VarTerm)t1g : null;
            VarTerm t2gv = t2gisvar ? (VarTerm)t2g : null;
            Term t1vl = t1gisvar ? this.get(t1gv) : t1g;
            Term term = t2vl = t2gisvar ? this.get(t2gv) : t2g;
            if (t1vl != null && t2vl != null) {
                return this.unifiesNoUndo(t1vl, t2vl);
            }
            if (t1vl != null) {
                return this.bind(t2gv, t1vl);
            }
            if (t2vl != null) {
                return this.bind(t1gv, t2vl);
            }
            if (!t1gv.getNS().equals(t2gv.getNS())) {
                return false;
            }
            if (t1gv.negated() != t2gv.negated()) {
                return false;
            }
            this.bind(t1gv, t2gv);
            return true;
        }
        if (!t1g.isLiteral() && !t1g.isList() || !t2g.isLiteral() && !t2g.isList()) {
            return t1g.equals(t2g);
        }
        Literal t1s = (Literal)t1g;
        Literal t2s = (Literal)t2g;
        int ts = t1s.getArity();
        if (ts != t2s.getArity()) {
            return false;
        }
        if (t1s.negated() != t2s.negated()) {
            return false;
        }
        if (!t1s.getFunctor().equals(t2s.getFunctor())) {
            return false;
        }
        if (!this.unifiesNamespace(t1s, t2s)) {
            return false;
        }
        for (int i = 0; i < ts; ++i) {
            if (this.unifiesNoUndo(t1s.getTerm(i), t2s.getTerm(i))) continue;
            return false;
        }
        return t1s.hasSubsetAnnot(t2s, this);
    }

    private boolean unifiesNamespace(Literal t1s, Literal t2s) {
        if (t1s == Literal.DefaultNS && t2s == Literal.DefaultNS) {
            return true;
        }
        Atom nst1 = t1s == Literal.DefaultNS ? Literal.DefaultNS : t1s.getNS();
        Atom nst2 = t2s == Literal.DefaultNS ? Literal.DefaultNS : t2s.getNS();
        return this.unifiesNoUndo(nst1, nst2);
    }

    public VarTerm deref(VarTerm v) {
        Term vl = this.function.get(v);
        VarTerm first = v;
        while (vl != null && vl.isVar()) {
            v = (VarTerm)vl;
            vl = this.function.get(v);
        }
        if (first != v) {
            this.function.put(first, v);
        }
        return v;
    }

    public void bind(VarTerm vt1, VarTerm vt2) {
        int comp = (vt1 = this.getVarForUnifier(vt1)).compareTo(vt2 = this.getVarForUnifier(vt2));
        if (comp < 0) {
            this.function.put(vt1, vt2);
        } else if (comp > 0) {
            this.function.put(vt2, vt1);
        }
    }

    public boolean bind(VarTerm vt, Term vl) {
        if (vt.negated()) {
            if (!vl.isLiteral() || !((Literal)vl).negated()) {
                return false;
            }
            vl = (Literal)vl.clone();
            ((Literal)vl).setNegated(true);
        }
        if (vl.isLiteral()) {
            Literal lvl = (Literal)vl;
            if (!this.unifiesNamespace(vt, lvl)) {
                return false;
            }
            if (lvl.getFunctor().startsWith("#")) {
                return false;
            }
            if (lvl.getNS() != Literal.DefaultNS) {
                vl = lvl.cloneNS(Literal.DefaultNS);
            }
        }
        if (!vl.isCyclicTerm() && vl.hasVar(vt, this)) {
            vl = new CyclicTerm((Literal)vl, (VarTerm)vt.clone());
        }
        this.function.put(this.getVarForUnifier(vt), vl);
        return true;
    }

    private VarTerm getVarForUnifier(VarTerm v) {
        v = (VarTerm)this.deref(v).cloneNS(Literal.DefaultNS);
        v.setNegated(true);
        return v;
    }

    public void clear() {
        this.function.clear();
    }

    public String toString() {
        return this.function.toString();
    }

    public Term getAsTerm() {
        ListTermImpl lf;
        ListTerm tail = lf = new ListTermImpl();
        for (VarTerm k : this.function.keySet()) {
            Term vl = this.function.get(k).clone();
            if (vl instanceof Literal) {
                ((Literal)vl).makeVarsAnnon();
            }
            Structure pair = ASSyntax.createStructure("map", UnnamedVar.create(k.toString()), vl);
            tail = tail.append(pair);
        }
        return lf;
    }

    public int size() {
        return this.function.size();
    }

    public void compose(Unifier u) {
        for (VarTerm k : u.function.keySet()) {
            Term current = this.get(k);
            Term kValue = u.function.get(k);
            if (current != null && (current.isVar() || kValue.isVar())) {
                this.unifies(kValue, current);
                continue;
            }
            this.function.put((VarTerm)k.clone(), kValue.clone());
        }
    }

    public Unifier clone() {
        try {
            Unifier newUn = new Unifier();
            newUn.function = this.cloneFunction();
            return newUn;
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error cloning unifier.", e2);
            return null;
        }
    }

    public int hashCode() {
        int s = 0;
        for (VarTerm v : this.function.keySet()) {
            s += v.hashCode();
        }
        return s * 31;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof Unifier) {
            return this.function.equals(((Unifier)o).function);
        }
        return false;
    }

    public Element getAsDOM(Document document) {
        Element u = document.createElement("unifier");
        for (VarTerm v : this.function.keySet()) {
            Element ev = v.getAsDOM(document);
            Element vl = document.createElement("value");
            vl.appendChild(this.function.get(v).getAsDOM(document));
            Element map = document.createElement("map");
            map.appendChild(ev);
            map.appendChild(vl);
            u.appendChild(map);
        }
        return u;
    }
}

