/*
 * Decompiled with CFR 0.152.
 */
package jason.asSemantics;

import jason.JasonException;
import jason.NoValueException;
import jason.RevisionFailedException;
import jason.architecture.AgArch;
import jason.asSemantics.ActionExec;
import jason.asSemantics.Agent;
import jason.asSemantics.Circumstance;
import jason.asSemantics.CircumstanceListener;
import jason.asSemantics.Event;
import jason.asSemantics.GoalListener;
import jason.asSemantics.GoalListenerForMetaEvents;
import jason.asSemantics.IntendedMeans;
import jason.asSemantics.Intention;
import jason.asSemantics.InternalAction;
import jason.asSemantics.Message;
import jason.asSemantics.Option;
import jason.asSemantics.Unifier;
import jason.asSyntax.ASSyntax;
import jason.asSyntax.Atom;
import jason.asSyntax.BinaryStructure;
import jason.asSyntax.DefaultTerm;
import jason.asSyntax.InternalActionLiteral;
import jason.asSyntax.ListTerm;
import jason.asSyntax.ListTermImpl;
import jason.asSyntax.Literal;
import jason.asSyntax.LiteralImpl;
import jason.asSyntax.LogicalFormula;
import jason.asSyntax.NumberTerm;
import jason.asSyntax.NumberTermImpl;
import jason.asSyntax.Plan;
import jason.asSyntax.PlanBody;
import jason.asSyntax.PlanLibrary;
import jason.asSyntax.StringTermImpl;
import jason.asSyntax.Structure;
import jason.asSyntax.Term;
import jason.asSyntax.Trigger;
import jason.asSyntax.UnnamedVar;
import jason.asSyntax.VarTerm;
import jason.asSyntax.parser.ParseException;
import jason.bb.BeliefBase;
import jason.runtime.Settings;
import jason.stdlib.add_nested_source;
import jason.stdlib.desire;
import jason.stdlib.fail_goal;
import jason.util.Config;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TransitionSystem {
    private Logger logger = null;
    private Agent ag = null;
    private AgArch agArch = null;
    private Circumstance C = null;
    private Settings setts = null;
    private State stepSense = State.StartRC;
    private State stepDeliberate = State.SelEv;
    private State stepAct = State.ProcAct;
    private int nrcslbr = 1;
    private boolean sleepingEvt = false;
    private List<GoalListener> goalListeners = null;
    private TransitionSystem confP;
    private TransitionSystem conf;
    private Queue<Runnable> taskForBeginOfCycle = new ConcurrentLinkedQueue<Runnable>();
    private Map<GoalListener, CircumstanceListener> listenersMap;
    private final String kqmlReceivedFunctor = Config.get().getKqmlFunctor();
    private static final Atom aNOCODE = new Atom("no_code");

    public TransitionSystem(Agent a, Circumstance c, Settings s, AgArch ar) {
        this.ag = a;
        this.agArch = ar;
        this.setts = s == null ? new Settings() : s;
        this.C = c == null ? new Circumstance() : c;
        this.C.setTS(this);
        this.conf = this.confP = this;
        this.nrcslbr = this.setts.nrcbp();
        this.setLogger(this.agArch);
        if (this.setts != null && this.setts.verbose() >= 0) {
            this.logger.setLevel(this.setts.logLevel());
        }
        if (a != null) {
            a.setTS(this);
        }
        if (ar != null) {
            ar.setTS(this);
        }
    }

    public void setLogger(AgArch arch) {
        this.logger = arch != null ? Logger.getLogger(TransitionSystem.class.getName() + "." + arch.getAgName()) : Logger.getLogger(TransitionSystem.class.getName());
    }

    public void setLogger(Logger l) {
        this.logger = l;
    }

    public void addGoalListener(final GoalListener gl) {
        if (this.goalListeners == null) {
            this.goalListeners = new ArrayList<GoalListener>();
            this.listenersMap = new HashMap<GoalListener, CircumstanceListener>();
        } else {
            for (GoalListener g : this.goalListeners) {
                if (!(g instanceof GoalListenerForMetaEvents)) continue;
                return;
            }
        }
        CircumstanceListener cl = new CircumstanceListener(){

            @Override
            public void intentionDropped(Intention i) {
                for (IntendedMeans im : i) {
                    if (!im.getTrigger().isAddition() || !im.getTrigger().isGoal()) continue;
                    gl.goalFinished(im.getTrigger(), GoalListener.FinishStates.dropped);
                }
            }

            @Override
            public void intentionSuspended(Intention i, String reason) {
                for (IntendedMeans im : i) {
                    if (!im.getTrigger().isAddition() || !im.getTrigger().isGoal()) continue;
                    gl.goalSuspended(im.getTrigger(), reason);
                }
            }

            @Override
            public void intentionResumed(Intention i) {
                for (IntendedMeans im : i) {
                    if (!im.getTrigger().isAddition() || !im.getTrigger().isGoal()) continue;
                    gl.goalResumed(im.getTrigger());
                }
            }

            @Override
            public void eventAdded(Event e2) {
                if (e2.getTrigger().isAddition() && e2.getTrigger().isGoal()) {
                    gl.goalStarted(e2);
                }
            }

            @Override
            public void intentionAdded(Intention i) {
            }
        };
        this.C.addEventListener(cl);
        this.listenersMap.put(gl, cl);
        this.goalListeners.add(gl);
    }

    public boolean hasGoalListener() {
        return this.goalListeners != null && !this.goalListeners.isEmpty();
    }

    public List<GoalListener> getGoalListeners() {
        return this.goalListeners;
    }

    public boolean removeGoalListener(GoalListener gl) {
        CircumstanceListener cl = this.listenersMap.get(gl);
        if (cl != null) {
            this.C.removeEventListener(cl);
        }
        return this.goalListeners.remove(gl);
    }

    private void applySemanticRuleSense() throws JasonException {
        switch (this.stepSense) {
            case StartRC: {
                this.applyProcMsg();
                break;
            }
        }
    }

    private void applySemanticRuleDeliberate() throws JasonException {
        switch (this.stepDeliberate) {
            case SelEv: {
                this.applySelEv();
                break;
            }
            case RelPl: {
                this.applyRelPl();
                break;
            }
            case ApplPl: {
                this.applyApplPl();
                break;
            }
            case SelAppl: {
                this.applySelAppl();
                break;
            }
            case FindOp: {
                this.applyFindOp();
                break;
            }
            case AddIM: {
                this.applyAddIM();
                break;
            }
        }
    }

    private void applySemanticRuleAct() throws JasonException {
        switch (this.stepAct) {
            case ProcAct: {
                this.applyProcAct();
                break;
            }
            case SelInt: {
                this.applySelInt();
                break;
            }
            case ExecInt: {
                this.applyExecInt();
                break;
            }
            case ClrInt: {
                this.confP.stepAct = State.StartRC;
                this.applyClrInt(this.conf.C.SI);
                break;
            }
        }
    }

    private void applyProcMsg() throws JasonException {
        this.confP.stepSense = State.SelEv;
        if (this.conf.C.hasMsg()) {
            Message m = this.conf.ag.selectMessage(this.conf.C.getMailBox());
            if (m == null) {
                return;
            }
            Term content = null;
            if (m.getPropCont() instanceof Term) {
                content = (Term)m.getPropCont();
            } else {
                try {
                    content = ASSyntax.parseTerm(m.getPropCont().toString());
                }
                catch (ParseException e2) {
                    this.logger.warning("The content of the message '" + m.getPropCont() + "' is not a term!");
                    return;
                }
            }
            Intention intention = null;
            if (m.getInReplyTo() != null) {
                intention = this.getC().getPendingIntentions().get(m.getInReplyTo());
            }
            if (intention != null) {
                Structure send2 = (Structure)intention.peek().getCurrentStep().getBodyTerm();
                if (m.isUnTell() && send2.getTerm(1).toString().equals("askOne")) {
                    content = Literal.LFalse;
                } else if (content.isLiteral()) {
                    content = ((Literal)content).forceFullLiteralImpl();
                    ((Literal)content).addSource(new Atom(m.getSender()));
                } else if (send2.getTerm(1).toString().equals("askAll") && content.isList()) {
                    ListTermImpl tail = new ListTermImpl();
                    for (Term t : (ListTerm)content) {
                        if (t.isLiteral()) {
                            t = ((Literal)t).forceFullLiteralImpl();
                            ((Literal)t).addSource(new Atom(m.getSender()));
                        }
                        tail.append(t);
                    }
                    content = tail;
                }
                Unifier un = intention.peek().getUnif();
                Term rec = send2.getTerm(0).capply(un);
                if (rec.isList()) {
                    VarTerm answers = new VarTerm("AnsList___" + m.getInReplyTo());
                    ListTerm listOfAnswers = (ListTerm)un.get(answers);
                    if (listOfAnswers == null) {
                        listOfAnswers = new ListTermImpl();
                        un.unifies(answers, listOfAnswers);
                    }
                    listOfAnswers.append(content);
                    int nbReceivers = ((ListTerm)send2.getTerm(0)).size();
                    if (listOfAnswers.size() == nbReceivers) {
                        this.resumeSyncAskIntention(m.getInReplyTo(), send2.getTerm(3), listOfAnswers);
                    }
                } else {
                    this.resumeSyncAskIntention(m.getInReplyTo(), send2.getTerm(3), content);
                }
            } else if (this.conf.ag.socAcc(m)) {
                if (!m.isReplyToSyncAsk()) {
                    String sender = m.getSender();
                    if (sender.equals(this.getUserAgArch().getAgName())) {
                        sender = "self";
                    }
                    boolean added = false;
                    if (!this.setts.isSync() && !this.ag.getPL().hasUserKqmlReceivedPlans() && content.isLiteral() && !content.isList()) {
                        if (m.getIlForce().equals("achieve")) {
                            content = add_nested_source.addAnnotToList(content, new Atom(sender));
                            this.C.addEvent(new Event(new Trigger(Trigger.TEOperator.add, Trigger.TEType.achieve, (Literal)content), Intention.EmptyInt));
                            added = true;
                        } else if (m.getIlForce().equals("tell")) {
                            content = add_nested_source.addAnnotToList(content, new Atom(sender));
                            this.getAg().addBel((Literal)content);
                            added = true;
                        }
                    }
                    if (!added) {
                        Literal received = new LiteralImpl(this.kqmlReceivedFunctor).addTerms(new Atom(sender), new Atom(m.getIlForce()), content, new Atom(m.getMsgId()));
                        this.updateEvents(new Event(new Trigger(Trigger.TEOperator.add, Trigger.TEType.achieve, received), Intention.EmptyInt));
                    }
                } else {
                    this.logger.fine("Ignoring message " + m + " because it is received after the timeout.");
                }
            }
        }
    }

    private void resumeSyncAskIntention(String msgId, Term answerVar, Term answerValue) throws JasonException {
        Intention i = this.getC().removePendingIntention(msgId);
        i.peek().removeCurrentStep();
        if (i.peek().getUnif().unifies(answerVar, answerValue)) {
            this.getC().resumeIntention(i);
        } else {
            this.generateGoalDeletion(i, JasonException.createBasicErrorAnnots("ask_failed", "reply of an ask message ('" + answerValue + "') does not unify with fourth argument of .send ('" + answerVar + "')"));
        }
    }

    private void applySelEv() throws JasonException {
        if (this.C.hasAtomicIntention()) {
            this.confP.stepDeliberate = State.ProcAct;
            return;
        }
        this.confP.C.SE = this.C.removeAtomicEvent();
        if (this.confP.C.SE != null) {
            this.confP.stepDeliberate = State.RelPl;
            return;
        }
        if (this.conf.C.hasEvent()) {
            this.confP.C.SE = this.conf.ag.selectEvent(this.confP.C.getEvents());
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Selected event " + this.confP.C.SE);
            }
            if (this.confP.C.SE != null) {
                this.confP.stepDeliberate = this.ag.hasCustomSelectOption() || this.setts.verbose() == 2 ? State.RelPl : State.FindOp;
                return;
            }
        }
        this.confP.stepDeliberate = State.ProcAct;
    }

    private void applyRelPl() throws JasonException {
        this.confP.C.RP = this.relevantPlans(this.conf.C.SE.trigger);
        if (this.confP.C.RP != null || this.setts.retrieve()) {
            this.confP.stepDeliberate = State.ApplPl;
        } else {
            this.applyRelApplPlRule2("relevant");
        }
    }

    private void applyApplPl() throws JasonException {
        this.confP.C.AP = this.applicablePlans(this.confP.C.RP);
        if (this.confP.C.AP != null || this.setts.retrieve()) {
            this.confP.stepDeliberate = State.SelAppl;
        } else {
            this.applyRelApplPlRule2("applicable");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void applyRelApplPlRule2(String m) throws JasonException {
        this.confP.stepDeliberate = State.ProcAct;
        if (this.conf.C.SE.trigger.isGoal() && !this.conf.C.SE.trigger.isMetaEvent()) {
            try {
                if (this.conf.C.SE.getIntention() != null && this.conf.C.SE.getIntention().size() > 3000) {
                    this.logger.warning("we are likely in a problem with event " + this.conf.C.SE.getTrigger() + " the intention stack has already " + this.conf.C.SE.getIntention().size() + " intended means!");
                }
                String msg = "Found a goal for which there is no " + m + " plan:" + this.conf.C.SE.getTrigger();
                if (this.generateGoalDeletionFromEvent(JasonException.createBasicErrorAnnots("no_" + m, msg))) return;
                this.logger.warning(msg);
                return;
            }
            catch (Exception e2) {
                e2.printStackTrace();
                return;
            }
        } else if (this.conf.C.SE.isInternal()) {
            Intention i = this.conf.C.SE.intention;
            this.joinRenamedVarsIntoIntentionUnifier(i.peek(), i.peek().unif);
            this.updateIntention(i);
            return;
        } else if (this.setts.requeue()) {
            this.confP.C.addEvent(this.conf.C.SE);
            return;
        } else {
            this.confP.stepDeliberate = State.SelEv;
        }
    }

    private void applySelAppl() throws JasonException {
        this.confP.C.SO = this.conf.ag.selectOption(this.confP.C.AP);
        if (this.confP.C.SO != null) {
            this.confP.stepDeliberate = State.AddIM;
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Selected option " + this.confP.C.SO + " for event " + this.confP.C.SE);
            }
        } else {
            this.logger.fine("** selectOption returned null!");
            this.generateGoalDeletionFromEvent(JasonException.createBasicErrorAnnots("no_option", "selectOption returned null"));
            this.confP.stepDeliberate = State.ProcAct;
        }
    }

    private void applyFindOp() throws JasonException {
        this.confP.stepDeliberate = State.AddIM;
        List<Plan> candidateRPs = this.conf.ag.pl.getCandidatePlans(this.conf.C.SE.trigger);
        if (candidateRPs != null) {
            for (Plan pl : candidateRPs) {
                Unifier relUn = pl.isRelevant(this.conf.C.SE.trigger);
                if (relUn == null) continue;
                LogicalFormula context = pl.getContext();
                if (context == null) {
                    this.confP.C.SO = new Option(pl, relUn);
                    return;
                }
                Iterator<Unifier> r = context.logicalConsequence(this.ag, relUn);
                if (r == null || !r.hasNext()) continue;
                this.confP.C.SO = new Option(pl, r.next());
                return;
            }
            this.applyRelApplPlRule2("applicable");
        } else {
            this.applyRelApplPlRule2("relevant");
        }
    }

    private void applyAddIM() throws JasonException {
        IntendedMeans im = new IntendedMeans(this.conf.C.SO, this.conf.C.SE.getTrigger());
        if (this.conf.C.SE.intention == Intention.EmptyInt) {
            Intention intention = new Intention();
            intention.push(im);
            this.confP.C.addIntention(intention);
        } else {
            IntendedMeans top;
            if (this.setts.isTROon() && (top = this.confP.C.SE.intention.peek()) != null && top.getTrigger().isGoal() && im.getTrigger().isGoal() && top.getCurrentStep().getBodyNext() == null && top.getTrigger().getPredicateIndicator().equals(im.getTrigger().getPredicateIndicator())) {
                this.confP.C.SE.intention.pop();
                IntendedMeans imBase = this.confP.C.SE.intention.peek();
                if (imBase != null) {
                    for (VarTerm v : imBase.renamedVars) {
                        VarTerm vvl = (VarTerm)imBase.renamedVars.function.get(v);
                        Term t = top.unif.get(vvl);
                        if (t != null) {
                            if (t instanceof Literal) {
                                Literal l = (Literal)t.capply(top.unif);
                                l.makeVarsAnnon(top.renamedVars);
                                im.unif.function.put(vvl, l);
                                continue;
                            }
                            im.unif.function.put(vvl, t);
                            continue;
                        }
                        VarTerm v0 = (VarTerm)top.renamedVars.function.get(vvl);
                        if (v0 == null) continue;
                        imBase.renamedVars.function.put(v, v0);
                    }
                }
            }
            this.confP.C.SE.intention.push(im);
            this.confP.C.addIntention(this.confP.C.SE.intention);
        }
        this.confP.stepDeliberate = State.ProcAct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyProcAct() throws JasonException {
        this.confP.stepAct = State.SelInt;
        if (this.conf.C.hasFeedbackAction()) {
            ActionExec a = null;
            List<ActionExec> list2 = this.conf.C.getFeedbackActions();
            synchronized (list2) {
                a = this.conf.ag.selectAction(this.conf.C.getFeedbackActions());
            }
            if (a != null) {
                Intention curInt = a.getIntention();
                if (this.C.removePendingAction(curInt.getId()) != null) {
                    if (a.getResult()) {
                        this.updateIntention(curInt);
                        this.applyClrInt(curInt);
                        if (this.hasGoalListener()) {
                            for (GoalListener gl : this.getGoalListeners()) {
                                for (IntendedMeans im : curInt) {
                                    gl.goalResumed(im.getTrigger());
                                }
                            }
                        }
                    } else {
                        String reason = a.getFailureMsg();
                        if (reason == null) {
                            reason = "";
                        }
                        ListTerm annots = JasonException.createBasicErrorAnnots("action_failed", reason);
                        if (a.getFailureReason() != null) {
                            annots.append(a.getFailureReason());
                        }
                        this.generateGoalDeletion(curInt, annots);
                        this.C.removeAtomicIntention();
                    }
                } else {
                    this.applyProcAct();
                }
            }
        }
    }

    private void applySelInt() throws JasonException {
        this.confP.stepAct = State.ExecInt;
        this.confP.C.SI = this.C.removeAtomicIntention();
        if (this.confP.C.SI != null) {
            return;
        }
        if (!this.conf.C.isAtomicIntentionSuspended() && this.conf.C.hasIntention()) {
            this.confP.C.SI = this.conf.ag.selectIntention(this.conf.C.getIntentions());
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Selected intention " + this.confP.C.SI);
            }
            if (this.confP.C.SI != null) {
                return;
            }
        }
        this.confP.stepAct = State.StartRC;
    }

    private void applyExecInt() throws JasonException {
        this.confP.stepAct = State.ClrInt;
        Intention curInt = this.conf.C.SI;
        if (curInt == null) {
            return;
        }
        if (curInt.isFinished()) {
            return;
        }
        IntendedMeans im = curInt.peek();
        if (im.isFinished()) {
            this.updateIntention(curInt);
            return;
        }
        Unifier u = im.unif;
        PlanBody h = im.getCurrentStep();
        Term bTerm = h.getBodyTerm();
        if (bTerm instanceof VarTerm) {
            if ((bTerm = bTerm.capply(u)).isVar()) {
                String msg = h.getSrcInfo() + ": " + "Variable '" + bTerm + "' must be ground.";
                if (!this.generateGoalDeletion(curInt, JasonException.createBasicErrorAnnots("body_var_without_value", msg))) {
                    this.logger.log(Level.SEVERE, msg);
                }
                return;
            }
            if (bTerm.isPlanBody() && h.getBodyType() != PlanBody.BodyType.action) {
                String msg = h.getSrcInfo() + ": " + "The operator '" + (Object)((Object)h.getBodyType()) + "' is lost with the variable '" + bTerm + "' unified with a plan body. ";
                if (!this.generateGoalDeletion(curInt, JasonException.createBasicErrorAnnots("body_var_with_op", msg))) {
                    this.logger.log(Level.SEVERE, msg);
                }
                return;
            }
        }
        if (bTerm.isPlanBody()) {
            h = (PlanBody)bTerm;
            if (h.getPlanSize() > 1) {
                h = (PlanBody)bTerm.clone();
                h.add(im.getCurrentStep().getBodyNext());
                im.insertAsNextStep(h.getBodyNext());
            }
            bTerm = h.getBodyTerm();
        }
        Literal body = null;
        if (bTerm instanceof Literal) {
            body = (Literal)bTerm;
        }
        switch (h.getBodyType()) {
            case none: {
                break;
            }
            case action: {
                body = (Literal)body.capply(u);
                this.confP.C.A = new ActionExec(body, curInt);
                break;
            }
            case internalAction: {
                boolean ok = false;
                ListTerm errorAnnots = null;
                try {
                    InternalAction ia = ((InternalActionLiteral)bTerm).getIA(this.ag);
                    Term[] terms = ia.prepareArguments(body, u);
                    Object oresult = ia.execute(this, u, terms);
                    if (oresult != null) {
                        Iterator iu;
                        boolean bl = ok = oresult instanceof Boolean && (Boolean)oresult != false;
                        if (!ok && oresult instanceof Iterator && (iu = (Iterator)oresult).hasNext()) {
                            im.unif = (Unifier)iu.next();
                            ok = true;
                        }
                        if (!ok) {
                            errorAnnots = JasonException.createBasicErrorAnnots("ia_failed", "");
                        }
                    }
                    if (ok && !ia.suspendIntention()) {
                        this.updateIntention(curInt);
                    }
                }
                catch (JasonException e2) {
                    errorAnnots = e2.getErrorTerms();
                    if (!this.generateGoalDeletion(curInt, errorAnnots)) {
                        this.logger.log(Level.SEVERE, body.getErrorMsg() + ": " + e2.getMessage());
                    }
                    ok = true;
                }
                catch (Exception e3) {
                    if (body == null) {
                        this.logger.log(Level.SEVERE, "Selected an intention with null body in '" + h + "' and IM " + im, e3);
                    }
                    this.logger.log(Level.SEVERE, body.getErrorMsg() + ": " + e3.getMessage(), e3);
                }
                if (ok) break;
                this.generateGoalDeletion(curInt, errorAnnots);
                break;
            }
            case constraint: {
                Iterator<Unifier> iu = ((LogicalFormula)bTerm).logicalConsequence(this.ag, u);
                if (iu.hasNext()) {
                    im.unif = iu.next();
                    this.updateIntention(curInt);
                    break;
                }
                String msg = "Constraint " + h + " was not satisfied (" + h.getSrcInfo() + ") un=" + u;
                this.generateGoalDeletion(curInt, JasonException.createBasicErrorAnnots(new Atom("constraint_failed"), msg));
                this.logger.fine(msg);
                break;
            }
            case achieve: {
                body = this.prepareBodyForEvent(body, u, curInt.peek());
                Event evt = this.conf.C.addAchvGoal(body, curInt);
                this.confP.stepAct = State.StartRC;
                this.checkHardDeadline(evt);
                break;
            }
            case achieveNF: {
                body = this.prepareBodyForEvent(body, u, null);
                Event evt = this.conf.C.addAchvGoal(body, Intention.EmptyInt);
                this.checkHardDeadline(evt);
                this.updateIntention(curInt);
                break;
            }
            case test: {
                LogicalFormula f = (LogicalFormula)bTerm;
                if (this.conf.ag.believes(f, u)) {
                    this.updateIntention(curInt);
                    break;
                }
                boolean fail2 = true;
                if (f.isLiteral() && !(f instanceof BinaryStructure) && (body = this.prepareBodyForEvent(body, u, curInt.peek())).isLiteral()) {
                    Trigger te = new Trigger(Trigger.TEOperator.add, Trigger.TEType.test, body);
                    Event evt = new Event(te, curInt);
                    if (this.ag.getPL().hasCandidatePlan(te)) {
                        if (this.logger.isLoggable(Level.FINE)) {
                            this.logger.fine("Test Goal '" + h + "' failed as simple query. Generating internal event for it: " + te);
                        }
                        this.conf.C.addEvent(evt);
                        this.confP.stepAct = State.StartRC;
                        fail2 = false;
                    }
                }
                if (!fail2) break;
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("Test '" + h + "' failed (" + h.getSrcInfo() + ").");
                }
                this.generateGoalDeletion(curInt, JasonException.createBasicErrorAnnots("test_goal_failed", "Failed to test '" + h + "'"));
                break;
            }
            case delAddBel: {
                Literal b2 = this.prepareBodyForEvent(body, u, curInt.peek());
                b2.makeTermsAnnon();
                try {
                    List<Literal>[] result = this.ag.brf(null, b2, curInt);
                    if (result != null) {
                        this.updateEvents(result, Intention.EmptyInt);
                    }
                }
                catch (RevisionFailedException re) {
                    this.generateGoalDeletion(curInt, JasonException.createBasicErrorAnnots("belief_revision_failed", "BRF failed for '" + body + "'"));
                    break;
                }
            }
            case addBel: 
            case addBelBegin: 
            case addBelEnd: 
            case addBelNewFocus: {
                boolean isSameFocus;
                Intention newfocus = Intention.EmptyInt;
                boolean bl = isSameFocus = this.setts.sameFocus() && h.getBodyType() != PlanBody.BodyType.addBelNewFocus;
                if (isSameFocus) {
                    newfocus = curInt;
                    body = this.prepareBodyForEvent(body, u, newfocus.peek());
                } else {
                    body = this.prepareBodyForEvent(body, u, null);
                }
                try {
                    List<Literal>[] result = h.getBodyType() == PlanBody.BodyType.addBelEnd ? this.ag.brf(body, null, curInt, true) : this.ag.brf(body, null, curInt);
                    if (result != null) {
                        this.updateEvents(result, newfocus);
                        if (isSameFocus) break;
                        this.updateIntention(curInt);
                        break;
                    }
                    this.updateIntention(curInt);
                }
                catch (RevisionFailedException re) {
                    this.generateGoalDeletion(curInt, null);
                }
                break;
            }
            case delBel: {
                Intention newfocus = Intention.EmptyInt;
                if (this.setts.sameFocus()) {
                    newfocus = curInt;
                    body = this.prepareBodyForEvent(body, u, newfocus.peek());
                } else {
                    body = this.prepareBodyForEvent(body, u, null);
                }
                try {
                    List<Literal>[] result = this.ag.brf(null, body, curInt);
                    if (result != null) {
                        this.updateEvents(result, newfocus);
                        if (this.setts.sameFocus()) break;
                        this.updateIntention(curInt);
                        break;
                    }
                    this.updateIntention(curInt);
                    break;
                }
                catch (RevisionFailedException re) {
                    this.generateGoalDeletion(curInt, null);
                }
            }
        }
    }

    private Literal prepareBodyForEvent(Literal body, Unifier u, IntendedMeans imRenamedVars) {
        body = (Literal)body.capply(u);
        Unifier renamedVars = new Unifier();
        body.makeVarsAnnon(renamedVars);
        if (imRenamedVars != null) {
            imRenamedVars.renamedVars = renamedVars;
            if (this.setts.isTROon()) {
                HashMap<VarTerm, Term> adds = null;
                for (VarTerm v : renamedVars) {
                    Term t = u.function.get(v);
                    if (t == null || !t.isVar()) continue;
                    if (adds == null) {
                        adds = new HashMap<VarTerm, Term>();
                    }
                    try {
                        adds.put((VarTerm)t, renamedVars.function.get(v));
                    }
                    catch (Exception e2) {
                        this.logger.log(Level.SEVERE, "*** Error adding var into renamed vars. var=" + v + ", value=" + t + ".", e2);
                    }
                }
                if (adds != null) {
                    renamedVars.function.putAll(adds);
                }
            }
        }
        if (!(body = body.forceFullLiteralImpl()).hasSource()) {
            body.addAnnot(BeliefBase.TSelf);
        }
        return body;
    }

    public void applyClrInt(Intention i) throws JasonException {
        while (i != null) {
            if (i.isFinished()) {
                this.confP.C.dropIntention(i);
                return;
            }
            IntendedMeans im = i.peek();
            if (!im.isFinished()) {
                return;
            }
            IntendedMeans topIM = i.pop();
            Trigger topTrigger = topIM.getTrigger();
            Literal topLiteral = topTrigger.getLiteral();
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Returning from IM " + topIM.getPlan().getLabel() + ", te=" + topTrigger + " unif=" + topIM.unif);
            }
            if (!topTrigger.isMetaEvent() && topTrigger.isGoal() && this.hasGoalListener()) {
                for (GoalListener gl : this.goalListeners) {
                    gl.goalFinished(topTrigger, GoalListener.FinishStates.achieved);
                }
            }
            if (im.getTrigger().isGoal() && !im.getTrigger().isAddition() && !i.isFinished()) {
                im = i.peek();
                if (im.isFinished() || !im.unif.unifies(im.getCurrentStep().getBodyTerm(), topLiteral) || im.getCurrentStep().getBodyType() != PlanBody.BodyType.achieve || im.getCurrentStep().getBodyTerm() instanceof VarTerm) {
                    im = i.pop();
                }
                while (!(i.isFinished() || im.unif.unifies(im.getTrigger().getLiteral(), topLiteral) && im.getTrigger().isGoal() || im.unif.unifies(im.getCurrentStep().getBodyTerm(), topLiteral) && im.getCurrentStep().getBodyType() == PlanBody.BodyType.achieve)) {
                    im = i.pop();
                }
            }
            if (i.isFinished() || (im = i.peek()).isFinished()) continue;
            this.joinRenamedVarsIntoIntentionUnifier(im, topIM.unif);
            im.removeCurrentStep();
        }
        return;
    }

    private void joinRenamedVarsIntoIntentionUnifier(IntendedMeans im, Unifier values) {
        if (im.renamedVars != null) {
            for (VarTerm ov : im.renamedVars.function.keySet()) {
                UnnamedVar vt = (UnnamedVar)im.renamedVars.function.get(ov);
                im.unif.unifiesNoUndo(ov, vt);
                Term vl = values.function.get(vt);
                if (vl == null) continue;
                if ((vl = vl.capply(values)).isLiteral()) {
                    ((Literal)vl).makeVarsAnnon();
                }
                im.unif.bind((VarTerm)vt, vl);
            }
        }
    }

    public List<Option> relevantPlans(Trigger teP) throws JasonException {
        Trigger te = teP.clone();
        LinkedList<Option> rp = null;
        List<Plan> candidateRPs = this.conf.ag.pl.getCandidatePlans(te);
        if (candidateRPs != null) {
            for (Plan pl : candidateRPs) {
                Unifier relUn = pl.isRelevant(te);
                if (relUn == null) continue;
                if (rp == null) {
                    rp = new LinkedList<Option>();
                }
                rp.add(new Option(pl, relUn));
            }
        }
        return rp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Option> applicablePlans(List<Option> rp) throws JasonException {
        Object object = this.C.syncApPlanSense;
        synchronized (object) {
            LinkedList<Option> ap = null;
            if (rp != null) {
                block3: for (Option opt : rp) {
                    LogicalFormula context = opt.getPlan().getContext();
                    if (context == null) {
                        if (ap == null) {
                            ap = new LinkedList<Option>();
                        }
                        ap.add(opt);
                        continue;
                    }
                    boolean allUnifs = opt.getPlan().isAllUnifs();
                    Iterator<Unifier> r = context.logicalConsequence(this.ag, opt.getUnifier());
                    if (r == null) continue;
                    while (r.hasNext()) {
                        opt.setUnifier(r.next());
                        if (ap == null) {
                            ap = new LinkedList();
                        }
                        ap.add(opt);
                        if (!allUnifs) continue block3;
                        if (!r.hasNext()) continue;
                        opt = new Option(opt.getPlan(), null);
                    }
                }
            }
            return ap;
        }
    }

    public void updateEvents(List<Literal>[] result, Intention focus) {
        Trigger te;
        if (result == null) {
            return;
        }
        for (Literal ladd : result[0]) {
            te = new Trigger(Trigger.TEOperator.add, Trigger.TEType.belief, ladd);
            this.updateEvents(new Event(te, focus));
            focus = Intention.EmptyInt;
        }
        for (Literal lrem : result[1]) {
            te = new Trigger(Trigger.TEOperator.del, Trigger.TEType.belief, lrem);
            this.updateEvents(new Event(te, focus));
            focus = Intention.EmptyInt;
        }
    }

    public void updateEvents(Event e2) {
        if (e2.isInternal() || this.C.hasListener() || this.ag.getPL().hasCandidatePlan(e2.trigger)) {
            this.C.addEvent(e2);
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Added event " + e2 + ", events = " + this.C.getEvents());
            }
        }
    }

    private void updateIntention(Intention i) {
        if (!i.isFinished()) {
            i.peek().removeCurrentStep();
            this.confP.C.addIntention(i);
        } else {
            this.logger.fine("trying to update a finished intention!");
        }
    }

    public boolean generateGoalDeletion(Intention i, List<Term> failAnnots) throws JasonException {
        boolean failEventIsRelevant = false;
        IntendedMeans im = i.peek();
        Event failEvent = this.findEventForFailure(i, im.getTrigger());
        if (failEvent != null) {
            failEventIsRelevant = true;
        } else {
            failEvent = new Event(im.getTrigger().clone(), i);
        }
        Term bodyPart = im.getCurrentStep().getBodyTerm().capply(im.unif);
        TransitionSystem.setDefaultFailureAnnots(failEvent, bodyPart, failAnnots);
        if (im.isGoalAdd()) {
            if (this.hasGoalListener()) {
                for (GoalListener gl : this.goalListeners) {
                    gl.goalFailed(im.getTrigger());
                    if (failEventIsRelevant) continue;
                    gl.goalFinished(im.getTrigger(), GoalListener.FinishStates.unachieved);
                }
            }
            if (failEventIsRelevant) {
                this.confP.C.addEvent(failEvent);
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("Generating goal deletion " + failEvent.getTrigger() + " from goal: " + im.getTrigger());
                }
            } else {
                this.logger.warning("No failure event was generated for " + failEvent.getTrigger());
                i.fail(this.getC());
            }
        } else if (this.setts.requeue()) {
            im = i.peek();
            this.confP.C.addExternalEv(im.getTrigger());
        } else {
            this.logger.warning("Could not finish intention: " + i + "\tTrigger: " + failEvent.getTrigger());
        }
        return failEventIsRelevant;
    }

    private boolean generateGoalDeletionFromEvent(List<Term> failAnnots) throws JasonException {
        Event ev = this.conf.C.SE;
        if (ev == null) {
            this.logger.warning("** It was impossible to generate a goal deletion event because SE is null! " + this.conf.C);
            return false;
        }
        Trigger tevent = ev.trigger;
        boolean failEeventGenerated = false;
        if (tevent.isAddition() && tevent.isGoal()) {
            Event failEvent;
            if (this.hasGoalListener()) {
                for (GoalListener gl : this.goalListeners) {
                    gl.goalFailed(tevent);
                }
            }
            if ((failEvent = this.findEventForFailure(ev.intention, tevent)) != null) {
                TransitionSystem.setDefaultFailureAnnots(failEvent, tevent.getLiteral(), failAnnots);
                this.confP.C.addEvent(failEvent);
                failEeventGenerated = true;
            } else {
                this.logger.warning("No fail event was generated for " + ev.getTrigger());
                if (ev.intention != null) {
                    ev.intention.fail(this.getC());
                }
            }
        } else if (ev.isInternal()) {
            this.logger.warning("Could not finish intention:\n" + ev.intention);
        } else if (this.setts.requeue()) {
            this.confP.C.addEvent(ev);
            this.logger.warning("Requeing external event: " + ev);
        } else {
            this.logger.warning("Discarding external event: " + ev);
        }
        return failEeventGenerated;
    }

    public Event findEventForFailure(Intention i, Trigger tevent) {
        if (i != Intention.EmptyInt) {
            return i.findEventForFailure(tevent, this.getAg().getPL(), this.getC()).getFirst();
        }
        if (tevent.isGoal() && tevent.isAddition()) {
            Trigger failTrigger = new Trigger(Trigger.TEOperator.del, tevent.getType(), tevent.getLiteral());
            if (this.getAg().getPL().hasCandidatePlan(failTrigger)) {
                return new Event(failTrigger.clone(), i);
            }
        }
        return null;
    }

    private static void setDefaultFailureAnnots(Event failEvent, Term body, List<Term> failAnnots) {
        if (failAnnots == null) {
            failAnnots = JasonException.createBasicErrorAnnots(JasonException.UNKNOW_ERROR, "");
        }
        Literal eventLiteral = failEvent.getTrigger().getLiteral().forceFullLiteralImpl();
        eventLiteral.addAnnots(failAnnots);
        Literal bodyterm = aNOCODE;
        DefaultTerm codesrc = aNOCODE;
        DefaultTerm codeline = aNOCODE;
        if (body != null && body instanceof Literal && (bodyterm = (Literal)body).getSrcInfo() != null) {
            if (bodyterm.getSrcInfo().getSrcFile() != null) {
                codesrc = new StringTermImpl(bodyterm.getSrcInfo().getSrcFile());
            }
            codeline = new NumberTermImpl(bodyterm.getSrcInfo().getSrcLine());
        }
        if (eventLiteral.getAnnot("code") == null) {
            eventLiteral.addAnnot(ASSyntax.createStructure("code", bodyterm.copy().makeVarsAnnon()));
        }
        if (eventLiteral.getAnnot("code_src") == null) {
            eventLiteral.addAnnot(ASSyntax.createStructure("code_src", codesrc));
        }
        if (eventLiteral.getAnnot("code_line") == null) {
            eventLiteral.addAnnot(ASSyntax.createStructure("code_line", codeline));
        }
    }

    protected void checkHardDeadline(final Event evt) {
        final Literal body = evt.getTrigger().getLiteral();
        Literal hdl = body.getAnnot("hard_deadline");
        if (hdl == null) {
            return;
        }
        if (hdl.getArity() < 1) {
            return;
        }
        final Intention intention = evt.getIntention();
        final int isize = intention == null ? 0 : intention.size();
        int deadline = 0;
        try {
            deadline = (int)((NumberTerm)hdl.getTerm(0)).solve();
        }
        catch (NoValueException e1) {
            e1.printStackTrace();
        }
        Agent.getScheduler().schedule(new Runnable(){

            @Override
            public void run() {
                TransitionSystem.this.runAtBeginOfNextCycle(new Runnable(){

                    @Override
                    public void run() {
                        boolean drop = false;
                        if (intention == null) {
                            drop = desire.allDesires(TransitionSystem.this.C, body, new Unifier()).hasNext();
                        } else if (intention.size() >= isize && intention.hasTrigger(evt.getTrigger(), new Unifier())) {
                            drop = true;
                        }
                        if (drop) {
                            try {
                                FailWithDeadline ia = new FailWithDeadline(intention, evt.getTrigger());
                                ia.drop(TransitionSystem.this, body, new Unifier());
                            }
                            catch (Exception e2) {
                                e2.printStackTrace();
                            }
                        }
                    }
                });
                TransitionSystem.this.getUserAgArch().wakeUpSense();
            }
        }, (long)deadline, TimeUnit.MILLISECONDS);
    }

    public boolean canSleep() {
        return this.C.isAtomicIntentionSuspended() && !this.C.hasFeedbackAction() && !this.conf.C.hasMsg() || !this.conf.C.hasEvent() && !this.conf.C.hasIntention() && !this.conf.C.hasFeedbackAction() && !this.conf.C.hasMsg() && this.taskForBeginOfCycle.isEmpty() && this.getUserAgArch().canSleep();
    }

    public boolean canSleepSense() {
        return !this.C.hasMsg() && this.getUserAgArch().canSleep();
    }

    public boolean canSleepDeliberate() {
        return !this.C.hasEvent() && this.taskForBeginOfCycle.isEmpty() && this.C.getSelectedEvent() == null && this.getUserAgArch().canSleep();
    }

    public boolean canSleepAct() {
        return !this.C.hasIntention() && !this.C.hasFeedbackAction() && this.C.getSelectedIntention() == null && this.getUserAgArch().canSleep();
    }

    public void runAtBeginOfNextCycle(Runnable r) {
        this.taskForBeginOfCycle.offer(r);
    }

    public void reasoningCycle() {
        this.sense();
        this.deliberate();
        this.act();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sense() {
        try {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Start new reasoning cycle");
            }
            this.getUserAgArch().reasoningCycleStarting();
            this.C.resetSense();
            if (this.nrcslbr >= this.setts.nrcbp()) {
                this.nrcslbr = 0;
                Iterator iterator = this.C.syncApPlanSense;
                synchronized (iterator) {
                    this.ag.buf(this.getUserAgArch().perceive());
                }
                this.getUserAgArch().checkMail();
            }
            ++this.nrcslbr;
            if (this.canSleep()) {
                if (!this.sleepingEvt) {
                    this.sleepingEvt = true;
                    if (this.ag.pl.getCandidatePlans(PlanLibrary.TE_JAG_SLEEPING) != null) {
                        this.C.addExternalEv(PlanLibrary.TE_JAG_SLEEPING);
                    }
                }
            } else if (this.sleepingEvt) {
                if (this.C.hasMsg()) {
                    this.sleepingEvt = false;
                } else if (this.C.hasEvent()) {
                    for (Event e2 : this.C.getEvents()) {
                        Intention i = e2.getIntention();
                        if (e2.getTrigger().equals(PlanLibrary.TE_JAG_SLEEPING) && (i == null || !i.hasTrigger(PlanLibrary.TE_JAG_SLEEPING, new Unifier()))) continue;
                        this.sleepingEvt = false;
                        break;
                    }
                }
                if (!this.sleepingEvt && this.ag.pl.getCandidatePlans(PlanLibrary.TE_JAG_AWAKING) != null) {
                    this.C.addExternalEv(PlanLibrary.TE_JAG_AWAKING);
                }
            }
            this.stepSense = State.StartRC;
            do {
                this.applySemanticRuleSense();
            } while (this.stepSense != State.SelEv && this.getUserAgArch().isRunning());
        }
        catch (Exception e3) {
            this.logger.log(Level.SEVERE, "*** ERROR in the transition system (sense). " + this.conf.C + "\nCreating a new C!", e3);
            this.conf.C.create();
        }
    }

    public void deliberate() {
        try {
            this.C.resetDeliberate();
            Runnable r = this.taskForBeginOfCycle.poll();
            while (r != null) {
                r.run();
                r = this.taskForBeginOfCycle.poll();
            }
            this.stepDeliberate = State.SelEv;
            do {
                this.applySemanticRuleDeliberate();
            } while (this.stepDeliberate != State.ProcAct && this.getUserAgArch().isRunning());
        }
        catch (Exception e2) {
            this.logger.log(Level.SEVERE, "*** ERROR in the transition system (deliberate). " + this.conf.C + "\nCreating a new C!", e2);
            this.conf.C.create();
        }
    }

    public void act() {
        try {
            this.C.resetAct();
            this.stepAct = State.ProcAct;
            do {
                this.applySemanticRuleAct();
            } while (this.stepAct != State.StartRC && this.getUserAgArch().isRunning());
            ActionExec action = this.C.getAction();
            if (action != null) {
                this.C.addPendingAction(action);
                this.getUserAgArch().act(action);
            }
        }
        catch (Exception e2) {
            this.logger.log(Level.SEVERE, "*** ERROR in the transition system (act). " + this.conf.C + "\nCreating a new C!", e2);
            this.conf.C.create();
        }
    }

    public Agent getAg() {
        return this.ag;
    }

    public Circumstance getC() {
        return this.C;
    }

    public Settings getSettings() {
        return this.setts;
    }

    public void setAgArch(AgArch arch) {
        this.agArch = arch;
    }

    public AgArch getUserAgArch() {
        return this.agArch;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String toString() {
        return "TS of agent " + this.getUserAgArch().getAgName();
    }

    class FailWithDeadline
    extends fail_goal {
        Intention intToDrop;
        Trigger te;

        public FailWithDeadline(Intention i, Trigger t) {
            this.intToDrop = i;
            this.te = t;
        }

        @Override
        public int dropIntention(Intention i, Trigger g, TransitionSystem ts, Unifier un) throws JasonException {
            if (i != null) {
                if (this.intToDrop == null ? this.te != i.getBottom().getTrigger() : !this.intToDrop.equals(i)) {
                    return 0;
                }
                if (i.dropGoal(g, un)) {
                    Event failEvent;
                    if (ts.hasGoalListener()) {
                        for (GoalListener gl : ts.getGoalListeners()) {
                            gl.goalFailed(g);
                        }
                    }
                    if ((failEvent = ts.findEventForFailure(i, g)) != null) {
                        failEvent.getTrigger().getLiteral().addAnnots(JasonException.createBasicErrorAnnots("deadline_reached", ""));
                        ts.getC().addEvent(failEvent);
                        ts.getLogger().fine("'hard_deadline(" + g + ")' is generating a goal deletion event: " + failEvent.getTrigger());
                        return 2;
                    }
                    ts.getLogger().fine("'hard_deadline(" + g + ")' is removing the intention without event:\n" + i);
                    return 3;
                }
            }
            return 0;
        }
    }

    public static enum State {
        StartRC,
        SelEv,
        RelPl,
        ApplPl,
        SelAppl,
        FindOp,
        AddIM,
        ProcAct,
        SelInt,
        ExecInt,
        ClrInt;

    }
}

