/*
 * Decompiled with CFR 0.152.
 */
package errorlist;

import errorlist.ErrorSource;
import errorlist.ErrorSourceUpdate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.DefaultFocusComponent;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.Selection;

public class ErrorList
extends JPanel
implements EBComponent,
DefaultFocusComponent {
    public static final ImageIcon ERROR_ICON = new ImageIcon(ErrorList.class.getResource("error.png"));
    public static final ImageIcon WARNING_ICON = new ImageIcon(ErrorList.class.getResource("warning.png"));
    private View view;
    private JLabel status;
    private DefaultMutableTreeNode errorRoot;
    private DefaultTreeModel errorModel;
    private JTree errorTree;

    public ErrorList(View view) {
        this.view = view;
        this.setLayout(new BorderLayout());
        Box toolBar = new Box(0);
        this.status = new JLabel();
        toolBar.add(this.status);
        toolBar.add(Box.createGlue());
        RolloverButton btn = new RolloverButton(GUIUtilities.loadIcon((String)"PreviousFile.png"));
        btn.setToolTipText(jEdit.getProperty((String)"error-list-previous-error-file.label"));
        btn.addActionListener((ActionListener)new EditAction.Wrapper(jEdit.getActionContext(), "error-list-previous-error-file"));
        toolBar.add((Component)btn);
        btn = new RolloverButton(GUIUtilities.loadIcon((String)"NextFile.png"));
        btn.setToolTipText(jEdit.getProperty((String)"error-list-next-error-file.label"));
        btn.addActionListener((ActionListener)new EditAction.Wrapper(jEdit.getActionContext(), "error-list-next-error-file"));
        toolBar.add((Component)btn);
        btn = new RolloverButton(GUIUtilities.loadIcon((String)"ArrowL.png"));
        btn.setToolTipText(jEdit.getProperty((String)"error-list-previous-error.label"));
        btn.addActionListener((ActionListener)new EditAction.Wrapper(jEdit.getActionContext(), "error-list-previous-error"));
        toolBar.add((Component)btn);
        btn = new RolloverButton(GUIUtilities.loadIcon((String)"ArrowR.png"));
        btn.setToolTipText(jEdit.getProperty((String)"error-list-next-error.label"));
        btn.addActionListener((ActionListener)new EditAction.Wrapper(jEdit.getActionContext(), "error-list-next-error"));
        toolBar.add((Component)btn);
        toolBar.add(Box.createHorizontalStrut(6));
        btn = new RolloverButton(GUIUtilities.loadIcon((String)"Clear.png"));
        btn.setToolTipText(jEdit.getProperty((String)"error-list-clear.label"));
        btn.addActionListener((ActionListener)new EditAction.Wrapper(jEdit.getActionContext(), "error-list-clear"));
        toolBar.add((Component)btn);
        this.add("North", toolBar);
        this.errorRoot = new DefaultMutableTreeNode(new Root(), true);
        this.errorModel = new DefaultTreeModel(this.errorRoot, true);
        this.errorTree = new JTree(this.errorModel);
        if (!OperatingSystem.isMacOSLF()) {
            this.errorTree.putClientProperty("JTree.lineStyle", "Angled");
        }
        this.errorTree.addMouseListener(new MouseHandler());
        this.errorTree.setCellRenderer(new ErrorCellRenderer());
        this.errorTree.setRootVisible(false);
        this.errorTree.setShowsRootHandles(true);
        ErrorSource[] sources = ErrorSource.getErrorSources();
        for (int i = 0; i < sources.length; ++i) {
            ErrorSource source = sources[i];
            this.addErrorSource(source);
        }
        Object[] expandPath = new TreeNode[]{this.errorRoot, null};
        for (int i = 0; i < this.errorRoot.getChildCount(); ++i) {
            expandPath[1] = this.errorRoot.getChildAt(i);
            this.errorTree.expandPath(new TreePath(expandPath));
        }
        JScrollPane scroller = new JScrollPane(this.errorTree);
        scroller.setPreferredSize(new Dimension(640, 200));
        this.add("Center", scroller);
        this.updateStatus();
    }

    public void addNotify() {
        super.addNotify();
        EditBus.addToBus((EBComponent)this);
    }

    public void removeNotify() {
        super.removeNotify();
        EditBus.removeFromBus((EBComponent)this);
    }

    public void focusOnDefaultComponent() {
    }

    public void focus() {
        this.errorTree.requestFocus();
    }

    public void handleMessage(EBMessage message) {
        if (message instanceof ErrorSourceUpdate) {
            this.handleErrorSourceMessage((ErrorSourceUpdate)message);
        }
    }

    public void nextErrorFile() {
        DefaultMutableTreeNode next;
        if (this.errorRoot.getChildCount() == 0) {
            this.getToolkit().beep();
            return;
        }
        TreePath selected = this.errorTree.getSelectionPath();
        if (selected == null) {
            next = (DefaultMutableTreeNode)this.errorRoot.getChildAt(0);
        } else {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selected.getLastPathComponent();
            if (node.getUserObject() instanceof Extra) {
                node = (DefaultMutableTreeNode)node.getParent();
            }
            if (node.getUserObject() instanceof ErrorSource.Error) {
                node = (DefaultMutableTreeNode)node.getParent();
            }
            if (node.getUserObject() instanceof String) {
                int index = this.errorRoot.getIndex(node);
                if (index == this.errorRoot.getChildCount() - 1) {
                    this.getToolkit().beep();
                    return;
                }
                next = (DefaultMutableTreeNode)this.errorRoot.getChildAt(index + 1);
            } else {
                return;
            }
        }
        TreePath path = new TreePath(new TreeNode[]{this.errorRoot, next});
        this.errorTree.setSelectionPath(path);
        this.errorTree.scrollPathToVisible(path);
        jEdit.openFile((View)this.view, (String)((String)next.getUserObject()));
    }

    public void prevErrorFile() {
        DefaultMutableTreeNode prev;
        if (this.errorRoot.getChildCount() == 0) {
            this.getToolkit().beep();
            return;
        }
        TreePath selected = this.errorTree.getSelectionPath();
        if (selected == null) {
            prev = (DefaultMutableTreeNode)this.errorRoot.getChildAt(this.errorRoot.getChildCount() - 1);
        } else {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selected.getLastPathComponent();
            if (node.getUserObject() instanceof Extra) {
                node = (DefaultMutableTreeNode)node.getParent();
            }
            if (node.getUserObject() instanceof ErrorSource.Error) {
                node = (DefaultMutableTreeNode)node.getParent();
            }
            if (node.getUserObject() instanceof String) {
                int index = this.errorRoot.getIndex(node);
                if (index == 0) {
                    this.getToolkit().beep();
                    return;
                }
                prev = (DefaultMutableTreeNode)this.errorRoot.getChildAt(index - 1);
            } else {
                return;
            }
        }
        TreePath path = new TreePath(new TreeNode[]{this.errorRoot, prev});
        this.errorTree.setSelectionPath(path);
        this.errorTree.scrollPathToVisible(path);
        jEdit.openFile((View)this.view, (String)((String)prev.getUserObject()));
    }

    /*
     * WARNING - void declaration
     */
    public void nextError() {
        void var2_3;
        void var1_2;
        DefaultMutableTreeNode next;
        DefaultMutableTreeNode parent;
        if (this.errorRoot.getChildCount() == 0) {
            this.getToolkit().beep();
            return;
        }
        TreePath selected = this.errorTree.getSelectionPath();
        if (selected == null) {
            parent = (DefaultMutableTreeNode)this.errorRoot.getChildAt(0);
            next = (DefaultMutableTreeNode)parent.getChildAt(0);
        } else {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selected.getLastPathComponent();
            if (node.getUserObject() instanceof Extra) {
                node = (DefaultMutableTreeNode)node.getParent();
            }
            if (node.getUserObject() instanceof String) {
                parent = node;
                next = (DefaultMutableTreeNode)node.getChildAt(0);
            } else if (node.getUserObject() instanceof ErrorSource.Error) {
                parent = (DefaultMutableTreeNode)node.getParent();
                int index = parent.getIndex(node);
                if (index == parent.getChildCount() - 1) {
                    index = this.errorRoot.getIndex(parent);
                    if (index == this.errorRoot.getChildCount() - 1) {
                        this.getToolkit().beep();
                        return;
                    }
                    parent = (DefaultMutableTreeNode)this.errorRoot.getChildAt(index + 1);
                    next = (DefaultMutableTreeNode)parent.getChildAt(0);
                } else {
                    next = (DefaultMutableTreeNode)parent.getChildAt(index + 1);
                }
            } else {
                return;
            }
        }
        TreePath path = new TreePath(new TreeNode[]{this.errorRoot, var1_2, var2_3});
        this.selectPath(path);
        this.openError((ErrorSource.Error)var2_3.getUserObject());
    }

    /*
     * WARNING - void declaration
     */
    public void previousError() {
        void var2_3;
        void var1_2;
        DefaultMutableTreeNode prev;
        DefaultMutableTreeNode parent;
        if (this.errorRoot.getChildCount() == 0) {
            this.getToolkit().beep();
            return;
        }
        TreePath selected = this.errorTree.getSelectionPath();
        if (selected == null) {
            parent = (DefaultMutableTreeNode)this.errorRoot.getChildAt(this.errorRoot.getChildCount() - 1);
            prev = (DefaultMutableTreeNode)parent.getChildAt(parent.getChildCount() - 1);
        } else {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selected.getLastPathComponent();
            if (node.getUserObject() instanceof Extra) {
                node = (DefaultMutableTreeNode)node.getParent();
            }
            if (node.getUserObject() instanceof String) {
                int index = this.errorRoot.getIndex(node);
                if (index == 0) {
                    this.getToolkit().beep();
                    return;
                }
                parent = (DefaultMutableTreeNode)this.errorRoot.getChildAt(index - 1);
                prev = (DefaultMutableTreeNode)parent.getChildAt(parent.getChildCount() - 1);
            } else if (node.getUserObject() instanceof ErrorSource.Error) {
                parent = (DefaultMutableTreeNode)node.getParent();
                int index = parent.getIndex(node);
                if (index == 0) {
                    index = this.errorRoot.getIndex(parent);
                    if (index == 0) {
                        this.getToolkit().beep();
                        return;
                    }
                    parent = (DefaultMutableTreeNode)this.errorRoot.getChildAt(index - 1);
                    prev = (DefaultMutableTreeNode)parent.getChildAt(parent.getChildCount() - 1);
                } else {
                    prev = (DefaultMutableTreeNode)parent.getChildAt(index - 1);
                }
            } else {
                return;
            }
        }
        TreePath path = new TreePath(new TreeNode[]{this.errorRoot, var1_2, var2_3});
        this.selectPath(path);
        this.openError((ErrorSource.Error)var2_3.getUserObject());
    }

    private void updateStatus() {
        int warningCount = 0;
        int errorCount = 0;
        for (int i = 0; i < this.errorRoot.getChildCount(); ++i) {
            DefaultMutableTreeNode fileNode = (DefaultMutableTreeNode)this.errorRoot.getChildAt(i);
            for (int j = 0; j < fileNode.getChildCount(); ++j) {
                DefaultMutableTreeNode errorNode = (DefaultMutableTreeNode)fileNode.getChildAt(j);
                ErrorSource.Error error = (ErrorSource.Error)errorNode.getUserObject();
                if (error.getErrorType() == 0) {
                    ++errorCount;
                    continue;
                }
                ++warningCount;
            }
        }
        Object[] args = new Integer[]{new Integer(errorCount), new Integer(warningCount)};
        this.status.setText(jEdit.getProperty((String)ErrorList.getStatusProperty(errorCount, warningCount), (Object[])args));
    }

    private void handleErrorSourceMessage(ErrorSourceUpdate message) {
        Object what = message.getWhat();
        if (what == ErrorSourceUpdate.ERROR_SOURCE_ADDED) {
            this.addErrorSource(message.getErrorSource());
            this.updateStatus();
        }
        if (what == ErrorSourceUpdate.ERROR_ADDED) {
            this.addError(message.getError(), false);
            this.updateStatus();
        } else if (what == ErrorSourceUpdate.ERROR_REMOVED) {
            this.removeError(message.getError());
            this.updateStatus();
        } else if (what == ErrorSourceUpdate.ERRORS_CLEARED || what == ErrorSourceUpdate.ERROR_SOURCE_REMOVED) {
            this.removeErrorSource(message.getErrorSource());
            this.updateStatus();
        }
    }

    private void addErrorSource(ErrorSource source) {
        ErrorSource.Error[] errors = source.getAllErrors();
        if (errors == null) {
            return;
        }
        for (int j = 0; j < errors.length; ++j) {
            this.addError(errors[j], true);
        }
        this.errorModel.reload(this.errorRoot);
        Object[] expandPath = new TreeNode[]{this.errorRoot, null};
        for (int i = 0; i < this.errorRoot.getChildCount(); ++i) {
            expandPath[1] = this.errorRoot.getChildAt(i);
            this.errorTree.expandPath(new TreePath(expandPath));
        }
    }

    private void removeErrorSource(ErrorSource source) {
        DockableWindowManager dwm;
        for (int i = 0; i < this.errorRoot.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.errorRoot.getChildAt(i);
            for (int j = 0; j < node.getChildCount(); ++j) {
                DefaultMutableTreeNode errorNode = (DefaultMutableTreeNode)node.getChildAt(j);
                if (((ErrorSource.Error)errorNode.getUserObject()).getErrorSource() != source) continue;
                node.remove(errorNode);
                if (node.getChildCount() == 0) {
                    this.errorRoot.remove(node);
                    --i;
                }
                --j;
            }
        }
        this.errorModel.reload(this.errorRoot);
        Object[] expandPath = new TreeNode[]{this.errorRoot, null};
        for (int i = 0; i < this.errorRoot.getChildCount(); ++i) {
            expandPath[1] = this.errorRoot.getChildAt(i);
            this.errorTree.expandPath(new TreePath(expandPath));
        }
        if (this.errorRoot.getChildCount() == 0 && jEdit.getBooleanProperty((String)"error-list.autoCloseOnNoErrors") && (dwm = this.view.getDockableWindowManager()).isDockableWindowDocked("error-list") && dwm.isDockableWindowVisible("error-list")) {
            dwm.toggleDockableWindow("error-list");
        }
    }

    private void addError(ErrorSource.Error error, boolean init) {
        String[] extras = error.getExtraMessages();
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(error, extras.length > 0);
        for (int j = 0; j < extras.length; ++j) {
            newNode.add(new DefaultMutableTreeNode(new Extra(extras[j]), false));
        }
        String path = error.getFilePath();
        for (int i = 0; i < this.errorRoot.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.errorRoot.getChildAt(i);
            String nodePath = (String)node.getUserObject();
            if (!nodePath.equals(path)) continue;
            node.add(newNode);
            if (!init) {
                this.errorModel.reload(node);
                this.errorTree.expandPath(new TreePath(new TreeNode[]{this.errorRoot, node, newNode}));
            }
            return;
        }
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(path, true);
        node.add(newNode);
        this.errorRoot.add(node);
        this.errorModel.reload(this.errorRoot);
        if (!init) {
            Object[] expandPath = new TreeNode[]{this.errorRoot, null};
            for (int i = 0; i < this.errorRoot.getChildCount(); ++i) {
                expandPath[1] = this.errorRoot.getChildAt(i);
                this.errorTree.expandPath(new TreePath(expandPath));
            }
        }
    }

    private void removeError(ErrorSource.Error error) {
        DockableWindowManager dwm;
        block0: for (int i = 0; i < this.errorRoot.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.errorRoot.getChildAt(i);
            for (int j = 0; j < node.getChildCount(); ++j) {
                DefaultMutableTreeNode errorNode = (DefaultMutableTreeNode)node.getChildAt(j);
                if (errorNode.getUserObject() != error) continue;
                node.remove(errorNode);
                if (node.getChildCount() != 0) continue block0;
                this.errorRoot.remove(node);
                continue block0;
            }
        }
        this.errorModel.reload(this.errorRoot);
        if (this.errorRoot.getChildCount() == 0 && jEdit.getBooleanProperty((String)"error-list.autoCloseOnNoErrors") && (dwm = this.view.getDockableWindowManager()).isDockableWindowDocked("error-list") && dwm.isDockableWindowVisible("error-list")) {
            dwm.toggleDockableWindow("error-list");
        }
    }

    private void openError(final ErrorSource.Error error) {
        Buffer buffer;
        if (error.getBuffer() != null) {
            buffer = error.getBuffer();
        } else {
            buffer = jEdit.openFile((View)this.view, (String)error.getFilePath());
            if (buffer == null) {
                return;
            }
        }
        VFSManager.runInAWTThread((Runnable)new Runnable(){

            public void run() {
                ErrorList.this.view.goToBuffer(buffer);
                int start = error.getStartOffset();
                int end = error.getEndOffset();
                int lineNo = error.getLineNumber();
                if (lineNo >= 0 && lineNo < buffer.getLineCount()) {
                    start += buffer.getLineStartOffset(lineNo);
                    end = end == 0 ? buffer.getLineEndOffset(lineNo) - 1 : (end += buffer.getLineStartOffset(lineNo));
                }
                ErrorList.this.view.getTextArea().setSelection((Selection)new Selection.Range(start, end));
                ErrorList.this.view.getTextArea().moveCaretPosition(end);
            }
        });
    }

    private void selectPath(TreePath path) {
        this.errorTree.setSelectionPath(path);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (node.getChildCount() > 0) {
            this.errorTree.expandPath(path);
            this.errorTree.scrollPathToVisible(path.pathByAddingChild(node.getChildAt(node.getChildCount() - 1)));
        } else {
            this.errorTree.scrollPathToVisible(path);
        }
    }

    protected static String getStatusProperty(int errorCount, int warningCount) {
        String statusProp = "error-list.status.";
        statusProp = statusProp + (errorCount == 1 ? "one" : "many");
        statusProp = statusProp + "-error-";
        statusProp = statusProp + (warningCount == 1 ? "one" : "many");
        statusProp = statusProp + "-warning";
        return statusProp;
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        public void mouseClicked(MouseEvent evt) {
            DefaultMutableTreeNode node;
            TreePath path = ErrorList.this.errorTree.getPathForLocation(evt.getX(), evt.getY());
            if (path == null) {
                return;
            }
            if (!ErrorList.this.errorTree.isPathSelected(path)) {
                ErrorList.this.errorTree.setSelectionPath(path);
            }
            if (!((node = (DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject() instanceof Root)) {
                if (node.getUserObject() instanceof String) {
                    jEdit.openFile((View)ErrorList.this.view, (String)((String)node.getUserObject()));
                } else {
                    if (node.getUserObject() instanceof Extra) {
                        node = (DefaultMutableTreeNode)node.getParent();
                    }
                    ErrorList.this.openError((ErrorSource.Error)node.getUserObject());
                }
            }
        }
    }

    static class ErrorCellRenderer
    extends DefaultTreeCellRenderer {
        private static Font plainFont = UIManager.getFont("Tree.font");
        private static Font boldFont;

        ErrorCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focus) {
            super.getTreeCellRendererComponent(tree, null, sel, expanded, leaf, row, focus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object nodeValue = node.getUserObject();
            if (nodeValue == null) {
                this.setIcon(null);
                this.setText(null);
            } else if (nodeValue instanceof String) {
                this.setFont(boldFont);
                int errorCount = 0;
                int warningCount = 0;
                for (int i = 0; i < node.getChildCount(); ++i) {
                    DefaultMutableTreeNode errorNode = (DefaultMutableTreeNode)node.getChildAt(i);
                    ErrorSource.Error error = (ErrorSource.Error)errorNode.getUserObject();
                    if (error.getErrorType() == 0) {
                        ++errorCount;
                        continue;
                    }
                    ++warningCount;
                }
                this.setText(nodeValue + " (" + jEdit.getProperty((String)ErrorList.getStatusProperty(errorCount, warningCount), (Object[])new Object[]{new Integer(errorCount), new Integer(warningCount)}) + ")");
                this.setIcon(null);
            } else if (nodeValue instanceof ErrorSource.Error) {
                this.setFont(plainFont);
                ErrorSource.Error error = (ErrorSource.Error)nodeValue;
                this.setText(error.getLineNumber() + 1 + ": " + (error.getErrorMessage() == null ? "" : error.getErrorMessage().replace('\t', ' ')));
                this.setIcon(error.getErrorType() == 1 ? WARNING_ICON : ERROR_ICON);
            } else if (nodeValue instanceof Extra) {
                this.setFont(plainFont);
                this.setText(nodeValue.toString());
                this.setIcon(null);
            } else if (nodeValue instanceof Root) {
                this.setText(null);
                this.setIcon(null);
            }
            return this;
        }

        static {
            if (plainFont == null) {
                plainFont = jEdit.getFontProperty((String)"metal.secondary.font");
            }
            boldFont = plainFont.deriveFont(1);
        }
    }

    static class Extra {
        String message;

        Extra(String message) {
            this.message = message;
        }

        public String toString() {
            return this.message;
        }
    }

    static class Root {
        Root() {
        }
    }
}

