/*
 * Decompiled with CFR 0.152.
 */
package errorlist;

import errorlist.ErrorSource;
import errorlist.ErrorSourceUpdate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.text.Position;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;

public class DefaultErrorSource
extends ErrorSource
implements EBComponent {
    protected String name;
    protected int errorCount;
    protected Map errors = new LinkedHashMap();
    private boolean addedToBus;

    public DefaultErrorSource(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public ErrorSource.Error[] getAllErrors() {
        if (this.errors.size() == 0) {
            return null;
        }
        LinkedList errorList = new LinkedList();
        Iterator iter = this.errors.values().iterator();
        while (iter.hasNext()) {
            errorList.addAll((List)iter.next());
        }
        return errorList.toArray(new ErrorSource.Error[errorList.size()]);
    }

    public int getFileErrorCount(String path) {
        List list = (List)this.errors.get(path);
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    public ErrorSource.Error[] getFileErrors(String path) {
        List list = (List)this.errors.get(path);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.toArray(new ErrorSource.Error[list.size()]);
    }

    public ErrorSource.Error[] getLineErrors(String path, int startLineIndex, int endLineIndex) {
        if (this.errors.size() == 0) {
            return null;
        }
        List list = (List)this.errors.get(path);
        if (list == null) {
            return null;
        }
        LinkedList<DefaultError> errorList = new LinkedList<DefaultError>();
        int startIndex = this.findError(list, startLineIndex);
        if (startIndex != list.size()) {
            DefaultError error;
            int i = startIndex;
            while (i >= 0 && ((ErrorSource.Error)list.get(i)).getLineNumber() >= startLineIndex) {
                startIndex = i--;
            }
            for (i = startIndex; i < list.size() && (error = (DefaultError)list.get(i)).getLineNumber() <= endLineIndex; ++i) {
                errorList.add(error);
            }
        }
        if (errorList.size() == 0) {
            return null;
        }
        return errorList.toArray(new ErrorSource.Error[errorList.size()]);
    }

    public synchronized void clear() {
        if (this.errorCount == 0) {
            return;
        }
        this.errors.clear();
        this.errorCount = 0;
        this.removeOrAddToBus();
        if (this.registered) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ErrorSourceUpdate message = new ErrorSourceUpdate(DefaultErrorSource.this, ErrorSourceUpdate.ERRORS_CLEARED, null);
                    EditBus.send((EBMessage)message);
                }
            });
        }
    }

    public synchronized void removeFileErrors(String path) {
        final List list = (List)this.errors.remove(path);
        if (list == null) {
            return;
        }
        this.errorCount -= list.size();
        this.removeOrAddToBus();
        if (this.registered) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    for (int i = 0; i < list.size(); ++i) {
                        DefaultError error = (DefaultError)list.get(i);
                        ErrorSourceUpdate message = new ErrorSourceUpdate(DefaultErrorSource.this, ErrorSourceUpdate.ERROR_REMOVED, error);
                        EditBus.send((EBMessage)message);
                    }
                }
            });
        }
    }

    public synchronized void addError(final DefaultError error) {
        ArrayList<DefaultError> list = (ArrayList<DefaultError>)this.errors.get(error.getFilePath());
        if (list == null) {
            list = new ArrayList<DefaultError>();
            this.errors.put(error.getFilePath(), list);
        }
        boolean added = false;
        for (int i = 0; i < list.size(); ++i) {
            ErrorSource.Error _error = (ErrorSource.Error)list.get(i);
            if (_error.getLineNumber() <= error.getLineNumber()) continue;
            list.add(i, error);
            added = true;
            break;
        }
        if (!added) {
            list.add(error);
        }
        ++this.errorCount;
        this.removeOrAddToBus();
        if (this.registered) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ErrorSourceUpdate message = new ErrorSourceUpdate(DefaultErrorSource.this, ErrorSourceUpdate.ERROR_ADDED, error);
                    EditBus.send((EBMessage)message);
                }
            });
        }
    }

    public void addError(int type, String path, int lineIndex, int start, int end, String error) {
        DefaultError newError = new DefaultError(this, type, path, lineIndex, start, end, error);
        this.addError(newError);
    }

    public void handleMessage(EBMessage message) {
        if (message instanceof BufferUpdate) {
            this.handleBufferMessage((BufferUpdate)message);
        }
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.name + "]";
    }

    private int findError(List errorList, int line) {
        int start = 0;
        int end = errorList.size() - 1;
        block4: while (true) {
            switch (end - start) {
                case 0: {
                    if (((ErrorSource.Error)errorList.get(start)).getLineNumber() >= line) {
                        return start;
                    }
                    return start + 1;
                }
                case 1: {
                    if (((ErrorSource.Error)errorList.get(start)).getLineNumber() == line) {
                        return start;
                    }
                    ++start;
                    continue block4;
                }
            }
            int pivot = (end + start) / 2;
            int value = ((ErrorSource.Error)errorList.get(pivot)).getLineNumber();
            if (value == line) {
                return pivot;
            }
            if (value < line) {
                start = pivot + 1;
                continue;
            }
            end = pivot - 1;
        }
    }

    private void removeOrAddToBus() {
        if (this.addedToBus && this.errorCount == 0) {
            this.addedToBus = false;
            EditBus.removeFromBus((EBComponent)this);
        } else if (!this.addedToBus && this.errorCount != 0) {
            this.addedToBus = true;
            EditBus.addToBus((EBComponent)this);
        }
    }

    private synchronized void handleBufferMessage(BufferUpdate message) {
        block4: {
            List list;
            Buffer buffer;
            block3: {
                buffer = message.getBuffer();
                if (message.getWhat() != BufferUpdate.LOADED) break block3;
                List list2 = (List)this.errors.get(buffer.getSymlinkPath());
                if (list2 == null) break block4;
                for (int i = 0; i < list2.size(); ++i) {
                    ((DefaultError)list2.get(i)).openNotify(buffer);
                }
                break block4;
            }
            if (message.getWhat() == BufferUpdate.CLOSED && (list = (List)this.errors.get(buffer.getSymlinkPath())) != null) {
                for (int i = 0; i < list.size(); ++i) {
                    ((DefaultError)list.get(i)).closeNotify(buffer);
                }
            }
        }
    }

    public static class DefaultError
    implements ErrorSource.Error {
        DefaultError next;
        private ErrorSource source;
        private int type;
        private String path;
        private String name;
        private Buffer buffer;
        private int lineIndex;
        private int start;
        private int end;
        private Position linePos;
        private Position startPos;
        private Position endPos;
        private String error;
        private List extras;

        public DefaultError(ErrorSource source, int type, String path, int lineIndex, int start, int end, String error) {
            this.source = source;
            this.type = type;
            if (MiscUtilities.isURL((String)path)) {
                this.path = path;
            } else {
                this.path = MiscUtilities.constructPath((String)System.getProperty("user.dir"), (String)path);
                this.path = MiscUtilities.resolveSymlinks((String)this.path);
            }
            this.lineIndex = lineIndex;
            this.start = start;
            this.end = end;
            this.error = error;
            this.name = MiscUtilities.getFileName((String)path);
            Buffer buffer = jEdit.getBuffer((String)this.path);
            if (buffer != null && buffer.isLoaded()) {
                this.openNotify(buffer);
            }
        }

        public ErrorSource getErrorSource() {
            return this.source;
        }

        public int getErrorType() {
            return this.type;
        }

        public Buffer getBuffer() {
            return this.buffer;
        }

        public String getFilePath() {
            return this.path;
        }

        public String getFileName() {
            return this.name;
        }

        public int getLineNumber() {
            if (this.startPos != null) {
                return this.buffer.getLineOfOffset(this.startPos.getOffset());
            }
            return this.lineIndex;
        }

        public int getStartOffset() {
            if (this.startPos != null) {
                return this.startPos.getOffset() - this.buffer.getLineStartOffset(this.getLineNumber());
            }
            return this.start;
        }

        public int getEndOffset() {
            if (this.endPos != null) {
                return this.endPos.getOffset() - this.buffer.getLineStartOffset(this.getLineNumber());
            }
            return this.end;
        }

        public String getErrorMessage() {
            return this.error;
        }

        public void addExtraMessage(String message) {
            if (this.extras == null) {
                this.extras = new ArrayList();
            }
            this.extras.add(message);
        }

        public String[] getExtraMessages() {
            if (this.extras == null) {
                return new String[0];
            }
            return this.extras.toArray(new String[this.extras.size()]);
        }

        public String toString() {
            return this.getFileName() + ":" + (this.getLineNumber() + 1) + ":" + this.getErrorMessage();
        }

        void openNotify(Buffer buffer) {
            this.buffer = buffer;
            int lineIndex = Math.min(this.lineIndex, buffer.getLineCount() - 1);
            this.start = Math.min(this.start, buffer.getLineLength(lineIndex));
            int lineStart = buffer.getLineStartOffset(lineIndex);
            this.startPos = buffer.createPosition(lineStart + this.start);
            this.endPos = this.end != 0 ? buffer.createPosition(lineStart + this.end) : null;
        }

        void closeNotify(Buffer buffer) {
            this.buffer = null;
            this.linePos = null;
            this.startPos = null;
            this.endPos = null;
        }
    }
}

