/*
 * Decompiled with CFR 0.152.
 */
package buffertabs;

import gnu.regexp.RE;
import gnu.regexp.REException;
import java.awt.Color;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class ColorTabs {
    private static final int JND = 4;
    private static final int DARKEN_LOWEST_COLOR = 0;
    private static final int DARKEN_HIGHEST_COLOR = 150;
    private static final int DARKEN_RANGE = 150;
    private static final float DARKEN_RATIO = 0.5905512f;
    private static final int MUTE_LOWEST_COLOR = 150;
    private static final int MUTE_HIGHEST_COLOR = 230;
    private static final int MUTE_RANGE = 80;
    private static final float MUTE_RATIO = 0.31496063f;
    private static ColorTabs colorTabs = null;
    private boolean enabled = false;
    private boolean selectedColorized = true;
    private boolean selectedForegroundColorized = false;
    private boolean foregroundColorized = false;
    private boolean muteColors = true;
    private boolean colorVariation = true;
    private Vector colors;
    private Hashtable colorsAssigned = new Hashtable();
    private Object lock = new Object();
    private Random rnd = null;
    static /* synthetic */ Class class$buffertabs$ColorTabs;

    private ColorTabs() {
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isSelectedColorized() {
        return this.selectedColorized;
    }

    public void setSelectedColorized(boolean bl) {
        this.selectedColorized = bl;
    }

    public boolean isForegroundColorized() {
        return this.foregroundColorized;
    }

    public boolean isSelectedForegroundColorized() {
        return this.selectedForegroundColorized;
    }

    public void setForegroundColorized(boolean bl) {
        this.foregroundColorized = bl;
    }

    public void setSelectedForegroundColorized(boolean bl) {
        this.selectedForegroundColorized = bl;
    }

    public boolean hasMuteColors() {
        return this.muteColors;
    }

    public void setMuteColors(boolean bl) {
        this.muteColors = bl;
    }

    public boolean hasColorVariation() {
        return this.colorVariation;
    }

    public void setColorVariation(boolean bl) {
        this.colorVariation = bl;
    }

    Color alterColorDarken(Color color) {
        if (color == null) {
            return Color.black;
        }
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        n = (int)(150.0f - (float)n * 0.5905512f);
        n2 = (int)(150.0f - (float)n2 * 0.5905512f);
        n3 = (int)(150.0f - (float)n3 * 0.5905512f);
        if (this.hasColorVariation()) {
            n -= this.rnd.nextInt(5) * 4;
            n2 -= this.rnd.nextInt(5) * 4;
            n3 -= this.rnd.nextInt(5) * 4;
            n = n / 4 * 4;
            n2 = n2 / 4 * 4;
            n3 = n3 / 4 * 4;
        }
        n = Math.max(0, Math.min(n, 150));
        n2 = Math.max(0, Math.min(n2, 150));
        n3 = Math.max(0, Math.min(n3, 150));
        return new Color(n, n2, n3);
    }

    Color alterColorHighlight(Color color) {
        if (color == null) {
            return Color.lightGray;
        }
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        float[] fArray = Color.RGBtoHSB(n, n2, n3, null);
        float f = fArray[1];
        float f2 = fArray[2];
        f = (float)((double)f * 0.6);
        f = Math.max(0.0f, Math.min(f, 1.0f));
        f2 = (float)((double)f2 * 1.6);
        f2 = Math.max(0.0f, Math.min(f2, 0.8f));
        return Color.getHSBColor(fArray[0], f, f2);
    }

    Color alterColorMute(Color color) {
        if (color == null) {
            return Color.gray;
        }
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        n = (int)(150.0f + (float)n * 0.31496063f);
        n2 = (int)(150.0f + (float)n2 * 0.31496063f);
        n3 = (int)(150.0f + (float)n3 * 0.31496063f);
        if (this.hasColorVariation()) {
            n += this.rnd.nextInt(5) * 4;
            n2 += this.rnd.nextInt(5) * 4;
            n3 += this.rnd.nextInt(5) * 4;
            n = n / 4 * 4;
            n2 = n2 / 4 * 4;
            n3 = n3 / 4 * 4;
        }
        n = Math.max(150, Math.min(n, 230));
        n2 = Math.max(150, Math.min(n2, 230));
        n3 = Math.max(150, Math.min(n3, 230));
        return new Color(n, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Color getDefaultColorFor(String string) {
        Object object = this.lock;
        synchronized (object) {
            if (this.colors == null) {
                this.loadColors();
            }
            if (this.colorsAssigned.containsKey(string)) {
                return (Color)this.colorsAssigned.get(string);
            }
            for (int i = 0; i < this.colors.size(); ++i) {
                ColorEntry colorEntry = (ColorEntry)this.colors.elementAt(i);
                if (!colorEntry.re.isMatch((Object)string)) continue;
                Color color = null;
                color = this.hasMuteColors() ? (this.isForegroundColorized() ? this.alterColorDarken(colorEntry.color) : this.alterColorMute(colorEntry.color)) : colorEntry.color;
                this.colorsAssigned.put(string, color);
                return color;
            }
            return null;
        }
    }

    public static ColorTabs instance() {
        if (colorTabs == null) {
            colorTabs = new ColorTabs();
        }
        return colorTabs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadColors() {
        Object object = this.lock;
        synchronized (object) {
            String string;
            this.colors = new Vector();
            if (!jEdit.getBooleanProperty((String)"vfs.browser.colorize")) {
                return;
            }
            int n = 0;
            while ((string = jEdit.getProperty((String)("vfs.browser.colors." + n + ".glob"))) != null) {
                try {
                    this.colors.addElement(new ColorEntry(new RE((Object)MiscUtilities.globToRE((String)string)), jEdit.getColorProperty((String)("vfs.browser.colors." + n + ".color"), (Color)Color.black)));
                    ++n;
                }
                catch (REException rEException) {
                    Log.log((int)9, (Object)(class$buffertabs$ColorTabs == null ? ColorTabs.class$("buffertabs.ColorTabs") : class$buffertabs$ColorTabs), (Object)("Invalid regular expression: " + string));
                }
            }
        }
    }

    public void propertiesChanged() {
        this.loadColors();
        this.colorsAssigned.clear();
        this.rnd = new Random(20020212L);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class ColorEntry {
        Color color;
        RE re;

        ColorEntry(RE rE, Color color) {
            this.re = rE;
            this.color = color;
        }
    }
}

