/*
 * Decompiled with CFR 0.152.
 */
package buffertabs;

import buffertabs.BufferTabsPlugin;
import buffertabs.ColorTabs;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.util.Log;

public class BufferTabs
extends JTabbedPane
implements EBComponent {
    private EditPane editPane;
    private JComponent textArea;
    private Vector buffers;
    private ChangeHandler changeHandler;
    private MouseHandler mouseHandler;
    private MouseMotionHandler mouseMotionHandler;
    private static int moving = -1;
    static /* synthetic */ Class class$buffertabs$BufferTabs;

    public BufferTabs(EditPane editPane) {
        this.editPane = editPane;
        this.textArea = editPane.getTextArea();
        this.buffers = new Vector();
        this.changeHandler = new ChangeHandler();
        this.changeHandler.setEnabled(true);
        this.mouseHandler = new MouseHandler();
        this.mouseMotionHandler = new MouseMotionHandler();
    }

    public synchronized void start() {
        this.propertiesChanged();
        Buffer buffer = jEdit.getFirstBuffer();
        int n = 0;
        while (buffer != null) {
            this.bufferCreated(buffer, n);
            buffer = buffer.getNext();
            ++n;
        }
        EditBus.addToBus((EBComponent)this);
        n = this.buffers.indexOf(this.editPane.getBuffer());
        this.updateColorAt(this.getSelectedIndex());
        if (n >= 0) {
            this.setSelectedIndex(n);
            this.updateHighlightAt(n);
        }
        this.addChangeListener(this.changeHandler);
        this.addMouseListener(this.mouseHandler);
        this.addMouseMotionListener(this.mouseMotionHandler);
    }

    public synchronized void stop() {
        EditBus.removeFromBus((EBComponent)this);
        this.removeChangeListener(this.changeHandler);
        this.removeMouseListener(this.mouseHandler);
        this.removeMouseMotionListener(this.mouseMotionHandler);
    }

    public EditPane getEditPane() {
        return this.editPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(EBMessage eBMessage) {
        EditPaneUpdate editPaneUpdate;
        Buffer buffer = null;
        if (eBMessage instanceof BufferUpdate) {
            BufferUpdate bufferUpdate = (BufferUpdate)eBMessage;
            buffer = bufferUpdate.getBuffer();
            if (bufferUpdate.getWhat() == BufferUpdate.CREATED) {
                this.bufferCreated(buffer, buffer.getIndex());
            } else if (bufferUpdate.getWhat() == BufferUpdate.CLOSED) {
                this.bufferClosed(buffer);
            } else if (bufferUpdate.getWhat() == BufferUpdate.DIRTY_CHANGED) {
                this.bufferDirtyChanged(buffer);
            } else if (bufferUpdate.getWhat() == BufferUpdate.LOADED) {
                this.bufferLoaded(buffer);
            } else if (bufferUpdate.getWhat() == BufferUpdate.SAVED) {
                Buffer buffer2 = bufferUpdate.getBuffer();
                int n = this.buffers.indexOf(buffer2);
                this.setToolTipTextAt(n, buffer2.getPath());
            }
        } else if (eBMessage instanceof EditPaneUpdate && (editPaneUpdate = (EditPaneUpdate)eBMessage).getWhat() == EditPaneUpdate.BUFFER_CHANGED && this.editPane == editPaneUpdate.getEditPane()) {
            try {
                buffer = this.editPane.getBuffer();
                this.changeHandler.setEnabled(false);
                int n = this.buffers.indexOf(buffer);
                if (n >= 0) {
                    this.updateColorAt(this.getSelectedIndex());
                    this.setSelectedIndex(n);
                    this.updateHighlightAt(n);
                }
            }
            finally {
                this.changeHandler.setEnabled(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void bufferCreated(Buffer buffer, int n) {
        if (this.buffers.indexOf(buffer) >= 0) {
            return;
        }
        Buffer buffer2 = this.getEditPane().getBuffer();
        this.buffers.insertElementAt(buffer, n);
        try {
            this.getUI().uninstallUI(this);
            this.changeHandler.setEnabled(false);
            JComponent jComponent = null;
            if (super.indexOfComponent(this.textArea) == -1) {
                jComponent = this.textArea;
            }
            this.insertTab(buffer.getName(), null, jComponent, buffer.getPath(), n);
            this.updateTitleAt(n);
            if (jComponent == this.textArea) {
                this.textArea.setVisible(true);
            }
            Object var6_6 = null;
            this.changeHandler.setEnabled(true);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.changeHandler.setEnabled(true);
            this.getUI().installUI(this);
            throw throwable;
        }
        this.getUI().installUI(this);
        if (n >= 0) {
            int n2 = this.buffers.indexOf(buffer2);
            if (buffer == this.getEditPane().getBuffer()) {
                this.updateColorAt(n2);
                this.setSelectedIndex(n);
                this.updateHighlightAt(n);
            } else {
                this.setSelectedIndex(n2);
                this.updateHighlightAt(n2);
                this.updateColorAt(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void bufferClosed(Buffer buffer) {
        int n = this.buffers.indexOf(buffer);
        this.buffers.removeElementAt(n);
        try {
            this.changeHandler.setEnabled(false);
            this.removeTabAt(n);
            int n2 = this.buffers.indexOf(this.editPane.getBuffer());
            this.setSelectedIndex(n2);
            if (this.getTabCount() > 0 && super.indexOfComponent(this.textArea) == -1) {
                this.setComponentAt(0, this.textArea);
                this.textArea.setVisible(true);
            }
            if (n2 >= 0) {
                this.updateHighlightAt(n2);
            }
        }
        finally {
            this.changeHandler.setEnabled(true);
        }
    }

    public void propertiesChanged() {
        if (ColorTabs.instance().isEnabled() != jEdit.getBooleanProperty((String)"buffertabs.color-tabs")) {
            ColorTabs.instance().setEnabled(!ColorTabs.instance().isEnabled());
            if (!ColorTabs.instance().isEnabled()) {
                try {
                    for (int i = this.getTabCount() - 1; i >= 0; --i) {
                        this.setBackgroundAt(i, null);
                        this.setForegroundAt(i, null);
                    }
                }
                catch (NullPointerException nullPointerException) {
                    Log.log((int)9, (Object)(class$buffertabs$BufferTabs == null ? (class$buffertabs$BufferTabs = BufferTabs.class$("buffertabs.BufferTabs")) : class$buffertabs$BufferTabs), (Object)("propertiesChanged: 1 " + nullPointerException.toString()));
                }
                try {
                    this.getUI().uninstallUI(this);
                    UIManager.getDefaults().put("TabbedPane.selected", (Object)null);
                    this.getUI().installUI(this);
                }
                catch (NullPointerException nullPointerException) {
                    Log.log((int)9, (Object)(class$buffertabs$BufferTabs == null ? (class$buffertabs$BufferTabs = BufferTabs.class$("buffertabs.BufferTabs")) : class$buffertabs$BufferTabs), (Object)("propertiesChanged: 2 " + nullPointerException.toString()));
                }
            }
        }
        if (ColorTabs.instance().isEnabled()) {
            ColorTabs.instance().setMuteColors(jEdit.getBooleanProperty((String)"buffertabs.color-mute"));
            ColorTabs.instance().setColorVariation(jEdit.getBooleanProperty((String)"buffertabs.color-variation"));
            ColorTabs.instance().setForegroundColorized(jEdit.getBooleanProperty((String)"buffertabs.color-foreground"));
            if (ColorTabs.instance().isSelectedColorized() != jEdit.getBooleanProperty((String)"buffertabs.color-selected")) {
                ColorTabs.instance().setSelectedColorized(!ColorTabs.instance().isSelectedColorized());
                if (!ColorTabs.instance().isSelectedColorized()) {
                    try {
                        this.getUI().uninstallUI(this);
                        UIManager.getDefaults().put("TabbedPane.selected", (Object)null);
                        this.getUI().installUI(this);
                    }
                    catch (Exception exception) {
                        Log.log((int)9, (Object)(class$buffertabs$BufferTabs == null ? (class$buffertabs$BufferTabs = BufferTabs.class$("buffertabs.BufferTabs")) : class$buffertabs$BufferTabs), (Object)("propertiesChanged: 3 " + exception.toString()));
                    }
                }
            }
            if (ColorTabs.instance().isSelectedColorized()) {
                ColorTabs.instance().setSelectedForegroundColorized(jEdit.getBooleanProperty((String)"buffertabs.color-selected-foreground"));
            }
            ColorTabs.instance().propertiesChanged();
            if (this.getSelectedIndex() >= 0) {
                this.updateHighlightAt(this.getSelectedIndex());
            }
        }
    }

    private synchronized void bufferDirtyChanged(Buffer buffer) {
        int n = this.buffers.indexOf(buffer);
        this.updateTitleAt(n);
    }

    private synchronized void bufferLoaded(Buffer buffer) {
        int n = this.buffers.indexOf(buffer);
        if (n >= 0 && n < this.buffers.size()) {
            this.updateTitleAt(n);
            this.updateHighlightAt(n);
        }
    }

    private void updateColorAt(int n) {
        if (!ColorTabs.instance().isEnabled()) {
            return;
        }
        if (n < 0) {
            return;
        }
        Buffer buffer = (Buffer)this.buffers.elementAt(n);
        String string = buffer.getName();
        try {
            if (!ColorTabs.instance().isForegroundColorized()) {
                Color color = ColorTabs.instance().getDefaultColorFor(string);
                this.setBackgroundAt(n, color);
                this.setForegroundAt(n, null);
            } else {
                Color color = ColorTabs.instance().getDefaultColorFor(string);
                this.setForegroundAt(n, color);
                this.setBackgroundAt(n, null);
            }
        }
        catch (NullPointerException nullPointerException) {
            Log.log((int)9, (Object)(class$buffertabs$BufferTabs == null ? (class$buffertabs$BufferTabs = BufferTabs.class$("buffertabs.BufferTabs")) : class$buffertabs$BufferTabs), (Object)("updateColorAt: " + nullPointerException.toString()));
        }
    }

    private void updateHighlightAt(int n) {
        if (n < 0) {
            return;
        }
        if (ColorTabs.instance().isEnabled() && ColorTabs.instance().isSelectedColorized() && n == this.getSelectedIndex()) {
            Buffer buffer = (Buffer)this.buffers.elementAt(n);
            String string = buffer.getName();
            Color color = ColorTabs.instance().getDefaultColorFor(string);
            Color color2 = null;
            if (!ColorTabs.instance().isSelectedForegroundColorized()) {
                color2 = ColorTabs.instance().alterColorHighlight(color);
                this.setBackgroundAt(n, color2);
                this.setForegroundAt(n, null);
            } else {
                color2 = ColorTabs.instance().alterColorDarken(color);
                this.setForegroundAt(n, color2);
                this.setBackgroundAt(n, null);
            }
        }
    }

    private void updateTitleAt(int n) {
        if (n < 0) {
            return;
        }
        Buffer buffer = (Buffer)this.buffers.elementAt(n);
        String string = buffer.getName();
        Icon icon = null;
        if (jEdit.getBooleanProperty((String)"buffertabs.icons", (boolean)true)) {
            icon = buffer.getIcon();
        } else {
            if (buffer.isDirty()) {
                string = string + "*";
            }
            if (buffer.isNewFile()) {
                string = string + " (new)";
            }
        }
        this.setTitleAt(n, string);
        this.setIconAt(n, icon);
    }

    public synchronized void updateTitles() {
        this.propertiesChanged();
        for (int i = this.getTabCount() - 1; i >= 0; --i) {
            this.updateTitleAt(i);
        }
    }

    public void setTabPlacement(String string) {
        int n = 3;
        if ((string = string.toLowerCase()).equals("top")) {
            n = 1;
        } else if (string.equals("left")) {
            n = 2;
        } else if (string.equals("right")) {
            n = 4;
        }
        this.setTabPlacement(n);
    }

    public Component getComponentAt(int n) {
        if (this.changeHandler.isEnabled() && n >= 0 && n < this.getTabCount()) {
            return this.textArea;
        }
        return super.getComponentAt(n);
    }

    public int indexOfComponent(Component component) {
        return super.indexOfComponent(this.textArea);
    }

    protected String paramString() {
        int n = this.getSelectedIndex();
        if (n >= 0) {
            return "" + this.getTitleAt(n);
        }
        return "";
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public boolean isRequestFocusEnabled() {
        return false;
    }

    public int getTabAt(int n, int n2) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            Rectangle rectangle = this.getBoundsAt(i);
            if (!rectangle.contains(n, n2)) continue;
            return i;
        }
        return -1;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class MouseMotionHandler
    implements MouseMotionListener {
        MouseMotionHandler() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (moving != -1) {
                if (BufferTabs.this.getCursor() != Cursor.getPredefinedCursor(13)) {
                    BufferTabs.this.setCursor(Cursor.getPredefinedCursor(13));
                }
            } else {
                BufferTabs.this.setCursor(Cursor.getDefaultCursor());
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!jEdit.getBooleanProperty((String)"buffertabs.usePopup", (boolean)true)) {
                return;
            }
            if (GUIUtilities.isPopupTrigger((MouseEvent)mouseEvent)) {
                BufferTabs.this.editPane.focusOnTextArea();
                JPopupMenu jPopupMenu = BufferTabsPlugin.getRightClickPopup();
                if (jPopupMenu == null) {
                    return;
                }
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                View view = BufferTabs.this.editPane.getView();
                Dimension dimension = view.getSize();
                Point point = view.getLocationOnScreen();
                Insets insets = view.getInsets();
                Point point2 = BufferTabs.this.getLocationOnScreen();
                Dimension dimension2 = jPopupMenu.getSize();
                if (dimension2.height == 0) {
                    jPopupMenu.show(BufferTabs.this, Integer.MIN_VALUE, Integer.MIN_VALUE);
                    jPopupMenu.setVisible(false);
                    dimension2 = jPopupMenu.getSize();
                }
                if (point2.x + n + dimension2.width > point.x + dimension.width - insets.right) {
                    n -= dimension2.width;
                }
                if (point2.y + n2 + dimension2.height > point.y + dimension.height - insets.bottom) {
                    n2 = point.y + dimension.height - insets.bottom - (point2.y + dimension2.height);
                }
                jPopupMenu.show(BufferTabs.this, n, n2);
            } else {
                if (SwingUtilities.isMiddleMouseButton(mouseEvent) && jEdit.getBooleanProperty((String)"buffertabs.close-tab-on.single-middle-click")) {
                    int n = BufferTabs.this.getTabAt(mouseEvent.getX(), mouseEvent.getY());
                    int n3 = BufferTabs.this.getSelectedIndex();
                    BufferTabs.this.editPane.focusOnTextArea();
                    jEdit.closeBuffer((View)BufferTabs.this.editPane.getView(), (Buffer)((Buffer)BufferTabs.this.buffers.get(n)));
                }
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    moving = BufferTabs.this.getTabAt(mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && moving != -1) {
                int n = BufferTabs.this.getTabAt(mouseEvent.getX(), mouseEvent.getY());
                if (n != -1 && n != moving) {
                    Buffer buffer = (Buffer)BufferTabs.this.buffers.elementAt(moving);
                    BufferTabs.this.bufferClosed(buffer);
                    BufferTabs.this.bufferCreated(buffer, n);
                } else {
                    BufferTabs.this.editPane.focusOnTextArea();
                }
                BufferTabs.this.setCursor(Cursor.getDefaultCursor());
                moving = -1;
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2 && jEdit.getBooleanProperty((String)"buffertabs.close-tab-on.double-left-click")) {
                int n = BufferTabs.this.getTabAt(mouseEvent.getX(), mouseEvent.getY());
                int n2 = BufferTabs.this.getSelectedIndex();
                BufferTabs.this.editPane.focusOnTextArea();
                jEdit.closeBuffer((View)BufferTabs.this.editPane.getView(), (Buffer)((Buffer)BufferTabs.this.buffers.get(n)));
            }
        }
    }

    private class ChangeHandler
    implements ChangeListener {
        private boolean enabled = true;

        private ChangeHandler() {
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        public synchronized void stateChanged(ChangeEvent changeEvent) {
            Buffer buffer;
            int n = BufferTabs.this.getSelectedIndex();
            if (n >= 0 && this.isEnabled() && (buffer = (Buffer)BufferTabs.this.buffers.elementAt(n)) != null) {
                int n2 = BufferTabs.this.buffers.indexOf(BufferTabs.this.editPane.getBuffer());
                if (n2 >= 0) {
                    BufferTabs.this.updateColorAt(n2);
                }
                BufferTabs.this.editPane.setBuffer(buffer);
                BufferTabs.this.updateHighlightAt(n);
            }
        }
    }
}

