/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.util;

import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.WorkThread;
import org.gjt.sp.util.WorkThreadProgressListener;

public class WorkThreadPool {
    Object lock = new Object();
    Object waitForAllLock = new Object();
    private boolean started;
    private ThreadGroup threadGroup;
    private WorkThread[] threads;
    private Request firstRequest;
    private Request lastRequest;
    private int requestCount;
    private boolean awtRunnerQueued;
    private Request firstAWTRequest;
    private Request lastAWTRequest;
    private int awtRequestCount;
    private EventListenerList listenerList = new EventListenerList();
    static int ID;
    static /* synthetic */ Class class$org$gjt$sp$util$WorkThreadProgressListener;
    static /* synthetic */ Class class$org$gjt$sp$util$WorkThread;

    public WorkThreadPool(String name, int count) {
        if (count != 0) {
            this.threadGroup = new ThreadGroup(name);
            this.threads = new WorkThread[count];
            for (int i = 0; i < this.threads.length; ++i) {
                this.threads[i] = new WorkThread(this, this.threadGroup, name + " #" + (i + 1));
            }
        } else {
            Log.log(7, this, "Async I/O disabled");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            this.started = true;
            if (this.awtRequestCount != 0 && this.requestCount == 0) {
                this.queueAWTRunner();
            }
        }
        if (this.threads != null) {
            for (int i = 0; i < this.threads.length; ++i) {
                this.threads[i].start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWorkRequest(Runnable run, boolean inAWT) {
        if (this.threads == null) {
            run.run();
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.started && inAWT && this.requestCount == 0 && this.awtRequestCount == 0) {
                if (SwingUtilities.isEventDispatchThread()) {
                    run.run();
                } else {
                    SwingUtilities.invokeLater(run);
                }
                return;
            }
            Request request = new Request(run);
            if (inAWT) {
                if (this.firstAWTRequest == null && this.lastAWTRequest == null) {
                    this.firstAWTRequest = this.lastAWTRequest = request;
                } else {
                    this.lastAWTRequest.next = request;
                    this.lastAWTRequest = request;
                }
                ++this.awtRequestCount;
                if (this.started && this.requestCount == 0) {
                    this.queueAWTRunner();
                }
            } else {
                if (this.firstRequest == null && this.lastRequest == null) {
                    this.firstRequest = this.lastRequest = request;
                } else {
                    this.lastRequest.next = request;
                    this.lastRequest = request;
                }
                ++this.requestCount;
            }
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForRequests() {
        if (this.threads == null) {
            return;
        }
        Object object = this.waitForAllLock;
        synchronized (object) {
            while (this.requestCount != 0) {
                try {
                    this.waitForAllLock.wait();
                }
                catch (InterruptedException ie) {
                    Log.log(9, this, ie);
                }
            }
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.doAWTRequests();
        } else {
            try {
                SwingUtilities.invokeAndWait(new RunRequestsInAWTThread());
            }
            catch (Exception e) {
                Log.log(9, this, e);
            }
        }
    }

    public int getRequestCount() {
        return this.requestCount;
    }

    public int getThreadCount() {
        if (this.threads == null) {
            return 0;
        }
        return this.threads.length;
    }

    public WorkThread getThread(int index) {
        return this.threads[index];
    }

    public void addProgressListener(WorkThreadProgressListener listener) {
        this.listenerList.add(class$org$gjt$sp$util$WorkThreadProgressListener == null ? (class$org$gjt$sp$util$WorkThreadProgressListener = WorkThreadPool.class$("org.gjt.sp.util.WorkThreadProgressListener")) : class$org$gjt$sp$util$WorkThreadProgressListener, listener);
    }

    public void removeProgressListener(WorkThreadProgressListener listener) {
        this.listenerList.remove(class$org$gjt$sp$util$WorkThreadProgressListener == null ? (class$org$gjt$sp$util$WorkThreadProgressListener = WorkThreadPool.class$("org.gjt.sp.util.WorkThreadProgressListener")) : class$org$gjt$sp$util$WorkThreadProgressListener, listener);
    }

    void fireStatusChanged(WorkThread thread) {
        Object[] listeners = this.listenerList.getListenerList();
        if (listeners.length != 0) {
            int i;
            int index = 0;
            for (i = 0; i < this.threads.length; ++i) {
                if (this.threads[i] != thread) continue;
                index = i;
                break;
            }
            for (i = listeners.length - 2; i >= 0; --i) {
                if (listeners[i] != (class$org$gjt$sp$util$WorkThreadProgressListener == null ? WorkThreadPool.class$("org.gjt.sp.util.WorkThreadProgressListener") : class$org$gjt$sp$util$WorkThreadProgressListener)) continue;
                ((WorkThreadProgressListener)listeners[i + 1]).statusUpdate(this, index);
            }
        }
    }

    void fireProgressChanged(WorkThread thread) {
        Object[] listeners = this.listenerList.getListenerList();
        if (listeners.length != 0) {
            int i;
            int index = 0;
            for (i = 0; i < this.threads.length; ++i) {
                if (this.threads[i] != thread) continue;
                index = i;
                break;
            }
            for (i = listeners.length - 2; i >= 0; --i) {
                if (listeners[i] != (class$org$gjt$sp$util$WorkThreadProgressListener == null ? WorkThreadPool.class$("org.gjt.sp.util.WorkThreadProgressListener") : class$org$gjt$sp$util$WorkThreadProgressListener)) continue;
                ((WorkThreadProgressListener)listeners[i + 1]).progressUpdate(this, index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requestDone() {
        Object object = this.lock;
        synchronized (object) {
            --this.requestCount;
            if (this.requestCount == 0 && this.firstAWTRequest != null) {
                this.queueAWTRunner();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Request getNextRequest() {
        Object object = this.lock;
        synchronized (object) {
            Request request = this.firstRequest;
            if (request == null) {
                return null;
            }
            this.firstRequest = this.firstRequest.next;
            if (this.firstRequest == null) {
                this.lastRequest = null;
            }
            if (request.alreadyRun) {
                throw new InternalError("AIEE!!! Request run twice!!! " + request.run);
            }
            request.alreadyRun = true;
            return request;
        }
    }

    private void doAWTRequests() {
        while (this.requestCount == 0 && this.firstAWTRequest != null) {
            this.doAWTRequest(this.getNextAWTRequest());
        }
    }

    private void doAWTRequest(Request request) {
        try {
            request.run.run();
        }
        catch (Throwable t) {
            Log.log(9, class$org$gjt$sp$util$WorkThread == null ? (class$org$gjt$sp$util$WorkThread = WorkThreadPool.class$("org.gjt.sp.util.WorkThread")) : class$org$gjt$sp$util$WorkThread, "Exception in AWT thread:");
            Log.log(9, class$org$gjt$sp$util$WorkThread == null ? (class$org$gjt$sp$util$WorkThread = WorkThreadPool.class$("org.gjt.sp.util.WorkThread")) : class$org$gjt$sp$util$WorkThread, t);
        }
        --this.awtRequestCount;
    }

    private void queueAWTRunner() {
        if (!this.awtRunnerQueued) {
            this.awtRunnerQueued = true;
            SwingUtilities.invokeLater(new RunRequestsInAWTThread());
        }
    }

    private Request getNextAWTRequest() {
        Request request = this.firstAWTRequest;
        this.firstAWTRequest = this.firstAWTRequest.next;
        if (this.firstAWTRequest == null) {
            this.lastAWTRequest = null;
        }
        if (request.alreadyRun) {
            throw new InternalError("AIEE!!! Request run twice!!! " + request.run);
        }
        request.alreadyRun = true;
        return request;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class RunRequestsInAWTThread
    implements Runnable {
        RunRequestsInAWTThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = WorkThreadPool.this.lock;
            synchronized (object) {
                WorkThreadPool.this.awtRunnerQueued = false;
                if (WorkThreadPool.this.requestCount == 0) {
                    WorkThreadPool.this.doAWTRequests();
                }
            }
        }
    }

    static class Request {
        int id = ++ID;
        Runnable run;
        boolean alreadyRun;
        Request next;

        Request(Runnable run) {
            this.run = run;
        }

        public String toString() {
            return "[id=" + this.id + ",run=" + this.run + "]";
        }
    }
}

