/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class Log {
    public static final int MAXLINES = 500;
    public static final int DEBUG = 1;
    public static final int MESSAGE = 3;
    public static final int NOTICE = 5;
    public static final int WARNING = 7;
    public static final int ERROR = 9;
    private static Object LOCK = new Object();
    private static String[] log;
    private static int logLineCount;
    private static boolean wrap;
    private static int level;
    private static Writer stream;
    private static String lineSep;
    private static PrintStream realOut;
    private static PrintStream realErr;
    private static LogListModel listModel;
    static /* synthetic */ Class class$org$gjt$sp$util$Log;

    public static void init(boolean stdio, int level) {
        if (stdio && System.out == realOut && System.err == realErr) {
            System.setOut(Log.createPrintStream(5, null));
            System.setErr(Log.createPrintStream(9, null));
        }
        Log.level = level;
        Log.log(3, class$org$gjt$sp$util$Log == null ? (class$org$gjt$sp$util$Log = Log.class$("org.gjt.sp.util.Log")) : class$org$gjt$sp$util$Log, "When reporting bugs, please include the following information:");
        String[] props = new String[]{"java.version", "java.vm.version", "java.runtime.version", "java.vendor", "java.compiler", "os.name", "os.version", "os.arch", "user.home", "java.home", "java.class.path"};
        for (int i = 0; i < props.length; ++i) {
            Log.log(3, class$org$gjt$sp$util$Log == null ? Log.class$("org.gjt.sp.util.Log") : class$org$gjt$sp$util$Log, props[i] + "=" + System.getProperty(props[i]));
        }
    }

    public static void setLogWriter(Writer stream) {
        if (Log.stream == null && stream != null) {
            try {
                int i;
                if (wrap) {
                    for (i = logLineCount; i < log.length; ++i) {
                        stream.write(log[i]);
                        stream.write(lineSep);
                    }
                }
                for (i = 0; i < logLineCount; ++i) {
                    stream.write(log[i]);
                    stream.write(lineSep);
                }
                stream.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Log.stream = stream;
    }

    public static void flushStream() {
        if (stream != null) {
            try {
                stream.flush();
            }
            catch (IOException io) {
                io.printStackTrace(realErr);
            }
        }
    }

    public static void closeStream() {
        if (stream != null) {
            try {
                stream.close();
                stream = null;
            }
            catch (IOException io) {
                io.printStackTrace(realErr);
            }
        }
    }

    public static ListModel getLogListModel() {
        return listModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(int urgency, Object source, Object message) {
        int index;
        String _source;
        if (source == null) {
            _source = Thread.currentThread().getName();
            if (_source == null) {
                _source = Thread.currentThread().getClass().getName();
            }
        } else {
            _source = source instanceof Class ? ((Class)source).getName() : source.getClass().getName();
        }
        if ((index = _source.lastIndexOf(46)) != -1) {
            _source = _source.substring(index + 1);
        }
        if (message instanceof Throwable) {
            Log._logException(urgency, source, (Throwable)message);
        } else {
            String _message = String.valueOf(message);
            Object object = LOCK;
            synchronized (object) {
                StringTokenizer st = new StringTokenizer(_message, "\r\n");
                int lineCount = 0;
                boolean oldWrap = wrap;
                while (st.hasMoreTokens()) {
                    ++lineCount;
                    Log._log(urgency, _source, st.nextToken().replace('\t', ' '));
                }
                listModel.update(lineCount, oldWrap);
            }
        }
    }

    private static PrintStream createPrintStream(final int urgency, final Object source) {
        return new PrintStream(new OutputStream(){

            public void write(int b) {
                byte[] barray = new byte[]{(byte)b};
                this.write(barray, 0, 1);
            }

            public void write(byte[] b, int off, int len) {
                String str = new String(b, off, len);
                Log.log(urgency, source, str);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _logException(int urgency, Object source, Throwable message) {
        PrintStream out = Log.createPrintStream(urgency, source);
        Object object = LOCK;
        synchronized (object) {
            message.printStackTrace(out);
        }
    }

    private static void _log(int urgency, String source, String message) {
        String fullMessage = "[" + Log.urgencyToString(urgency) + "] " + source + ": " + message;
        try {
            Log.log[Log.logLineCount] = fullMessage;
            if (++logLineCount >= log.length) {
                wrap = true;
                logLineCount = 0;
            }
            if (stream != null) {
                stream.write(fullMessage);
                stream.write(lineSep);
            }
        }
        catch (Exception e) {
            e.printStackTrace(realErr);
        }
        if (urgency >= level) {
            if (urgency == 9) {
                realErr.println(fullMessage);
            } else {
                realOut.println(fullMessage);
            }
        }
    }

    private static String urgencyToString(int urgency) {
        switch (urgency) {
            case 1: {
                return "debug";
            }
            case 3: {
                return "message";
            }
            case 5: {
                return "notice";
            }
            case 7: {
                return "warning";
            }
            case 9: {
                return "error";
            }
        }
        throw new IllegalArgumentException("Invalid urgency: " + urgency);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        level = 7;
        level = 7;
        realOut = System.out;
        realErr = System.err;
        log = new String[500];
        lineSep = System.getProperty("line.separator");
        listModel = new LogListModel();
    }

    static class LogListModel
    implements ListModel {
        Vector listeners = new Vector();

        LogListModel() {
        }

        private void fireIntervalAdded(int index1, int index2) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ListDataListener listener = (ListDataListener)this.listeners.elementAt(i);
                listener.intervalAdded(new ListDataEvent(this, 1, index1, index2));
            }
        }

        private void fireIntervalRemoved(int index1, int index2) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ListDataListener listener = (ListDataListener)this.listeners.elementAt(i);
                listener.intervalRemoved(new ListDataEvent(this, 2, index1, index2));
            }
        }

        public void addListDataListener(ListDataListener listener) {
            this.listeners.addElement(listener);
        }

        public void removeListDataListener(ListDataListener listener) {
            this.listeners.removeElement(listener);
        }

        public Object getElementAt(int index) {
            if (wrap) {
                if (index < 500 - logLineCount) {
                    return log[index + logLineCount];
                }
                return log[index - 500 + logLineCount];
            }
            return log[index];
        }

        public int getSize() {
            if (wrap) {
                return 500;
            }
            return logLineCount;
        }

        void update(int lineCount, boolean oldWrap) {
            if (lineCount == 0 || this.listeners.size() == 0) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(this, oldWrap, lineCount){
                private final /* synthetic */ boolean val$oldWrap;
                private final /* synthetic */ int val$lineCount;
                private final /* synthetic */ LogListModel this$0;
                {
                    this.this$0 = this$0;
                    this.val$oldWrap = val$oldWrap;
                    this.val$lineCount = val$lineCount;
                }

                public void run() {
                    if (Log.access$000()) {
                        if (this.val$oldWrap) {
                            LogListModel.access$300(this.this$0, 0, this.val$lineCount - 1);
                        } else {
                            LogListModel.access$300(this.this$0, 0, Log.access$100());
                        }
                        LogListModel.access$400(this.this$0, 500 - this.val$lineCount + 1, 500);
                    } else {
                        LogListModel.access$400(this.this$0, Log.access$100() - this.val$lineCount + 1, Log.access$100());
                    }
                }
            });
        }

        static /* synthetic */ void access$300(LogListModel x0, int x1, int x2) {
            x0.fireIntervalRemoved(x1, x2);
        }

        static /* synthetic */ void access$400(LogListModel x0, int x1, int x2) {
            x0.fireIntervalAdded(x1, x2);
        }
    }
}

