/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.text.TabExpander;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.buffer.IndentFoldHandler;
import org.gjt.sp.jedit.syntax.Chunk;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.jedit.textarea.ChunkCache;
import org.gjt.sp.jedit.textarea.ExtensionManager;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.jedit.textarea.StructureMatcher;
import org.gjt.sp.jedit.textarea.TextAreaExtension;
import org.gjt.sp.util.Log;

public class TextAreaPainter
extends JComponent
implements TabExpander {
    public static final int LOWEST_LAYER = Integer.MIN_VALUE;
    public static final int BACKGROUND_LAYER = -60;
    public static final int LINE_BACKGROUND_LAYER = -50;
    public static final int BELOW_SELECTION_LAYER = -40;
    public static final int SELECTION_LAYER = -30;
    public static final int WRAP_GUIDE_LAYER = -20;
    public static final int BELOW_MOST_EXTENSIONS_LAYER = -10;
    public static final int DEFAULT_LAYER = 0;
    public static final int BLOCK_CARET_LAYER = 50;
    public static final int BRACKET_HIGHLIGHT_LAYER = 100;
    public static final int TEXT_LAYER = 200;
    public static final int CARET_LAYER = 300;
    public static final int HIGHEST_LAYER = Integer.MAX_VALUE;
    JEditTextArea textArea;
    SyntaxStyle[] styles;
    Color caretColor;
    Color selectionColor;
    Color multipleSelectionColor;
    Color lineHighlightColor;
    Color structureHighlightColor;
    Color eolMarkerColor;
    Color wrapGuideColor;
    SyntaxStyle[] foldLineStyle;
    boolean blockCaret;
    boolean lineHighlight;
    boolean structureHighlight;
    boolean eolMarkers;
    boolean wrapGuide;
    boolean antiAlias;
    boolean fracFontMetrics;
    FontMetrics fm;
    private ExtensionManager extensionMgr;
    private PaintCaret caretExtension;
    private RenderingHints renderingHints;
    private FontRenderContext fontRenderContext;
    private HashMap fonts;

    public void setBounds(int x, int y, int width, int height) {
        if (x == this.getX() && y == this.getY() && width == this.getWidth() && height == this.getHeight()) {
            return;
        }
        super.setBounds(x, y, width, height);
        this.textArea.recalculateVisibleLines();
        if (this.textArea.getBuffer().isLoaded()) {
            this.textArea.recalculateLastPhysicalLine();
        }
        this.textArea.propertiesChanged();
        this.textArea.updateMaxHorizontalScrollWidth();
        this.textArea.scrollBarsInitialized = true;
    }

    public boolean isManagingFocus() {
        return false;
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public final SyntaxStyle[] getStyles() {
        return this.styles;
    }

    public final void setStyles(SyntaxStyle[] styles) {
        this.fonts.clear();
        this.styles = styles;
        styles[0] = new SyntaxStyle(this.getForeground(), null, this.getFont());
        for (int i = 0; i < styles.length; ++i) {
            styles[i].setCharWidth(this.getCharWidth(styles[i].getFont()));
        }
        this.repaint();
    }

    public final Color getCaretColor() {
        return this.caretColor;
    }

    public final void setCaretColor(Color caretColor) {
        this.caretColor = caretColor;
        if (this.textArea.getBuffer() != null) {
            this.textArea.invalidateLine(this.textArea.getCaretLine());
        }
    }

    public final Color getSelectionColor() {
        return this.selectionColor;
    }

    public final void setSelectionColor(Color selectionColor) {
        this.selectionColor = selectionColor;
        if (this.textArea.getBuffer() != null) {
            this.textArea.invalidateSelectedLines();
        }
    }

    public final Color getMultipleSelectionColor() {
        return this.multipleSelectionColor;
    }

    public final void setMultipleSelectionColor(Color multipleSelectionColor) {
        this.multipleSelectionColor = multipleSelectionColor;
        if (this.textArea.getBuffer() != null) {
            this.textArea.invalidateSelectedLines();
        }
    }

    public final Color getLineHighlightColor() {
        return this.lineHighlightColor;
    }

    public final void setLineHighlightColor(Color lineHighlightColor) {
        this.lineHighlightColor = lineHighlightColor;
        if (this.textArea.getBuffer() != null) {
            this.textArea.invalidateLine(this.textArea.getCaretLine());
        }
    }

    public final boolean isLineHighlightEnabled() {
        return this.lineHighlight;
    }

    public final void setLineHighlightEnabled(boolean lineHighlight) {
        this.lineHighlight = lineHighlight;
        if (this.textArea.getBuffer() != null) {
            this.textArea.invalidateSelectedLines();
        }
    }

    public final Color getStructureHighlightColor() {
        return this.structureHighlightColor;
    }

    public final void setStructureHighlightColor(Color structureHighlightColor) {
        this.structureHighlightColor = structureHighlightColor;
        StructureMatcher.Match match = this.textArea.getStructureMatch();
        if (match != null) {
            this.textArea.invalidateLineRange(match.startLine, match.endLine);
        }
    }

    public final boolean isStructureHighlightEnabled() {
        return this.structureHighlight;
    }

    public final void setStructureHighlightEnabled(boolean structureHighlight) {
        this.structureHighlight = structureHighlight;
        StructureMatcher.Match match = this.textArea.getStructureMatch();
        if (match != null) {
            this.textArea.invalidateLineRange(match.startLine, match.endLine);
        }
    }

    public final boolean isBlockCaretEnabled() {
        return this.blockCaret;
    }

    public final void setBlockCaretEnabled(boolean blockCaret) {
        this.blockCaret = blockCaret;
        this.extensionMgr.removeExtension(this.caretExtension);
        if (blockCaret) {
            this.addExtension(50, this.caretExtension);
        } else {
            this.addExtension(300, this.caretExtension);
        }
        if (this.textArea.getBuffer() != null) {
            this.textArea.invalidateLine(this.textArea.getCaretLine());
        }
    }

    public final Color getEOLMarkerColor() {
        return this.eolMarkerColor;
    }

    public final void setEOLMarkerColor(Color eolMarkerColor) {
        this.eolMarkerColor = eolMarkerColor;
        this.repaint();
    }

    public final boolean getEOLMarkersPainted() {
        return this.eolMarkers;
    }

    public final void setEOLMarkersPainted(boolean eolMarkers) {
        this.eolMarkers = eolMarkers;
        this.repaint();
    }

    public final Color getWrapGuideColor() {
        return this.wrapGuideColor;
    }

    public final void setWrapGuideColor(Color wrapGuideColor) {
        this.wrapGuideColor = wrapGuideColor;
        this.repaint();
    }

    public final boolean isWrapGuidePainted() {
        return this.wrapGuide;
    }

    public final void setWrapGuidePainted(boolean wrapGuide) {
        this.wrapGuide = wrapGuide;
        this.repaint();
    }

    public final SyntaxStyle[] getFoldLineStyle() {
        return this.foldLineStyle;
    }

    public final void setFoldLineStyle(SyntaxStyle[] foldLineStyle) {
        this.foldLineStyle = foldLineStyle;
        this.repaint();
    }

    public void setAntiAliasEnabled(boolean antiAlias) {
        this.antiAlias = antiAlias;
        this.updateRenderingHints();
    }

    public boolean isAntiAliasEnabled() {
        return this.antiAlias;
    }

    public void setFractionalFontMetricsEnabled(boolean fracFontMetrics) {
        this.fracFontMetrics = fracFontMetrics;
        this.updateRenderingHints();
    }

    public boolean isFractionalFontMetricsEnabled() {
        return this.fracFontMetrics;
    }

    public FontRenderContext getFontRenderContext() {
        return this.fontRenderContext;
    }

    public void addExtension(TextAreaExtension extension) {
        this.extensionMgr.addExtension(0, extension);
        this.repaint();
    }

    public void addExtension(int layer, TextAreaExtension extension) {
        this.extensionMgr.addExtension(layer, extension);
        this.repaint();
    }

    public void removeExtension(TextAreaExtension extension) {
        this.extensionMgr.removeExtension(extension);
        this.repaint();
    }

    public TextAreaExtension[] getExtensions() {
        return this.extensionMgr.getExtensions();
    }

    public String getToolTipText(MouseEvent evt) {
        if (!this.textArea.getBuffer().isLoaded()) {
            return null;
        }
        return this.extensionMgr.getToolTipText(evt.getX(), evt.getY());
    }

    public FontMetrics getFontMetrics() {
        return this.fm;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.fm = this.getFontMetrics(font);
        this.textArea.recalculateVisibleLines();
        if (this.textArea.getBuffer() != null && this.textArea.getBuffer().isLoaded()) {
            this.textArea.recalculateLastPhysicalLine();
        }
        this.textArea.propertiesChanged();
    }

    public float getStringWidth(String str) {
        if (this.textArea.charWidth != 0) {
            return this.textArea.charWidth * str.length();
        }
        return (float)this.getFont().getStringBounds(str, this.getFontRenderContext()).getWidth();
    }

    public void paintComponent(Graphics _gfx) {
        Graphics2D gfx = (Graphics2D)_gfx;
        gfx.setRenderingHints(this.renderingHints);
        this.fontRenderContext = gfx.getFontRenderContext();
        Rectangle clipRect = gfx.getClipBounds();
        gfx.setColor(this.getBackground());
        gfx.fillRect(clipRect.x, clipRect.y, clipRect.width, clipRect.height);
        Buffer buffer = this.textArea.getBuffer();
        if (!buffer.isLoaded()) {
            return;
        }
        int height = this.fm.getHeight();
        if (height == 0) {
            return;
        }
        int firstInvalid = clipRect.y / height;
        int lastInvalid = (clipRect.y + clipRect.height - 1) / height;
        if (Debug.PAINT_TIMER && lastInvalid - firstInvalid >= 1) {
            Log.log(1, this, "repainting " + (lastInvalid - firstInvalid) + " lines");
        }
        int y = clipRect.y - clipRect.y % height;
        this.extensionMgr.paintScreenLineRange(this.textArea, gfx, firstInvalid, lastInvalid, y, height);
        this.textArea.updateMaxHorizontalScrollWidth();
        this.textArea.displayManager._notifyScreenLineChanges();
    }

    public float nextTabStop(float x, int tabOffset) {
        int ntabs = (int)(x / this.textArea.tabSize);
        return (float)(ntabs + 1) * this.textArea.tabSize;
    }

    public Dimension getPreferredSize() {
        Dimension dim = new Dimension();
        char[] foo = new char[80];
        for (int i = 0; i < foo.length; ++i) {
            foo[i] = 32;
        }
        dim.width = (int)this.getStringWidth(new String(foo));
        dim.height = this.fm.getHeight() * 25;
        return dim;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    TextAreaPainter(JEditTextArea textArea) {
        this.enableEvents(28L);
        this.textArea = textArea;
        this.fonts = new HashMap();
        this.extensionMgr = new ExtensionManager();
        this.setAutoscrolls(true);
        this.setOpaque(true);
        this.setRequestFocusEnabled(false);
        this.setCursor(Cursor.getPredefinedCursor(2));
        this.fontRenderContext = new FontRenderContext(null, false, false);
        this.addExtension(-50, new PaintLineBackground());
        this.addExtension(-30, new PaintSelection());
        this.addExtension(-20, new PaintWrapGuide());
        this.addExtension(100, new StructureMatcher.Highlight(textArea));
        this.addExtension(200, new PaintText());
        this.caretExtension = new PaintCaret();
    }

    private void updateRenderingHints() {
        HashMap<RenderingHints.Key, Object> hints = new HashMap<RenderingHints.Key, Object>();
        if (this.antiAlias) {
            hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        hints.put(RenderingHints.KEY_FRACTIONALMETRICS, this.fracFontMetrics ? RenderingHints.VALUE_FRACTIONALMETRICS_ON : RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        this.renderingHints = new RenderingHints(hints);
        this.fontRenderContext = new FontRenderContext(null, this.antiAlias, this.fracFontMetrics);
    }

    private int getCharWidth(Font font) {
        Integer returnValue = (Integer)this.fonts.get(font);
        if (returnValue == null) {
            int minWidth = Integer.MAX_VALUE;
            int maxWidth = Integer.MIN_VALUE;
            FontMetrics fm = this.getFontMetrics(font);
            int[] widths = fm.getWidths();
            for (int i = 0; i < widths.length; ++i) {
                int width = widths[i];
                if (width == 0 || !font.canDisplay((char)i)) continue;
                minWidth = Math.min(width, minWidth);
                maxWidth = Math.max(width, maxWidth);
            }
            String str = "iwiwiwiau1234";
            double width1 = font.createGlyphVector(this.textArea.getPainter().getFontRenderContext(), str).getLogicalBounds().getWidth();
            double width2 = str.length() * maxWidth;
            if (minWidth == maxWidth && (int)width1 == (int)width2) {
                Log.log(1, this, "Using monospaced font optimization: " + font);
                returnValue = new Integer(maxWidth);
            } else {
                Log.log(1, this, "Not using monospaced font optimization: " + font);
                Log.log(1, this, "Minimum width = " + minWidth + ", maximum width = " + maxWidth + ", width 1 = " + width1 + ", width 2 = " + width2);
                returnValue = new Integer(0);
            }
            this.fonts.put(font, returnValue);
        }
        return returnValue;
    }

    class PaintCaret
    extends TextAreaExtension {
        PaintCaret() {
        }

        public void paintValidLine(Graphics2D gfx, int screenLine, int physicalLine, int start, int end, int y) {
            if (!TextAreaPainter.this.textArea.isCaretVisible()) {
                return;
            }
            int caret = TextAreaPainter.this.textArea.getCaretPosition();
            if (caret < start || caret >= end) {
                return;
            }
            int offset = caret - TextAreaPainter.this.textArea.getLineStartOffset(physicalLine);
            TextAreaPainter.this.textArea.offsetToXY(physicalLine, offset, TextAreaPainter.this.textArea.returnValue);
            int caretX = TextAreaPainter.this.textArea.returnValue.x;
            int height = TextAreaPainter.this.fm.getHeight();
            gfx.setColor(TextAreaPainter.this.caretColor);
            if (TextAreaPainter.this.textArea.isOverwriteEnabled()) {
                gfx.drawLine(caretX, y + height - 1, caretX + TextAreaPainter.this.textArea.charWidth, y + height - 1);
            } else if (TextAreaPainter.this.blockCaret) {
                gfx.drawRect(caretX, y, TextAreaPainter.this.textArea.charWidth - 1, height - 1);
            } else {
                gfx.drawLine(caretX, y, caretX, y + height - 1);
            }
        }
    }

    class PaintText
    extends TextAreaExtension {
        PaintText() {
        }

        public void paintValidLine(Graphics2D gfx, int screenLine, int physicalLine, int start, int end, int y) {
            int x;
            ChunkCache.LineInfo lineInfo = TextAreaPainter.this.textArea.chunkCache.getLineInfo(screenLine);
            Font defaultFont = TextAreaPainter.this.getFont();
            Color defaultColor = TextAreaPainter.this.getForeground();
            gfx.setFont(defaultFont);
            gfx.setColor(defaultColor);
            int originalX = x = TextAreaPainter.this.textArea.getHorizontalOffset();
            float baseLine = y + TextAreaPainter.this.fm.getHeight() - TextAreaPainter.this.fm.getLeading() - TextAreaPainter.this.fm.getDescent();
            if (lineInfo.chunks != null) {
                x = (int)((float)x + Chunk.paintChunkList(lineInfo.chunks, gfx, TextAreaPainter.this.textArea.getHorizontalOffset(), baseLine, !Debug.DISABLE_GLYPH_VECTOR));
            }
            Buffer buffer = TextAreaPainter.this.textArea.getBuffer();
            if (!lineInfo.lastSubregion) {
                gfx.setFont(defaultFont);
                gfx.setColor(TextAreaPainter.this.eolMarkerColor);
                gfx.drawString(":", (float)Math.max(x, TextAreaPainter.this.textArea.getHorizontalOffset() + TextAreaPainter.this.textArea.getDisplayManager().wrapMargin + TextAreaPainter.this.textArea.charWidth), baseLine);
                x += TextAreaPainter.this.textArea.charWidth;
            } else if (physicalLine < buffer.getLineCount() - 1 && buffer.isFoldStart(physicalLine) && !TextAreaPainter.this.textArea.displayManager.isLineVisible(physicalLine + 1)) {
                int level = buffer.getFoldLevel(physicalLine + 1);
                if (buffer.getFoldHandler() instanceof IndentFoldHandler) {
                    level = Math.max(1, level / buffer.getIndentSize());
                }
                if (level > 3) {
                    level = 0;
                }
                SyntaxStyle foldLineStyle = TextAreaPainter.this.foldLineStyle[level];
                Font font = foldLineStyle.getFont();
                gfx.setFont(font);
                gfx.setColor(foldLineStyle.getForegroundColor());
                int nextScreenLine = screenLine + 1;
                int nextLine = nextScreenLine < TextAreaPainter.this.textArea.getVisibleLines() ? TextAreaPainter.this.textArea.chunkCache.getLineInfo((int)nextScreenLine).physicalLine : TextAreaPainter.this.textArea.displayManager.getNextVisibleLine(physicalLine);
                if (nextLine == -1) {
                    nextLine = TextAreaPainter.this.textArea.getLineCount();
                }
                int count = nextLine - physicalLine - 1;
                String str = " [" + count + " lines]";
                float width = TextAreaPainter.this.getStringWidth(str);
                gfx.drawString(str, (float)x, baseLine);
                x = (int)((float)x + width);
            } else if (TextAreaPainter.this.eolMarkers) {
                gfx.setFont(defaultFont);
                gfx.setColor(TextAreaPainter.this.eolMarkerColor);
                gfx.drawString(".", (float)x, baseLine);
                x += TextAreaPainter.this.textArea.charWidth;
            }
            lineInfo.width = x - originalX;
        }
    }

    class PaintWrapGuide
    extends TextAreaExtension {
        PaintWrapGuide() {
        }

        public void paintScreenLineRange(Graphics2D gfx, int firstLine, int lastLine, int[] physicalLines, int[] start, int[] end, int y, int lineHeight) {
            if (TextAreaPainter.this.textArea.getDisplayManager().wrapMargin != 0 && TextAreaPainter.this.isWrapGuidePainted()) {
                gfx.setColor(TextAreaPainter.this.getWrapGuideColor());
                int x = TextAreaPainter.this.textArea.getHorizontalOffset() + TextAreaPainter.this.textArea.getDisplayManager().wrapMargin;
                gfx.drawLine(x, y, x, y + (lastLine - firstLine + 1) * lineHeight);
            }
        }

        public String getToolTipText(int x, int y) {
            int wrapGuidePos;
            if (TextAreaPainter.this.textArea.getDisplayManager().wrapMargin != 0 && TextAreaPainter.this.isWrapGuidePainted() && Math.abs(x - (wrapGuidePos = TextAreaPainter.this.textArea.getDisplayManager().wrapMargin + TextAreaPainter.this.textArea.getHorizontalOffset())) < 5) {
                return String.valueOf(TextAreaPainter.this.textArea.getBuffer().getProperty("maxLineLen"));
            }
            return null;
        }
    }

    class PaintSelection
    extends TextAreaExtension {
        PaintSelection() {
        }

        public void paintValidLine(Graphics2D gfx, int screenLine, int physicalLine, int start, int end, int y) {
            if (TextAreaPainter.this.textArea.selection.size() == 0) {
                return;
            }
            gfx.setColor(TextAreaPainter.this.textArea.isMultipleSelectionEnabled() ? TextAreaPainter.this.getMultipleSelectionColor() : TextAreaPainter.this.getSelectionColor());
            for (int i = TextAreaPainter.this.textArea.selection.size() - 1; i >= 0; --i) {
                this.paintSelection(gfx, screenLine, physicalLine, y, (Selection)TextAreaPainter.this.textArea.selection.get(i));
            }
        }

        private void paintSelection(Graphics2D gfx, int screenLine, int physicalLine, int y, Selection s) {
            int[] selectionStartAndEnd = TextAreaPainter.this.textArea.getSelectionStartAndEnd(screenLine, physicalLine, s);
            if (selectionStartAndEnd == null) {
                return;
            }
            int x1 = selectionStartAndEnd[0];
            int x2 = selectionStartAndEnd[1];
            gfx.fillRect(x1, y, x2 - x1, TextAreaPainter.this.fm.getHeight());
        }
    }

    class PaintLineBackground
    extends TextAreaExtension {
        PaintLineBackground() {
        }

        public void paintValidLine(Graphics2D gfx, int screenLine, int physicalLine, int start, int end, int y) {
            Color bgColor;
            boolean paintLineHighlight;
            JEditTextArea textArea = TextAreaPainter.this.textArea;
            Buffer buffer = textArea.getBuffer();
            boolean collapsedFold = physicalLine < buffer.getLineCount() - 1 && buffer.isFoldStart(physicalLine) && !textArea.displayManager.isLineVisible(physicalLine + 1);
            SyntaxStyle foldLineStyle = null;
            if (collapsedFold) {
                int level = buffer.getFoldLevel(physicalLine + 1);
                if (buffer.getFoldHandler() instanceof IndentFoldHandler) {
                    level = Math.max(1, level / buffer.getIndentSize());
                }
                if (level > 3) {
                    level = 0;
                }
                foldLineStyle = TextAreaPainter.this.foldLineStyle[level];
            }
            int caret = textArea.getCaretPosition();
            boolean bl = paintLineHighlight = TextAreaPainter.this.isLineHighlightEnabled() && caret >= start && caret < end && textArea.selection.size() == 0;
            if (paintLineHighlight) {
                bgColor = TextAreaPainter.this.lineHighlightColor;
            } else if (collapsedFold) {
                bgColor = foldLineStyle.getBackgroundColor();
                if (bgColor == null) {
                    bgColor = TextAreaPainter.this.getBackground();
                }
            } else {
                bgColor = TextAreaPainter.this.getBackground();
            }
            if (paintLineHighlight || collapsedFold) {
                gfx.setColor(bgColor);
                gfx.fillRect(0, y, TextAreaPainter.this.getWidth(), TextAreaPainter.this.fm.getHeight());
            }
            ChunkCache.LineInfo lineInfo = textArea.chunkCache.getLineInfo(screenLine);
            if (lineInfo.chunks != null) {
                float baseLine = y + TextAreaPainter.this.fm.getHeight() - TextAreaPainter.this.fm.getLeading() - TextAreaPainter.this.fm.getDescent();
                Chunk.paintChunkBackgrounds(lineInfo.chunks, gfx, textArea.getHorizontalOffset(), baseLine);
            }
        }
    }
}

