/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import java.awt.font.FontRenderContext;
import java.util.List;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import org.gjt.sp.jedit.syntax.Chunk;
import org.gjt.sp.jedit.syntax.DefaultTokenHandler;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.jedit.syntax.Token;
import org.gjt.sp.jedit.syntax.TokenMarker;

public class DisplayTokenHandler
extends DefaultTokenHandler {
    public static final int MAX_CHUNK_LEN = 100;
    private SyntaxStyle[] styles;
    private FontRenderContext fontRenderContext;
    private TabExpander expander;
    private float x;
    private List out;
    private float wrapMargin;
    private float endX;
    private Token end;
    private boolean seenNonWhitespace;
    private float endOfWhitespace;

    public void init(SyntaxStyle[] styles, FontRenderContext fontRenderContext, TabExpander expander, List out, float wrapMargin) {
        super.init();
        this.x = 0.0f;
        this.styles = styles;
        this.fontRenderContext = fontRenderContext;
        this.expander = expander;
        this.wrapMargin = wrapMargin != 0.0f ? (wrapMargin += 2.0f) : 0.0f;
        this.out = out;
        this.seenNonWhitespace = false;
        this.endOfWhitespace = 0.0f;
        this.endX = 0.0f;
        this.end = null;
    }

    public List getChunkList() {
        return this.out;
    }

    public void handleToken(Segment seg, byte id, int offset, int length, TokenMarker.LineContext context) {
        if (id == 127) {
            if (this.firstToken != null) {
                this.out.add(this.merge((Chunk)this.firstToken, seg));
            }
            return;
        }
        for (int splitOffset = 0; splitOffset < length; splitOffset += 100) {
            int splitLength = Math.min(length - splitOffset, 100);
            Chunk chunk = this.createChunk(id, offset + splitOffset, splitLength, context);
            this.addToken(chunk, context);
            if (this.wrapMargin == 0.0f) continue;
            this.initChunk(chunk, seg);
            this.x += chunk.width;
            if (Character.isWhitespace(seg.array[seg.offset + chunk.offset])) {
                if (this.seenNonWhitespace) {
                    this.end = this.lastToken;
                    this.endX = this.x;
                    continue;
                }
                this.endOfWhitespace = this.x;
                continue;
            }
            if (this.x > this.wrapMargin && this.end != null && this.seenNonWhitespace) {
                Chunk nextLine = new Chunk(this.endOfWhitespace, this.end.offset + this.end.length, this.getParserRuleSet(context));
                this.initChunk(nextLine, seg);
                nextLine.next = this.end.next;
                this.end.next = null;
                if (this.firstToken != null) {
                    this.out.add(this.merge((Chunk)this.firstToken, seg));
                }
                this.firstToken = nextLine;
                this.x = this.x - this.endX + this.endOfWhitespace;
                this.end = null;
                this.endX = this.x;
            }
            this.seenNonWhitespace = true;
        }
    }

    private Chunk createChunk(byte id, int offset, int length, TokenMarker.LineContext context) {
        return new Chunk(id, offset, length, this.getParserRuleSet(context), this.styles, context.rules.getDefault());
    }

    protected void initChunk(Chunk chunk, Segment seg) {
        chunk.init(seg, this.expander, this.x, this.fontRenderContext);
    }

    private Chunk merge(Chunk first, Segment seg) {
        if (first == null) {
            return null;
        }
        Chunk chunk = first;
        while (chunk.next != null) {
            Chunk next = (Chunk)chunk.next;
            if (this.canMerge(chunk, next, seg)) {
                chunk.initialized = false;
                chunk.length += next.length;
                chunk.width += next.width;
                chunk.next = next.next;
                continue;
            }
            if (!chunk.initialized) {
                this.initChunk(chunk, seg);
                if (this.wrapMargin == 0.0f) {
                    this.x += chunk.width;
                }
            }
            chunk = next;
        }
        if (!chunk.initialized) {
            this.initChunk(chunk, seg);
        }
        return first;
    }

    private boolean canMerge(Chunk c1, Chunk c2, Segment seg) {
        if (!c1.accessable || !c2.accessable) {
            return false;
        }
        char ch1 = seg.array[seg.offset + c1.offset];
        char ch2 = seg.array[seg.offset + c2.offset];
        return c1.style == c2.style && ch1 != '\t' && ch2 != '\t' && c1.length + c2.length <= 100;
    }
}

