/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.pluginmgr.MirrorList;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.WorkRequest;

public class PluginManagerOptionPane
extends AbstractOptionPane {
    private JLabel locationLabel;
    private JLabel mirrorLabel;
    private ButtonGroup locGrp;
    private JRadioButton settingsDir;
    private JRadioButton appDir;
    private JCheckBox downloadSource;
    private JCheckBox deleteDownloads;
    private MirrorModel miraModel;
    private JList miraList;

    public PluginManagerOptionPane() {
        super("plugin-manager");
    }

    protected void _init() {
        this.setLayout(new BorderLayout());
        this.locationLabel = new JLabel(jEdit.getProperty("options.plugin-manager.location"));
        this.mirrorLabel = new JLabel(jEdit.getProperty("options.plugin-manager.mirror"));
        if (jEdit.getSettingsDirectory() != null) {
            this.settingsDir = new JRadioButton(jEdit.getProperty("options.plugin-manager.settings-dir"));
            this.settingsDir.setToolTipText(MiscUtilities.constructPath(jEdit.getSettingsDirectory(), "jars"));
        }
        this.appDir = new JRadioButton(jEdit.getProperty("options.plugin-manager.app-dir"));
        this.appDir.setToolTipText(MiscUtilities.constructPath(jEdit.getJEditHome(), "jars"));
        this.miraModel = new MirrorModel();
        this.miraList = new JList(this.miraModel);
        this.miraList.setSelectionModel(new SingleSelectionModel());
        this.add("North", this.mirrorLabel);
        this.add("Center", new JScrollPane(this.miraList));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        buttonPanel.add(Box.createVerticalStrut(6));
        JButton updateMirrors = new JButton(jEdit.getProperty("options.plugin-manager.updateMirrors"));
        updateMirrors.addActionListener(new ActionHandler());
        buttonPanel.add(updateMirrors);
        buttonPanel.add(Box.createVerticalStrut(6));
        this.downloadSource = new JCheckBox(jEdit.getProperty("options.plugin-manager.downloadSource"));
        this.downloadSource.setSelected(jEdit.getBooleanProperty("plugin-manager.downloadSource"));
        buttonPanel.add(this.downloadSource);
        buttonPanel.add(Box.createVerticalStrut(6));
        this.deleteDownloads = new JCheckBox(jEdit.getProperty("options.plugin-manager.deleteDownloads"));
        this.deleteDownloads.setSelected(jEdit.getBooleanProperty("plugin-manager.deleteDownloads"));
        buttonPanel.add(this.deleteDownloads);
        buttonPanel.add(Box.createVerticalStrut(6));
        this.locGrp = new ButtonGroup();
        if (jEdit.getSettingsDirectory() != null) {
            this.locGrp.add(this.settingsDir);
        }
        this.locGrp.add(this.appDir);
        JPanel locPanel = new JPanel();
        locPanel.setBorder(new EmptyBorder(3, 12, 0, 0));
        locPanel.setLayout(new BoxLayout(locPanel, 1));
        if (jEdit.getSettingsDirectory() != null) {
            locPanel.add(this.settingsDir);
            locPanel.add(Box.createVerticalStrut(3));
        }
        locPanel.add(this.appDir);
        buttonPanel.add(this.locationLabel);
        buttonPanel.add(locPanel);
        buttonPanel.add(Box.createGlue());
        this.add("South", buttonPanel);
        if (jEdit.getBooleanProperty("plugin-manager.installUser") && jEdit.getSettingsDirectory() != null) {
            this.settingsDir.setSelected(true);
        } else {
            this.appDir.setSelected(true);
        }
    }

    protected void _save() {
        jEdit.setBooleanProperty("plugin-manager.installUser", this.settingsDir != null && this.settingsDir.isSelected());
        jEdit.setBooleanProperty("plugin-manager.downloadSource", this.downloadSource.isSelected());
        jEdit.setBooleanProperty("plugin-manager.deleteDownloads", this.deleteDownloads.isSelected());
        if (this.miraList.getSelectedIndex() != -1) {
            String currentMirror = this.miraModel.getID(this.miraList.getSelectedIndex());
            String previousMirror = jEdit.getProperty("plugin-manager.mirror.id");
            if (!previousMirror.equals(currentMirror)) {
                jEdit.setProperty("plugin-manager.mirror.id", currentMirror);
            }
        }
    }

    static /* synthetic */ MirrorModel access$100(PluginManagerOptionPane x0) {
        return x0.miraModel;
    }

    static /* synthetic */ JList access$200(PluginManagerOptionPane x0) {
        return x0.miraList;
    }

    class DownloadMirrorsThread
    extends WorkRequest {
        DownloadMirrorsThread() {
        }

        public void run() {
            this.setStatus(jEdit.getProperty("options.plugin-manager.workthread"));
            this.setProgressMaximum(1);
            this.setProgressValue(0);
            ArrayList mirrors = new ArrayList();
            try {
                mirrors.addAll(new MirrorList().mirrors);
            }
            catch (Exception ex) {
                Log.log(9, this, ex);
                GUIUtilities.error(PluginManagerOptionPane.this, "ioerror", new String[]{ex.toString()});
            }
            SwingUtilities.invokeLater(new Runnable(this, mirrors){
                private final /* synthetic */ ArrayList val$mirrors;
                private final /* synthetic */ DownloadMirrorsThread this$1;
                {
                    this.this$1 = this$1;
                    this.val$mirrors = val$mirrors;
                }

                public void run() {
                    PluginManagerOptionPane.access$100(DownloadMirrorsThread.access$000(this.this$1)).setList(this.val$mirrors);
                    String id = jEdit.getProperty("plugin-manager.mirror.id");
                    int size = PluginManagerOptionPane.access$100(DownloadMirrorsThread.access$000(this.this$1)).getSize();
                    for (int i = 0; i < size; ++i) {
                        if (size != 1 && !PluginManagerOptionPane.access$100(DownloadMirrorsThread.access$000(this.this$1)).getID(i).equals(id)) continue;
                        PluginManagerOptionPane.access$200(DownloadMirrorsThread.access$000(this.this$1)).setSelectedIndex(i);
                        break;
                    }
                }
            });
            this.setProgressValue(1);
        }

        static /* synthetic */ PluginManagerOptionPane access$000(DownloadMirrorsThread x0) {
            return x0.PluginManagerOptionPane.this;
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            VFSManager.runInWorkThread(new DownloadMirrorsThread());
        }
    }

    class SingleSelectionModel
    extends DefaultListSelectionModel {
        public SingleSelectionModel() {
            this.setSelectionMode(0);
        }

        public void removeSelectionInterval(int index0, int index1) {
        }
    }

    class MirrorModel
    extends AbstractListModel {
        private ArrayList mirrors = new ArrayList();

        public String getID(int index) {
            return ((MirrorList.Mirror)this.mirrors.get((int)index)).id;
        }

        public int getSize() {
            return this.mirrors.size();
        }

        public Object getElementAt(int index) {
            MirrorList.Mirror mirror = (MirrorList.Mirror)this.mirrors.get(index);
            if (mirror.id.equals("NONE")) {
                return jEdit.getProperty("options.plugin-manager.none");
            }
            return mirror.continent + ": " + mirror.description + " (" + mirror.location + ")";
        }

        public void setList(ArrayList mirrors) {
            this.mirrors = mirrors;
            this.fireContentsChanged(this, 0, mirrors.size() - 1);
        }
    }
}

