/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.menu;

import java.util.Collections;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.gjt.sp.jedit.Macros;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.menu.DynamicMenuProvider;
import org.gjt.sp.jedit.menu.EnhancedMenuItem;

public class MacrosProvider
implements DynamicMenuProvider {
    public boolean updateEveryTime() {
        return false;
    }

    public void update(JMenu menu) {
        Vector macroVector = Macros.getMacroHierarchy();
        int count = menu.getMenuComponentCount();
        this.createMacrosMenu(menu, macroVector, 0);
        if (count == menu.getMenuComponentCount()) {
            JMenuItem mi = new JMenuItem(jEdit.getProperty("no-macros.label"));
            mi.setEnabled(false);
            menu.add(mi);
        }
    }

    private void createMacrosMenu(JMenu menu, Vector vector, int start) {
        int i;
        Vector<JMenuItem> menuItems = new Vector<JMenuItem>();
        for (i = start; i < vector.size(); ++i) {
            Object obj = vector.elementAt(i);
            if (obj instanceof String) {
                menuItems.add(new EnhancedMenuItem(jEdit.getProperty(obj + ".label"), (String)obj, jEdit.getActionContext()));
                continue;
            }
            if (!(obj instanceof Vector)) continue;
            Vector subvector = (Vector)obj;
            String name = (String)subvector.elementAt(0);
            JMenu submenu = new JMenu(name);
            this.createMacrosMenu(submenu, subvector, 1);
            if (submenu.getMenuComponentCount() == 0) continue;
            menuItems.add(submenu);
        }
        Collections.sort(menuItems, new MiscUtilities.MenuItemCompare());
        for (i = 0; i < menuItems.size(); ++i) {
            menu.add((JMenuItem)menuItems.get(i));
        }
    }
}

