/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.browser.FileCellRenderer;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.io.FavoritesVFS;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.menu.DynamicMenuProvider;

public class FavoritesProvider
implements DynamicMenuProvider {
    public boolean updateEveryTime() {
        return false;
    }

    public void update(JMenu menu) {
        final View view = GUIUtilities.getView(menu);
        ActionListener fileListener = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                jEdit.openFile(view, evt.getActionCommand());
            }
        };
        ActionListener dirListener = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                VFSBrowser.browseDirectory(view, evt.getActionCommand());
            }
        };
        Object[] favorites = FavoritesVFS.getFavorites();
        if (favorites.length == 0) {
            JMenuItem mi = new JMenuItem(jEdit.getProperty("vfs.browser.favorites.no-favorites.label"));
            mi.setEnabled(false);
            menu.add(mi);
        } else {
            MiscUtilities.quicksort(favorites, (MiscUtilities.Compare)new VFS.DirectoryEntryCompare(jEdit.getBooleanProperty("vfs.browser.sortMixFilesAndDirs"), jEdit.getBooleanProperty("vfs.browser.sortIgnoreCase")));
            for (int i = 0; i < favorites.length; ++i) {
                Object favorite = favorites[i];
                JMenuItem mi = new JMenuItem(((VFS.DirectoryEntry)favorite).path);
                mi.setIcon(FileCellRenderer.getIconForFile((VFS.DirectoryEntry)favorite, false));
                if (((VFS.DirectoryEntry)favorite).type == 0) {
                    mi.addActionListener(fileListener);
                } else {
                    mi.addActionListener(dirListener);
                }
                menu.add(mi);
            }
        }
    }
}

