/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.io;

import java.awt.Component;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.DynamicMenuChanged;

public class FavoritesVFS
extends VFS {
    public static final String PROTOCOL = "favorites";
    private static FavoritesVFS instance;
    private static Object lock;
    private static List favorites;

    public FavoritesVFS() {
        super(PROTOCOL, 72, new String[]{"type"});
        instance = this;
    }

    public String getParentOfPath(String path) {
        return "favorites:";
    }

    public VFS.DirectoryEntry[] _listDirectory(Object session, String url, Component comp) {
        return FavoritesVFS.getFavorites();
    }

    public VFS.DirectoryEntry _getDirectoryEntry(Object session, String path, Component comp) {
        return new FavoritesEntry(path, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean _delete(Object session, String path, Component comp) {
        Object object = lock;
        synchronized (object) {
            path = path.substring(PROTOCOL.length() + 1);
            Iterator iter = favorites.iterator();
            while (iter.hasNext()) {
                if (!((FavoritesEntry)iter.next()).path.equals(path)) continue;
                iter.remove();
                VFSManager.sendVFSUpdate(this, "favorites:", false);
                EditBus.send(new DynamicMenuChanged(PROTOCOL));
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadFavorites() {
        Object object = lock;
        synchronized (object) {
            String favorite;
            favorites = new LinkedList();
            int i = 0;
            while ((favorite = jEdit.getProperty("vfs.favorite." + i)) != null) {
                favorites.add(new FavoritesEntry(favorite, jEdit.getIntegerProperty("vfs.favorite." + i + ".type", 1)));
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToFavorites(String path, int type) {
        Object object = lock;
        synchronized (object) {
            if (favorites == null) {
                FavoritesVFS.loadFavorites();
            }
            Iterator iter = favorites.iterator();
            while (iter.hasNext()) {
                if (!((FavoritesEntry)iter.next()).path.equals(path)) continue;
                return;
            }
            favorites.add(new FavoritesEntry(path, type));
            VFSManager.sendVFSUpdate(instance, "favorites:", false);
            EditBus.send(new DynamicMenuChanged(PROTOCOL));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveFavorites() {
        Object object = lock;
        synchronized (object) {
            if (favorites == null) {
                return;
            }
            int i = 0;
            Iterator iter = favorites.iterator();
            while (iter.hasNext()) {
                FavoritesEntry e = (FavoritesEntry)iter.next();
                jEdit.setProperty("vfs.favorite." + i, e.path);
                jEdit.setIntegerProperty("vfs.favorite." + i + ".type", e.type);
                ++i;
            }
            jEdit.unsetProperty("vfs.favorite." + favorites.size());
            jEdit.unsetProperty("vfs.favorite." + favorites.size() + ".type");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VFS.DirectoryEntry[] getFavorites() {
        Object object = lock;
        synchronized (object) {
            if (favorites == null) {
                FavoritesVFS.loadFavorites();
            }
            return favorites.toArray(new VFS.DirectoryEntry[favorites.size()]);
        }
    }

    static {
        lock = new Object();
    }

    static class FavoritesEntry
    extends VFS.DirectoryEntry {
        FavoritesEntry(String path, int type) {
            super(path, path, "favorites:" + path, type, 0L, false);
        }

        public String getExtendedAttribute(String name) {
            if (name.equals("type")) {
                return super.getExtendedAttribute(name);
            }
            return null;
        }
    }
}

