/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.BufferOptions;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.util.WorkThreadPool;
import org.gjt.sp.util.WorkThreadProgressListener;

public class StatusBar
extends JPanel
implements WorkThreadProgressListener {
    private View view;
    private JPanel panel;
    private Box box;
    private ToolTipLabel caretStatus;
    private Component messageComp;
    private JLabel message;
    private JLabel mode;
    private JLabel wrap;
    private JLabel multiSelect;
    private JLabel rectSelect;
    private JLabel overwrite;
    private JLabel lineSep;
    StringBuffer buf = new StringBuffer();
    private Timer tempTimer;
    private boolean currentMessageIsIO;
    private Segment seg = new Segment();
    private boolean showCaretStatus;
    private boolean showEditMode;
    private boolean showFoldMode;
    private boolean showEncoding;
    private boolean showWrap;
    private boolean showMultiSelect;
    private boolean showRectSelect;
    private boolean showOverwrite;
    private boolean showLineSeperator;
    static final String caretTestStr = "9999,999-999 99%";

    public StatusBar(View view) {
        super(new BorderLayout());
        this.setBorder(new CompoundBorder(new EmptyBorder(4, 0, 0, OperatingSystem.isMacOS() ? 18 : 0), UIManager.getBorder("TextField.border")));
        this.view = view;
        this.panel = new JPanel(new BorderLayout());
        this.box = new Box(0);
        this.panel.add("East", this.box);
        this.add("Center", this.panel);
        MouseHandler mouseHandler = new MouseHandler();
        this.caretStatus = new ToolTipLabel();
        this.caretStatus.setToolTipText(jEdit.getProperty("view.status.caret-tooltip"));
        this.caretStatus.addMouseListener(mouseHandler);
        this.message = new JLabel(" ");
        this.setMessageComponent(this.message);
        this.mode = new ToolTipLabel();
        this.mode.setToolTipText(jEdit.getProperty("view.status.mode-tooltip"));
        this.mode.addMouseListener(mouseHandler);
        this.wrap = new ToolTipLabel();
        this.wrap.setHorizontalAlignment(0);
        this.wrap.setToolTipText(jEdit.getProperty("view.status.wrap-tooltip"));
        this.wrap.addMouseListener(mouseHandler);
        this.multiSelect = new ToolTipLabel();
        this.multiSelect.setHorizontalAlignment(0);
        this.multiSelect.setToolTipText(jEdit.getProperty("view.status.multi-tooltip"));
        this.multiSelect.addMouseListener(mouseHandler);
        this.rectSelect = new ToolTipLabel();
        this.rectSelect.setHorizontalAlignment(0);
        this.rectSelect.setToolTipText(jEdit.getProperty("view.status.rect-tooltip"));
        this.rectSelect.addMouseListener(mouseHandler);
        this.overwrite = new ToolTipLabel();
        this.overwrite.setHorizontalAlignment(0);
        this.overwrite.setToolTipText(jEdit.getProperty("view.status.overwrite-tooltip"));
        this.overwrite.addMouseListener(mouseHandler);
        this.lineSep = new ToolTipLabel();
        this.lineSep.setHorizontalAlignment(0);
        this.lineSep.setToolTipText(jEdit.getProperty("view.status.linesep-tooltip"));
        this.lineSep.addMouseListener(mouseHandler);
    }

    public void propertiesChanged() {
        Color fg = jEdit.getColorProperty("view.status.foreground");
        Color bg = jEdit.getColorProperty("view.status.background");
        this.showCaretStatus = jEdit.getBooleanProperty("view.status.show-caret-status");
        this.showEditMode = jEdit.getBooleanProperty("view.status.show-edit-mode");
        this.showFoldMode = jEdit.getBooleanProperty("view.status.show-fold-mode");
        this.showEncoding = jEdit.getBooleanProperty("view.status.show-encoding");
        this.showWrap = jEdit.getBooleanProperty("view.status.show-wrap");
        this.showMultiSelect = jEdit.getBooleanProperty("view.status.show-multi-select");
        this.showRectSelect = jEdit.getBooleanProperty("view.status.show-rect-select");
        this.showOverwrite = jEdit.getBooleanProperty("view.status.show-overwrite");
        this.showLineSeperator = jEdit.getBooleanProperty("view.status.show-line-seperator");
        boolean showMemory = jEdit.getBooleanProperty("view.status.show-memory");
        boolean showClock = jEdit.getBooleanProperty("view.status.show-clock");
        this.panel.setBackground(bg);
        this.panel.setForeground(fg);
        this.caretStatus.setBackground(bg);
        this.caretStatus.setForeground(fg);
        this.message.setBackground(bg);
        this.message.setForeground(fg);
        this.mode.setBackground(bg);
        this.mode.setForeground(fg);
        this.wrap.setBackground(bg);
        this.wrap.setForeground(fg);
        this.multiSelect.setBackground(bg);
        this.multiSelect.setForeground(fg);
        this.rectSelect.setBackground(bg);
        this.rectSelect.setForeground(fg);
        this.overwrite.setBackground(bg);
        this.overwrite.setForeground(fg);
        this.lineSep.setBackground(bg);
        this.lineSep.setForeground(fg);
        Font font = new JLabel().getFont();
        FontMetrics fm = this.getFontMetrics(font);
        Dimension dim = null;
        if (this.showCaretStatus) {
            this.panel.add("West", this.caretStatus);
            this.caretStatus.setFont(font);
            dim = new Dimension(fm.stringWidth(caretTestStr), fm.getHeight());
            this.caretStatus.setPreferredSize(dim);
        } else {
            this.panel.remove(this.caretStatus);
        }
        this.box.removeAll();
        if (this.showEncoding || this.showEditMode || this.showFoldMode) {
            this.box.add(this.mode);
        }
        if (this.showWrap) {
            dim = new Dimension(Math.max(Math.max(fm.charWidth('-'), fm.charWidth('H')), fm.charWidth('S')) + 1, fm.getHeight());
            this.wrap.setPreferredSize(dim);
            this.wrap.setMaximumSize(dim);
            this.box.add(this.wrap);
        }
        if (this.showMultiSelect) {
            dim = new Dimension(Math.max(fm.charWidth('-'), fm.charWidth('M')) + 1, fm.getHeight());
            this.multiSelect.setPreferredSize(dim);
            this.multiSelect.setMaximumSize(dim);
            this.box.add(this.multiSelect);
        }
        if (this.showRectSelect) {
            dim = new Dimension(Math.max(fm.charWidth('-'), fm.charWidth('R')) + 1, fm.getHeight());
            this.rectSelect.setPreferredSize(dim);
            this.rectSelect.setMaximumSize(dim);
            this.box.add(this.rectSelect);
        }
        if (this.showOverwrite) {
            dim = new Dimension(Math.max(fm.charWidth('-'), fm.charWidth('O')) + 1, fm.getHeight());
            this.overwrite.setPreferredSize(dim);
            this.overwrite.setMaximumSize(dim);
            this.box.add(this.overwrite);
        }
        if (this.showLineSeperator) {
            dim = new Dimension(Math.max(Math.max(fm.charWidth('U'), fm.charWidth('W')), fm.charWidth('M')) + 1, fm.getHeight());
            this.lineSep.setPreferredSize(dim);
            this.lineSep.setMaximumSize(dim);
            this.box.add(this.lineSep);
        }
        if (showMemory) {
            this.box.add(new MemoryStatus());
        }
        if (showClock) {
            this.box.add(new Clock());
        }
        this.updateBufferStatus();
        this.updateMiscStatus();
    }

    public void addNotify() {
        super.addNotify();
        VFSManager.getIOThreadPool().addProgressListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        VFSManager.getIOThreadPool().removeProgressListener(this);
    }

    public void statusUpdate(final WorkThreadPool threadPool, int threadIndex) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (StatusBar.this.message != null && !"".equals(StatusBar.this.message.getText().trim()) && !StatusBar.this.currentMessageIsIO) {
                    return;
                }
                int requestCount = threadPool.getRequestCount();
                if (requestCount == 0) {
                    StatusBar.this.setMessageAndClear(jEdit.getProperty("view.status.io.done"));
                    StatusBar.this.currentMessageIsIO = true;
                } else if (requestCount == 1) {
                    StatusBar.this.setMessage(jEdit.getProperty("view.status.io-1"));
                    StatusBar.this.currentMessageIsIO = true;
                } else {
                    Object[] args = new Object[]{new Integer(requestCount)};
                    StatusBar.this.setMessage(jEdit.getProperty("view.status.io", args));
                    StatusBar.this.currentMessageIsIO = true;
                }
            }
        });
    }

    public void progressUpdate(WorkThreadPool threadPool, int threadIndex) {
    }

    public void setMessageAndClear(String message) {
        this.setMessage(message);
        this.tempTimer = new Timer(0, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (StatusBar.this.isShowing()) {
                    StatusBar.this.setMessage(null);
                }
            }
        });
        this.tempTimer.setInitialDelay(10000);
        this.tempTimer.setRepeats(false);
        this.tempTimer.start();
    }

    public void setMessage(String message) {
        if (this.tempTimer != null) {
            this.tempTimer.stop();
            this.tempTimer = null;
        }
        this.setMessageComponent(this.message);
        if (message == null) {
            if (this.view.getMacroRecorder() != null) {
                this.message.setText(jEdit.getProperty("view.status.recording"));
            } else {
                this.message.setText(" ");
            }
        } else {
            this.message.setText(message);
        }
    }

    public void setMessageComponent(Component comp) {
        this.currentMessageIsIO = false;
        if (comp == null || this.messageComp == comp) {
            return;
        }
        this.messageComp = comp;
        this.panel.add("Center", this.messageComp);
    }

    public void updateCaretStatus() {
        if (this.showCaretStatus) {
            Buffer buffer = this.view.getBuffer();
            if (!buffer.isLoaded() || buffer != this.view.getTextArea().getBuffer()) {
                this.caretStatus.setText(" ");
                return;
            }
            JEditTextArea textArea = this.view.getTextArea();
            int currLine = textArea.getCaretLine();
            if (currLine >= buffer.getLineCount()) {
                return;
            }
            int start = textArea.getLineStartOffset(currLine);
            int dot = textArea.getCaretPosition() - start;
            if (dot < 0) {
                return;
            }
            buffer.getText(start, dot, this.seg);
            int virtualPosition = MiscUtilities.getVirtualWidth(this.seg, buffer.getTabSize());
            this.buf.setLength(0);
            this.buf.append(Integer.toString(currLine + 1));
            this.buf.append(',');
            this.buf.append(Integer.toString(dot + 1));
            if (virtualPosition != dot) {
                this.buf.append('-');
                this.buf.append(Integer.toString(virtualPosition + 1));
            }
            this.buf.append(' ');
            int firstLine = textArea.getFirstLine();
            int visible = textArea.getVisibleLines();
            int lineCount = textArea.getDisplayManager().getScrollLineCount();
            if (visible >= lineCount) {
                this.buf.append("All");
            } else if (firstLine == 0) {
                this.buf.append("Top");
            } else if (firstLine + visible >= lineCount) {
                this.buf.append("Bot");
            } else {
                float percent = (float)firstLine / (float)lineCount * 100.0f;
                this.buf.append(Integer.toString((int)percent));
                this.buf.append('%');
            }
            this.caretStatus.setText(this.buf.toString());
        }
    }

    public void updateBufferStatus() {
        Buffer buffer = this.view.getBuffer();
        if (this.showWrap) {
            String wrap = buffer.getStringProperty("wrap");
            if (wrap.equals("none")) {
                this.wrap.setText("-");
            } else if (wrap.equals("hard")) {
                this.wrap.setText("H");
            } else if (wrap.equals("soft")) {
                this.wrap.setText("S");
            }
        }
        if (this.showLineSeperator) {
            String lineSep = buffer.getStringProperty("lineSeparator");
            if ("\n".equals(lineSep)) {
                this.lineSep.setText("U");
            } else if ("\r\n".equals(lineSep)) {
                this.lineSep.setText("W");
            } else if ("\r".equals(lineSep)) {
                this.lineSep.setText("M");
            }
        }
        if (this.showEditMode || this.showFoldMode || this.showEncoding) {
            this.buf.setLength(0);
            if (buffer.isLoaded()) {
                if (this.showEditMode) {
                    this.buf.append(buffer.getMode().getName());
                }
                if (this.showFoldMode) {
                    if (this.showEditMode) {
                        this.buf.append(",");
                    }
                    this.buf.append((String)this.view.getBuffer().getProperty("folding"));
                }
                if (this.showEncoding) {
                    if (this.showEditMode || this.showFoldMode) {
                        this.buf.append(",");
                    }
                    this.buf.append(buffer.getStringProperty("encoding"));
                }
            }
            this.mode.setText("(" + this.buf.toString() + ")");
        }
    }

    public void updateMiscStatus() {
        JEditTextArea textArea = this.view.getTextArea();
        if (this.showMultiSelect) {
            this.multiSelect.setText(textArea.isMultipleSelectionEnabled() ? "M" : "-");
        }
        if (this.showRectSelect) {
            this.rectSelect.setText(textArea.isRectangularSelectionEnabled() ? "R" : "-");
        }
        if (this.showOverwrite) {
            this.overwrite.setText(textArea.isOverwriteEnabled() ? "O" : "-");
        }
    }

    class Clock
    extends JLabel
    implements ActionListener {
        private Timer timer;

        public Clock() {
            this.setForeground(jEdit.getColorProperty("view.status.foreground"));
            this.setBackground(jEdit.getColorProperty("view.status.background"));
        }

        public void addNotify() {
            super.addNotify();
            this.update();
            int millisecondsPerMinute = 60000;
            this.timer = new Timer(millisecondsPerMinute, this);
            this.timer.setInitialDelay((int)((long)millisecondsPerMinute - System.currentTimeMillis() % (long)millisecondsPerMinute) + 500);
            this.timer.start();
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        public void removeNotify() {
            this.timer.stop();
            ToolTipManager.sharedInstance().unregisterComponent(this);
            super.removeNotify();
        }

        public String getToolTipText() {
            return new Date().toString();
        }

        public Point getToolTipLocation(MouseEvent event) {
            return new Point(event.getX(), -20);
        }

        public void actionPerformed(ActionEvent evt) {
            this.update();
        }

        private String getTime() {
            return DateFormat.getTimeInstance(3).format(new Date());
        }

        private void update() {
            this.setText(this.getTime());
        }
    }

    class MemoryStatus
    extends JComponent
    implements ActionListener {
        private static final String memoryTestStr = "999/999Mb";
        private LineMetrics lm;
        private Color progressForeground;
        private Color progressBackground;
        private Timer timer;

        public MemoryStatus() {
            Font font = new JLabel().getFont();
            this.setFont(font);
            FontRenderContext frc = new FontRenderContext(null, false, false);
            Rectangle2D bounds = font.getStringBounds(memoryTestStr, frc);
            Dimension dim = new Dimension((int)bounds.getWidth(), (int)bounds.getHeight());
            this.setPreferredSize(dim);
            this.setMaximumSize(dim);
            this.lm = font.getLineMetrics(memoryTestStr, frc);
            this.setForeground(jEdit.getColorProperty("view.status.foreground"));
            this.setBackground(jEdit.getColorProperty("view.status.background"));
            this.progressForeground = jEdit.getColorProperty("view.status.memory.foreground");
            this.progressBackground = jEdit.getColorProperty("view.status.memory.background");
            this.addMouseListener(new MouseHandler());
        }

        public void addNotify() {
            super.addNotify();
            this.timer = new Timer(2000, this);
            this.timer.start();
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        public void removeNotify() {
            this.timer.stop();
            ToolTipManager.sharedInstance().unregisterComponent(this);
            super.removeNotify();
        }

        public String getToolTipText() {
            Runtime runtime = Runtime.getRuntime();
            int freeMemory = (int)(runtime.freeMemory() / 1024L);
            int totalMemory = (int)(runtime.totalMemory() / 1024L);
            int usedMemory = totalMemory - freeMemory;
            Object[] args = new Integer[]{new Integer(usedMemory), new Integer(totalMemory)};
            return jEdit.getProperty("view.status.memory-tooltip", args);
        }

        public Point getToolTipLocation(MouseEvent event) {
            return new Point(event.getX(), -20);
        }

        public void actionPerformed(ActionEvent evt) {
            this.repaint();
        }

        public void paintComponent(Graphics g) {
            Insets insets = new Insets(0, 0, 0, 0);
            Runtime runtime = Runtime.getRuntime();
            int freeMemory = (int)(runtime.freeMemory() / 1024L);
            int totalMemory = (int)(runtime.totalMemory() / 1024L);
            int usedMemory = totalMemory - freeMemory;
            int width = this.getWidth() - insets.left - insets.right;
            int height = this.getHeight() - insets.top - insets.bottom - 1;
            float fraction = (float)usedMemory / (float)totalMemory;
            g.setColor(this.progressBackground);
            g.fillRect(insets.left, insets.top, (int)((float)width * fraction), height);
            String str = usedMemory / 1024 + "/" + totalMemory / 1024 + "Mb";
            FontRenderContext frc = new FontRenderContext(null, false, false);
            Rectangle2D bounds = g.getFont().getStringBounds(str, frc);
            Graphics g2 = g.create();
            g2.setClip(insets.left, insets.top, (int)((float)width * fraction), height);
            g2.setColor(this.progressForeground);
            g2.drawString(str, insets.left + (int)((double)width - bounds.getWidth()) / 2, (int)((float)insets.top + this.lm.getAscent()));
            g2.dispose();
            g2 = g.create();
            g2.setClip(insets.left + (int)((float)width * fraction), insets.top, this.getWidth() - insets.left - (int)((float)width * fraction), height);
            g2.setColor(this.getForeground());
            g2.drawString(str, insets.left + (int)((double)width - bounds.getWidth()) / 2, (int)((float)insets.top + this.lm.getAscent()));
            g2.dispose();
        }

        class MouseHandler
        extends MouseAdapter {
            MouseHandler() {
            }

            public void mousePressed(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    jEdit.showMemoryDialog(StatusBar.this.view);
                    MemoryStatus.this.repaint();
                }
            }
        }
    }

    class ToolTipLabel
    extends JLabel {
        ToolTipLabel() {
        }

        public Point getToolTipLocation(MouseEvent event) {
            return new Point(event.getX(), -20);
        }
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        public void mouseClicked(MouseEvent evt) {
            Buffer buffer = StatusBar.this.view.getBuffer();
            Object source = evt.getSource();
            if (source == StatusBar.this.caretStatus) {
                if (evt.getClickCount() == 2) {
                    StatusBar.this.view.getTextArea().showGoToLineDialog();
                }
            } else if (source == StatusBar.this.mode) {
                if (evt.getClickCount() == 2) {
                    new BufferOptions(StatusBar.this.view, StatusBar.this.view.getBuffer());
                }
            } else if (source == StatusBar.this.wrap) {
                buffer.toggleWordWrap(StatusBar.this.view);
            } else if (source == StatusBar.this.multiSelect) {
                StatusBar.this.view.getTextArea().toggleMultipleSelectionEnabled();
            } else if (source == StatusBar.this.rectSelect) {
                StatusBar.this.view.getTextArea().toggleRectangularSelectionEnabled();
            } else if (source == StatusBar.this.overwrite) {
                StatusBar.this.view.getTextArea().toggleOverwriteEnabled();
            } else if (source == StatusBar.this.lineSep) {
                buffer.toggleLineSeparator(StatusBar.this.view);
            }
        }
    }
}

