/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.MouseInputAdapter;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.gui.HistoryModel;
import org.gjt.sp.jedit.jEdit;

public class HistoryTextField
extends JTextField {
    private HistoryModel historyModel;
    private JPopupMenu popup;
    private boolean instantPopups;
    private boolean enterAddsToHistory;
    private boolean selectAllOnFocus;
    private String current;
    private int index;

    public HistoryTextField() {
        this(null);
    }

    public HistoryTextField(String name) {
        this(name, false, true);
    }

    public HistoryTextField(String name, boolean instantPopups) {
        this(name, instantPopups, true);
    }

    public HistoryTextField(String name, boolean instantPopups, boolean enterAddsToHistory) {
        this.setModel(name);
        MouseHandler mouseHandler = new MouseHandler();
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
        this.instantPopups = instantPopups;
        this.enterAddsToHistory = enterAddsToHistory;
        this.index = -1;
    }

    public void setInstantPopups(boolean instantPopups) {
        this.instantPopups = instantPopups;
    }

    public boolean getInstantPopups() {
        return this.instantPopups;
    }

    public void setEnterAddsToHistory(boolean enterAddsToHistory) {
        this.enterAddsToHistory = enterAddsToHistory;
    }

    public boolean setEnterAddsToHistory() {
        return this.enterAddsToHistory;
    }

    public void setSelectAllOnFocus(boolean selectAllOnFocus) {
        this.selectAllOnFocus = selectAllOnFocus;
    }

    public boolean setSelectAllOnFocus() {
        return this.selectAllOnFocus;
    }

    public HistoryModel getModel() {
        return this.historyModel;
    }

    public void setModel(String name) {
        Border textFieldBorder = UIManager.getBorder("TextField.border");
        if (name == null) {
            this.historyModel = null;
            if (textFieldBorder != null) {
                this.setBorder(textFieldBorder);
            }
        } else {
            this.historyModel = HistoryModel.getModel(name);
            if (textFieldBorder != null) {
                this.setBorder(new CompoundBorder(textFieldBorder, new HistoryBorder()));
            }
        }
        this.index = -1;
        this.repaint();
    }

    public void addCurrentToHistory() {
        if (this.historyModel != null) {
            this.historyModel.addItem(this.getText());
        }
        this.index = 0;
    }

    public void setText(String text) {
        super.setText(text);
        this.index = -1;
    }

    public void fireActionPerformed() {
        super.fireActionPerformed();
    }

    protected void processKeyEvent(KeyEvent evt) {
        if (!this.isEnabled()) {
            return;
        }
        if (evt.getID() == 401) {
            switch (evt.getKeyCode()) {
                case 10: {
                    if (this.enterAddsToHistory) {
                        this.addCurrentToHistory();
                    }
                    if (evt.getModifiers() != 0) break;
                    this.fireActionPerformed();
                    evt.consume();
                    break;
                }
                case 38: {
                    if (evt.isShiftDown()) {
                        this.doBackwardSearch();
                    } else {
                        this.historyPrevious();
                    }
                    evt.consume();
                    break;
                }
                case 40: {
                    if (evt.isShiftDown()) {
                        this.doForwardSearch();
                    } else if (evt.isAltDown()) {
                        this.showPopupMenu(evt.isShiftDown());
                    } else {
                        this.historyNext();
                    }
                    evt.consume();
                    break;
                }
                case 9: {
                    if (!evt.isControlDown()) break;
                    this.doBackwardSearch();
                    evt.consume();
                }
            }
        }
        if (!evt.isConsumed()) {
            super.processKeyEvent(evt);
        }
    }

    protected void processMouseEvent(MouseEvent evt) {
        if (!this.isEnabled()) {
            return;
        }
        switch (evt.getID()) {
            case 501: {
                Border border = this.getBorder();
                Insets insets = border.getBorderInsets(this);
                if (evt.getX() >= this.getWidth() - insets.right || GUIUtilities.isPopupTrigger(evt)) {
                    this.showPopupMenu(evt.isShiftDown());
                    break;
                }
                super.processMouseEvent(evt);
                break;
            }
            case 505: {
                this.setCursor(Cursor.getDefaultCursor());
                super.processMouseEvent(evt);
                break;
            }
            default: {
                super.processMouseEvent(evt);
            }
        }
    }

    private void doBackwardSearch() {
        String text;
        if (this.historyModel == null) {
            return;
        }
        if (this.getSelectionEnd() != this.getDocument().getLength()) {
            this.setCaretPosition(this.getDocument().getLength());
        }
        if ((text = this.getText().substring(0, this.getSelectionStart())) == null) {
            this.historyPrevious();
            return;
        }
        for (int i = this.index + 1; i < this.historyModel.getSize(); ++i) {
            String item = this.historyModel.getItem(i);
            if (!item.startsWith(text)) continue;
            this.replaceSelection(item.substring(text.length()));
            this.select(text.length(), this.getDocument().getLength());
            this.index = i;
            return;
        }
        this.getToolkit().beep();
    }

    private void doForwardSearch() {
        String text;
        if (this.historyModel == null) {
            return;
        }
        if (this.getSelectionEnd() != this.getDocument().getLength()) {
            this.setCaretPosition(this.getDocument().getLength());
        }
        if ((text = this.getText().substring(0, this.getSelectionStart())) == null) {
            this.historyNext();
            return;
        }
        for (int i = this.index - 1; i >= 0; --i) {
            String item = this.historyModel.getItem(i);
            if (!item.startsWith(text)) continue;
            this.replaceSelection(item.substring(text.length()));
            this.select(text.length(), this.getDocument().getLength());
            this.index = i;
            return;
        }
        this.getToolkit().beep();
    }

    private void historyPrevious() {
        if (this.historyModel == null) {
            return;
        }
        if (this.index == this.historyModel.getSize() - 1) {
            this.getToolkit().beep();
        } else if (this.index == -1) {
            this.current = this.getText();
            this.setText(this.historyModel.getItem(0));
            this.index = 0;
        } else {
            int newIndex = this.index + 1;
            this.setText(this.historyModel.getItem(newIndex));
            this.index = newIndex;
        }
    }

    private void historyNext() {
        if (this.historyModel == null) {
            return;
        }
        if (this.index == -1) {
            this.getToolkit().beep();
        } else if (this.index == 0) {
            this.setText(this.current);
        } else {
            int newIndex = this.index - 1;
            this.setText(this.historyModel.getItem(newIndex));
            this.index = newIndex;
        }
    }

    private void showPopupMenu(String text, int x, int y) {
        if (this.historyModel == null) {
            return;
        }
        this.requestFocus();
        if (this.popup != null && this.popup.isVisible()) {
            this.popup.setVisible(false);
            return;
        }
        ActionHandler actionListener = new ActionHandler();
        this.popup = new JPopupMenu();
        JMenuItem caption = new JMenuItem(jEdit.getProperty("history.caption"));
        caption.getModel().setEnabled(false);
        this.popup.add(caption);
        this.popup.addSeparator();
        for (int i = 0; i < this.historyModel.getSize(); ++i) {
            String item = this.historyModel.getItem(i);
            if (!item.startsWith(text)) continue;
            JMenuItem menuItem = new JMenuItem(item);
            menuItem.setActionCommand(String.valueOf(i));
            menuItem.addActionListener(actionListener);
            this.popup.add(menuItem);
        }
        GUIUtilities.showPopupMenu(this.popup, this, x, y, false);
    }

    private void showPopupMenu(boolean search) {
        if (search) {
            this.showPopupMenu(this.getText().substring(0, this.getSelectionStart()), 0, this.getHeight());
        } else {
            this.showPopupMenu("", 0, this.getHeight());
        }
    }

    static class HistoryBorder
    extends AbstractBorder {
        static final int WIDTH = 16;

        HistoryBorder() {
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x + w - 16, y - 1);
            int w2 = 8;
            int h2 = h / 2;
            g.setColor(UIManager.getColor(c.isEnabled() && ((HistoryTextField)c).getModel() != null ? "TextField.foreground" : "TextField.disabledForeground"));
            g.drawLine(w2 - 5, h2 - 2, w2 + 4, h2 - 2);
            g.drawLine(w2 - 4, h2 - 1, w2 + 3, h2 - 1);
            g.drawLine(w2 - 3, h2, w2 + 2, h2);
            g.drawLine(w2 - 2, h2 + 1, w2 + 1, h2 + 1);
            g.drawLine(w2 - 1, h2 + 2, w2, h2 + 2);
            g.translate(-(x + w - 16), -(y - 1));
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(0, 0, 0, 16);
        }
    }

    class MouseHandler
    extends MouseInputAdapter {
        boolean selectAll;

        MouseHandler() {
        }

        public void mousePressed(MouseEvent evt) {
            this.selectAll = !HistoryTextField.this.hasFocus() && HistoryTextField.this.selectAllOnFocus;
        }

        public void mouseReleased(MouseEvent evt) {
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ MouseHandler this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    if (this.this$1.selectAll) {
                        MouseHandler.access$500(this.this$1).selectAll();
                    }
                }
            });
        }

        public void mouseMoved(MouseEvent evt) {
            Border border = HistoryTextField.this.getBorder();
            Insets insets = border.getBorderInsets(HistoryTextField.this);
            if (evt.getX() >= HistoryTextField.this.getWidth() - insets.right) {
                HistoryTextField.this.setCursor(Cursor.getDefaultCursor());
            } else {
                HistoryTextField.this.setCursor(Cursor.getPredefinedCursor(2));
            }
        }

        public void mouseDragged(MouseEvent evt) {
            this.selectAll = false;
        }

        static /* synthetic */ HistoryTextField access$500(MouseHandler x0) {
            return x0.HistoryTextField.this;
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            int ind = Integer.parseInt(evt.getActionCommand());
            if (ind == -1) {
                if (HistoryTextField.this.index != -1) {
                    HistoryTextField.this.setText(HistoryTextField.this.current);
                }
            } else {
                HistoryTextField.this.setText(HistoryTextField.this.historyModel.getItem(ind));
                HistoryTextField.this.index = ind;
            }
            if (HistoryTextField.this.instantPopups) {
                HistoryTextField.this.addCurrentToHistory();
                HistoryTextField.this.fireActionPerformed();
            }
        }
    }
}

