/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.buffer.FoldHandler;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;

public class BufferOptions
extends EnhancedDialog {
    private View view;
    private Buffer buffer;
    private Mode[] modes;
    private JComboBox mode;
    private JComboBox lineSeparator;
    private JComboBox encoding;
    private JCheckBox gzipped;
    private JComboBox folding;
    private JComboBox wrap;
    private JComboBox maxLineLen;
    private JComboBox tabSize;
    private JComboBox indentSize;
    private JCheckBox noTabs;
    private JButton ok;
    private JButton cancel;

    public BufferOptions(View view, Buffer buffer) {
        super(view, jEdit.getProperty("buffer-options.title"), true);
        this.view = view;
        this.buffer = buffer;
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(content);
        ActionHandler actionListener = new ActionHandler();
        AbstractOptionPane panel = new AbstractOptionPane(null);
        panel.addComponent(GUIUtilities.createMultilineLabel(jEdit.getProperty("buffer-options.caption")));
        panel.addSeparator("buffer-options.loading-saving");
        String[] lineSeps = new String[]{jEdit.getProperty("lineSep.unix"), jEdit.getProperty("lineSep.windows"), jEdit.getProperty("lineSep.mac")};
        this.lineSeparator = new JComboBox<String>(lineSeps);
        String lineSep = buffer.getStringProperty("lineSeparator");
        if (lineSep == null) {
            lineSep = System.getProperty("line.separator");
        }
        if ("\n".equals(lineSep)) {
            this.lineSeparator.setSelectedIndex(0);
        } else if ("\r\n".equals(lineSep)) {
            this.lineSeparator.setSelectedIndex(1);
        } else if ("\r".equals(lineSep)) {
            this.lineSeparator.setSelectedIndex(2);
        }
        panel.addComponent(jEdit.getProperty("buffer-options.lineSeparator"), (Component)this.lineSeparator);
        String[] encodings = MiscUtilities.getEncodings();
        Arrays.sort(encodings, new MiscUtilities.StringICaseCompare());
        this.encoding = new JComboBox<String>(encodings);
        this.encoding.setEditable(true);
        this.encoding.setSelectedItem(buffer.getStringProperty("encoding"));
        panel.addComponent(jEdit.getProperty("buffer-options.encoding"), (Component)this.encoding);
        this.gzipped = new JCheckBox(jEdit.getProperty("buffer-options.gzipped"));
        this.gzipped.setSelected(buffer.getBooleanProperty("gzipped"));
        panel.addComponent(this.gzipped);
        panel.addSeparator("buffer-options.editing");
        this.modes = jEdit.getModes();
        MiscUtilities.quicksort((Object[])this.modes, (MiscUtilities.Compare)new MiscUtilities.StringICaseCompare());
        this.mode = new JComboBox<Mode>(this.modes);
        this.mode.setSelectedItem(buffer.getMode());
        this.mode.addActionListener(actionListener);
        panel.addComponent(jEdit.getProperty("buffer-options.mode"), (Component)this.mode);
        String[] foldModes = FoldHandler.getFoldModes();
        this.folding = new JComboBox<String>(foldModes);
        this.folding.setSelectedItem(buffer.getStringProperty("folding"));
        panel.addComponent(jEdit.getProperty("options.editing.folding"), (Component)this.folding);
        String[] wrapModes = new String[]{"none", "soft", "hard"};
        this.wrap = new JComboBox<String>(wrapModes);
        this.wrap.setSelectedItem(buffer.getStringProperty("wrap"));
        panel.addComponent(jEdit.getProperty("options.editing.wrap"), (Component)this.wrap);
        this.wrap.addActionListener(new ActionHandler());
        String[] lineLengths = new String[]{"0", "72", "76", "80"};
        this.maxLineLen = new JComboBox<String>(lineLengths);
        this.maxLineLen.setEditable(true);
        this.maxLineLen.setSelectedItem(buffer.getStringProperty("maxLineLen"));
        this.maxLineLen.addActionListener(new ActionHandler());
        panel.addComponent(jEdit.getProperty("options.editing.maxLineLen"), (Component)this.maxLineLen);
        String[] tabSizes = new String[]{"2", "4", "8"};
        this.tabSize = new JComboBox<String>(tabSizes);
        this.tabSize.setEditable(true);
        this.tabSize.setSelectedItem(buffer.getStringProperty("tabSize"));
        panel.addComponent(jEdit.getProperty("options.editing.tabSize"), (Component)this.tabSize);
        this.indentSize = new JComboBox<String>(tabSizes);
        this.indentSize.setEditable(true);
        this.indentSize.setSelectedItem(buffer.getStringProperty("indentSize"));
        panel.addComponent(jEdit.getProperty("options.editing.indentSize"), (Component)this.indentSize);
        this.noTabs = new JCheckBox(jEdit.getProperty("options.editing.noTabs"));
        this.noTabs.setSelected(buffer.getBooleanProperty("noTabs"));
        panel.addComponent(this.noTabs);
        content.add("North", panel);
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 0));
        buttons.setBorder(new EmptyBorder(12, 0, 0, 0));
        buttons.add(Box.createGlue());
        this.ok = new JButton(jEdit.getProperty("common.ok"));
        this.ok.addActionListener(actionListener);
        this.getRootPane().setDefaultButton(this.ok);
        buttons.add(this.ok);
        buttons.add(Box.createHorizontalStrut(6));
        this.cancel = new JButton(jEdit.getProperty("common.cancel"));
        this.cancel.addActionListener(actionListener);
        buttons.add(this.cancel);
        buttons.add(Box.createGlue());
        content.add("South", buttons);
        this.pack();
        this.setLocationRelativeTo(view);
        this.setVisible(true);
    }

    /*
     * WARNING - void declaration
     */
    public void ok() {
        boolean oldGzipped;
        boolean gzippedValue;
        void var2_2;
        String lineSep;
        int index = this.lineSeparator.getSelectedIndex();
        if (index == 0) {
            lineSep = "\n";
        } else if (index == 1) {
            lineSep = "\r\n";
        } else if (index == 2) {
            lineSep = "\r";
        } else {
            throw new InternalError();
        }
        String oldLineSep = this.buffer.getStringProperty("lineSeparator");
        if (oldLineSep == null) {
            oldLineSep = System.getProperty("line.separator");
        }
        if (!oldLineSep.equals(var2_2)) {
            this.buffer.setStringProperty("lineSeparator", (String)var2_2);
            this.buffer.setDirty(true);
        }
        String encoding = (String)this.encoding.getSelectedItem();
        String oldEncoding = this.buffer.getStringProperty("encoding");
        if (!oldEncoding.equals(encoding)) {
            this.buffer.setStringProperty("encoding", encoding);
            this.buffer.setDirty(true);
        }
        if ((gzippedValue = this.gzipped.isSelected()) != (oldGzipped = this.buffer.getBooleanProperty("gzipped"))) {
            this.buffer.setBooleanProperty("gzipped", gzippedValue);
            this.buffer.setDirty(true);
        }
        this.buffer.setStringProperty("folding", (String)this.folding.getSelectedItem());
        this.buffer.setStringProperty("wrap", (String)this.wrap.getSelectedItem());
        try {
            this.buffer.setProperty("maxLineLen", new Integer(this.maxLineLen.getSelectedItem().toString()));
        }
        catch (NumberFormatException nf) {
            // empty catch block
        }
        try {
            this.buffer.setProperty("tabSize", new Integer(this.tabSize.getSelectedItem().toString()));
        }
        catch (NumberFormatException nf) {
            // empty catch block
        }
        try {
            this.buffer.setProperty("indentSize", new Integer(this.indentSize.getSelectedItem().toString()));
        }
        catch (NumberFormatException nf) {
            // empty catch block
        }
        this.buffer.setBooleanProperty("noTabs", this.noTabs.isSelected());
        index = this.mode.getSelectedIndex();
        this.buffer.setMode(this.modes[index]);
        this.dispose();
    }

    public void cancel() {
        this.dispose();
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source == BufferOptions.this.ok) {
                BufferOptions.this.ok();
            } else if (source == BufferOptions.this.cancel) {
                BufferOptions.this.cancel();
            } else if (source == BufferOptions.this.mode) {
                Mode _mode = (Mode)BufferOptions.this.mode.getSelectedItem();
                BufferOptions.this.folding.setSelectedItem(_mode.getProperty("folding"));
                BufferOptions.this.wrap.setSelectedItem(_mode.getProperty("wrap"));
                BufferOptions.this.maxLineLen.setSelectedItem(_mode.getProperty("maxLineLen"));
                BufferOptions.this.tabSize.setSelectedItem(_mode.getProperty("tabSize"));
                BufferOptions.this.indentSize.setSelectedItem(_mode.getProperty("indentSize"));
                BufferOptions.this.noTabs.setSelected(_mode.getBooleanProperty("noTabs"));
            } else if (source == BufferOptions.this.wrap) {
                if (!BufferOptions.this.wrap.getSelectedItem().equals("none") && BufferOptions.this.maxLineLen.getSelectedItem().equals("0")) {
                    BufferOptions.this.maxLineLen.setSelectedItem("80");
                }
            } else if (source == BufferOptions.this.maxLineLen && !BufferOptions.this.wrap.getSelectedItem().equals("none") && BufferOptions.this.maxLineLen.getSelectedItem().equals("0")) {
                BufferOptions.this.wrap.setSelectedItem("none");
            }
        }
    }
}

