/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.browser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class VFSDirectoryEntryTableModel
extends AbstractTableModel {
    Entry[] files;
    private List extAttrs = new ArrayList();
    static /* synthetic */ Class class$org$gjt$sp$jedit$browser$VFSDirectoryEntryTableModel$Entry;

    public void setRoot(VFS vfs, ArrayList list) {
        this.extAttrs.clear();
        this.addExtendedAttributes(vfs);
        this.files = new Entry[list.size()];
        for (int i = 0; i < this.files.length; ++i) {
            this.files[i] = new Entry((VFS.DirectoryEntry)list.get(i), 0);
        }
        this.fireTableStructureChanged();
    }

    public int expand(VFS vfs, Entry entry, ArrayList list) {
        int startIndex = -1;
        for (int i = 0; i < this.files.length; ++i) {
            if (this.files[i] != entry) continue;
            startIndex = i;
        }
        this.collapse(vfs, startIndex);
        this.addExtendedAttributes(vfs);
        entry.expanded = true;
        if (list != null) {
            Entry[] newFiles = new Entry[this.files.length + list.size()];
            System.arraycopy(this.files, 0, newFiles, 0, startIndex + 1);
            for (int i = 0; i < list.size(); ++i) {
                newFiles[startIndex + i + 1] = new Entry((VFS.DirectoryEntry)list.get(i), entry.level + 1);
            }
            System.arraycopy(this.files, startIndex + 1, newFiles, startIndex + list.size() + 1, this.files.length - startIndex - 1);
            this.files = newFiles;
        }
        this.fireTableStructureChanged();
        return startIndex;
    }

    public void collapse(VFS vfs, int index) {
        int lastIndex;
        Entry entry = this.files[index];
        if (!entry.expanded) {
            return;
        }
        entry.expanded = false;
        for (lastIndex = index + 1; lastIndex < this.files.length; ++lastIndex) {
            Entry e = this.files[lastIndex];
            if (e.level <= entry.level) break;
            if (!e.expanded) continue;
            this.removeExtendedAttributes(VFSManager.getVFSForPath(e.dirEntry.path));
        }
        this.removeExtendedAttributes(vfs);
        Entry[] newFiles = new Entry[this.files.length - lastIndex + index + 1];
        System.arraycopy(this.files, 0, newFiles, 0, index + 1);
        System.arraycopy(this.files, lastIndex, newFiles, index + 1, this.files.length - lastIndex);
        this.files = newFiles;
        this.fireTableStructureChanged();
    }

    public int getColumnCount() {
        return 1 + this.extAttrs.size();
    }

    public int getRowCount() {
        if (this.files == null) {
            return 0;
        }
        return this.files.length;
    }

    public String getColumnName(int col) {
        if (col == 0) {
            return jEdit.getProperty("vfs.browser.name");
        }
        return jEdit.getProperty("vfs.browser." + this.getExtendedAttribute(col - 1));
    }

    public Class getColumnClass(int col) {
        return class$org$gjt$sp$jedit$browser$VFSDirectoryEntryTableModel$Entry == null ? (class$org$gjt$sp$jedit$browser$VFSDirectoryEntryTableModel$Entry = VFSDirectoryEntryTableModel.class$("org.gjt.sp.jedit.browser.VFSDirectoryEntryTableModel$Entry")) : class$org$gjt$sp$jedit$browser$VFSDirectoryEntryTableModel$Entry;
    }

    public Object getValueAt(int row, int col) {
        if (this.files == null) {
            return null;
        }
        return this.files[row];
    }

    public String getExtendedAttribute(int index) {
        return ((ExtendedAttribute)this.extAttrs.get((int)index)).name;
    }

    private void addExtendedAttributes(VFS vfs) {
        String[] attrs = vfs.getExtendedAttributes();
        block0: for (int i = 0; i < attrs.length; ++i) {
            Iterator iter = this.extAttrs.iterator();
            while (iter.hasNext()) {
                ExtendedAttribute attr = (ExtendedAttribute)iter.next();
                if (!attrs[i].equals(attr.name)) continue;
                ++attr.ref;
                continue block0;
            }
            this.extAttrs.add(new ExtendedAttribute(attrs[i]));
        }
    }

    private void removeExtendedAttributes(VFS vfs) {
        String[] attrs = vfs.getExtendedAttributes();
        block0: for (int i = 0; i < attrs.length; ++i) {
            Iterator iter = this.extAttrs.iterator();
            while (iter.hasNext()) {
                ExtendedAttribute attr = (ExtendedAttribute)iter.next();
                if (!attrs[i].equals(attr.name)) continue;
                if (--attr.ref != 0) continue block0;
                iter.remove();
                continue block0;
            }
            Log.log(7, this, "We forgot about " + attrs[i]);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class ExtendedAttribute {
        int ref;
        String name;

        ExtendedAttribute(String name) {
            this.name = name;
            this.ref = 1;
        }
    }

    static class Entry {
        VFS.DirectoryEntry dirEntry;
        boolean expanded;
        int level;

        Entry(VFS.DirectoryEntry dirEntry, int level) {
            this.dirEntry = dirEntry;
            this.level = level;
        }
    }
}

