/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import com.microstar.xml.HandlerBase;
import java.io.StringReader;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.util.Log;

class ServiceListHandler
extends HandlerBase {
    private PluginJAR plugin;
    private URL uri;
    private String serviceName;
    private String serviceClass;
    private String code;
    private Stack stateStack;
    private List cachedServices;

    ServiceListHandler(PluginJAR plugin, URL uri) {
        this.plugin = plugin;
        this.uri = uri;
        this.stateStack = new Stack();
        this.cachedServices = new LinkedList();
    }

    public Object resolveEntity(String publicId, String systemId) {
        if ("services.dtd".equals(systemId)) {
            return new StringReader("<!-- -->");
        }
        return null;
    }

    public void attribute(String aname, String value, boolean isSpecified) {
        if (aname.equals("NAME")) {
            this.serviceName = value;
        } else if (aname.equals("CLASS")) {
            this.serviceClass = value;
        }
    }

    public void doctypeDecl(String name, String publicId, String systemId) throws Exception {
        if ("SERVICES".equals(name)) {
            return;
        }
        Log.log(9, this, this.uri + ": DOCTYPE must be SERVICES");
    }

    public void charData(char[] c, int off, int len) {
        String tag = this.peekElement();
        String text = new String(c, off, len);
        if (tag == "SERVICE") {
            this.code = text;
        }
    }

    public void startElement(String tag) {
        tag = this.pushElement(tag);
    }

    public void endElement(String name) {
        if (name == null) {
            return;
        }
        String tag = this.peekElement();
        if (name.equals(tag)) {
            if (tag == "SERVICE") {
                ServiceManager.Descriptor d = new ServiceManager.Descriptor(this.serviceClass, this.serviceName, this.code, this.plugin);
                ServiceManager.registerService(d);
                this.cachedServices.add(d);
            }
        } else {
            throw new InternalError();
        }
        this.popElement();
    }

    public void startDocument() {
        try {
            this.pushElement(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ServiceManager.Descriptor[] getCachedServices() {
        return this.cachedServices.toArray(new ServiceManager.Descriptor[this.cachedServices.size()]);
    }

    private String pushElement(String name) {
        name = name == null ? null : name.intern();
        this.stateStack.push(name);
        return name;
    }

    private String peekElement() {
        return (String)this.stateStack.peek();
    }

    private String popElement() {
        return (String)this.stateStack.pop();
    }
}

