/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import com.microstar.xml.HandlerBase;
import com.microstar.xml.XmlException;
import com.microstar.xml.XmlParser;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.gui.HistoryModel;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.util.Log;

public class Registers {
    private static Register[] registers = new Register[256];
    private static long registersModTime;
    private static boolean loaded;
    private static boolean loading;
    private static boolean modified;
    static /* synthetic */ Class class$org$gjt$sp$jedit$Registers;
    static /* synthetic */ Class class$org$gjt$sp$jedit$jEdit;

    public static void copy(JEditTextArea textArea, char register) {
        String selection = textArea.getSelectedText();
        if (selection == null) {
            return;
        }
        Registers.setRegister(register, selection);
        HistoryModel.getModel("clipboard").addItem(selection);
    }

    public static void cut(JEditTextArea textArea, char register) {
        if (textArea.isEditable()) {
            String selection = textArea.getSelectedText();
            if (selection == null) {
                return;
            }
            Registers.setRegister(register, selection);
            HistoryModel.getModel("clipboard").addItem(selection);
            textArea.setSelectedText("");
        } else {
            textArea.getToolkit().beep();
        }
    }

    public static void append(JEditTextArea textArea, char register) {
        Registers.append(textArea, register, "\n", false);
    }

    public static void append(JEditTextArea textArea, char register, String separator) {
        Registers.append(textArea, register, separator, false);
    }

    public static void append(JEditTextArea textArea, char register, String separator, boolean cut) {
        String registerContents;
        if (cut && !textArea.isEditable()) {
            textArea.getToolkit().beep();
            return;
        }
        String selection = textArea.getSelectedText();
        if (selection == null) {
            return;
        }
        Register reg = Registers.getRegister(register);
        if (reg != null && (registerContents = ((Object)reg).toString()) != null) {
            selection = registerContents.endsWith(separator) ? registerContents + selection : registerContents + separator + selection;
        }
        Registers.setRegister(register, selection);
        HistoryModel.getModel("clipboard").addItem(selection);
        if (cut) {
            textArea.setSelectedText("");
        }
    }

    public static void paste(JEditTextArea textArea, char register) {
        Registers.paste(textArea, register, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void paste(JEditTextArea textArea, char register, boolean vertical) {
        if (!textArea.isEditable()) {
            textArea.getToolkit().beep();
            return;
        }
        reg = Registers.getRegister(register);
        if (reg == null) {
            textArea.getToolkit().beep();
            return;
        }
        selection = reg.toString();
        if (selection == null) {
            textArea.getToolkit().beep();
            return;
        }
        if (vertical && textArea.getSelectionCount() == 0) {
            buffer = textArea.getBuffer();
            try {
                buffer.beginCompoundEdit();
                caret = textArea.getCaretPosition();
                caretLine = textArea.getCaretLine();
                rect = new Selection.Rect(caretLine, caret, caretLine, caret);
                textArea.setSelectedText(rect, selection);
                caretLine = textArea.getCaretLine();
                if (caretLine == textArea.getLineCount() - 1) ** GOTO lbl34
                startColumn = rect.getStartColumn(buffer);
                offset = buffer.getOffsetOfVirtualColumn(caretLine + 1, startColumn, null);
                if (offset == -1) {
                    buffer.insertAtColumn(caretLine + 1, startColumn, "");
                    textArea.setCaretPosition(buffer.getLineEndOffset(caretLine + 1) - 1);
                }
                textArea.setCaretPosition(buffer.getLineStartOffset(caretLine + 1) + offset);
            }
            finally {
                buffer.endCompoundEdit();
            }
        } else {
            textArea.setSelectedText(selection);
        }
lbl34:
        // 4 sources

        HistoryModel.getModel("clipboard").addItem(selection);
    }

    public static Register getRegister(char name) {
        if (name != '$' && name != '%' && !loaded) {
            Registers.loadRegisters();
        }
        if (registers == null || name >= registers.length) {
            return null;
        }
        return registers[name];
    }

    public static void setRegister(char name, Register newRegister) {
        if (name != '%' && name != '$') {
            if (!loaded) {
                Registers.loadRegisters();
            }
            if (!loading) {
                modified = true;
            }
        }
        if (name >= registers.length) {
            Register[] newRegisters = new Register[Math.min(65536, name * 2)];
            System.arraycopy(registers, 0, newRegisters, 0, registers.length);
            registers = newRegisters;
        }
        Registers.registers[name] = newRegister;
    }

    public static void setRegister(char name, String value) {
        Register register = Registers.getRegister(name);
        if (register != null) {
            register.setValue(value);
        } else {
            Registers.setRegister(name, new StringRegister(value));
        }
    }

    public static void clearRegister(char name) {
        if (name >= registers.length) {
            return;
        }
        Register register = registers[name];
        if (name == '$' || name == '%') {
            register.setValue("");
        } else {
            Registers.registers[name] = null;
        }
    }

    public static Register[] getRegisters() {
        if (!loaded) {
            Registers.loadRegisters();
        }
        return registers;
    }

    public static String getRegisterStatusPrompt(String action) {
        return jEdit.getProperty("view.status." + action, new String[]{Registers.getRegisterNameString()});
    }

    public static String getRegisterNameString() {
        if (!loaded) {
            Registers.loadRegisters();
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < registers.length; ++i) {
            if (registers[i] == null) continue;
            if (buf.length() != 0) {
                buf.append(' ');
            }
            buf.append((char)i);
        }
        if (buf.length() == 0) {
            return jEdit.getProperty("view.status.no-registers");
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void saveRegisters() {
        boolean ok;
        File file2;
        File file1;
        block17: {
            if (!loaded || !modified) {
                return;
            }
            Log.log(3, class$org$gjt$sp$jedit$Registers == null ? (class$org$gjt$sp$jedit$Registers = Registers.class$("org.gjt.sp.jedit.Registers")) : class$org$gjt$sp$jedit$Registers, "Saving registers.xml");
            file1 = new File(MiscUtilities.constructPath(jEdit.getSettingsDirectory(), "#registers.xml#save#"));
            file2 = new File(MiscUtilities.constructPath(jEdit.getSettingsDirectory(), "registers.xml"));
            if (file2.exists() && file2.lastModified() != registersModTime) {
                Log.log(7, class$org$gjt$sp$jedit$Registers == null ? (class$org$gjt$sp$jedit$Registers = Registers.class$("org.gjt.sp.jedit.Registers")) : class$org$gjt$sp$jedit$Registers, file2 + " changed" + " on disk; will not save registers");
                return;
            }
            jEdit.backupSettingsFile(file2);
            String lineSep = System.getProperty("line.separator");
            BufferedWriter out = null;
            ok = false;
            out = new BufferedWriter(new FileWriter(file1));
            out.write("<?xml version=\"1.0\"?>");
            out.write(lineSep);
            out.write("<!DOCTYPE REGISTERS SYSTEM \"registers.dtd\">");
            out.write(lineSep);
            out.write("<REGISTERS>");
            out.write(lineSep);
            Register[] registers = Registers.getRegisters();
            for (int i = 0; i < registers.length; ++i) {
                Register register = registers[i];
                if (register == null || i == 36 || i == 37) continue;
                out.write("<REGISTER NAME=\"");
                if (i == 34) {
                    out.write("&quot;");
                } else {
                    out.write((char)i);
                }
                out.write("\">");
                out.write(MiscUtilities.charsToEntities(((Object)register).toString()));
                out.write("</REGISTER>");
                out.write(lineSep);
            }
            out.write("</REGISTERS>");
            out.write(lineSep);
            ok = true;
            Object var9_9 = null;
            try {
                if (out != null) {
                    out.close();
                }
                break block17;
            }
            catch (IOException e2) {}
            break block17;
            {
                catch (Exception e) {
                    Log.log(9, class$org$gjt$sp$jedit$Registers == null ? (class$org$gjt$sp$jedit$Registers = Registers.class$("org.gjt.sp.jedit.Registers")) : class$org$gjt$sp$jedit$Registers, e);
                    Object var9_10 = null;
                    try {
                        if (out != null) {
                            out.close();
                        }
                        break block17;
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (ok) {
            file2.delete();
            file1.renameTo(file2);
        }
        registersModTime = file2.lastModified();
        modified = false;
    }

    private Registers() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void loadRegisters() {
        block19: {
            String settingsDirectory = jEdit.getSettingsDirectory();
            if (settingsDirectory == null) {
                return;
            }
            File registerFile = new File(MiscUtilities.constructPath(jEdit.getSettingsDirectory(), "registers.xml"));
            if (!registerFile.exists()) {
                return;
            }
            registersModTime = registerFile.lastModified();
            loaded = true;
            Log.log(3, class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = Registers.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit, "Loading registers.xml");
            RegistersHandler handler = new RegistersHandler();
            XmlParser parser = new XmlParser();
            parser.setHandler(handler);
            BufferedReader in = null;
            loading = true;
            in = new BufferedReader(new FileReader(registerFile));
            parser.parse(null, null, in);
            Object var9_5 = null;
            loading = false;
            try {
                if (in != null) {
                    ((Reader)in).close();
                }
                break block19;
            }
            catch (IOException io) {
                Log.log(9, class$org$gjt$sp$jedit$Registers == null ? (class$org$gjt$sp$jedit$Registers = Registers.class$("org.gjt.sp.jedit.Registers")) : class$org$gjt$sp$jedit$Registers, io);
            }
            break block19;
            {
                catch (XmlException xe) {
                    int line = xe.getLine();
                    String message = xe.getMessage();
                    Log.log(9, class$org$gjt$sp$jedit$Registers == null ? (class$org$gjt$sp$jedit$Registers = Registers.class$("org.gjt.sp.jedit.Registers")) : class$org$gjt$sp$jedit$Registers, registerFile + ":" + line + ": " + message);
                    Object var9_6 = null;
                    loading = false;
                    try {
                        if (in != null) {
                            ((Reader)in).close();
                        }
                        break block19;
                    }
                    catch (IOException io) {
                        Log.log(9, class$org$gjt$sp$jedit$Registers == null ? (class$org$gjt$sp$jedit$Registers = Registers.class$("org.gjt.sp.jedit.Registers")) : class$org$gjt$sp$jedit$Registers, io);
                    }
                    break block19;
                }
                catch (FileNotFoundException fnf) {
                    Object var9_7 = null;
                    loading = false;
                    try {
                        if (in != null) {
                            ((Reader)in).close();
                        }
                        break block19;
                    }
                    catch (IOException io) {
                        Log.log(9, class$org$gjt$sp$jedit$Registers == null ? (class$org$gjt$sp$jedit$Registers = Registers.class$("org.gjt.sp.jedit.Registers")) : class$org$gjt$sp$jedit$Registers, io);
                    }
                    break block19;
                }
                catch (Exception e) {
                    Log.log(9, class$org$gjt$sp$jedit$Registers == null ? (class$org$gjt$sp$jedit$Registers = Registers.class$("org.gjt.sp.jedit.Registers")) : class$org$gjt$sp$jedit$Registers, e);
                    Object var9_8 = null;
                    loading = false;
                    try {
                        if (in != null) {
                            ((Reader)in).close();
                        }
                        break block19;
                    }
                    catch (IOException io) {
                        Log.log(9, class$org$gjt$sp$jedit$Registers == null ? (class$org$gjt$sp$jedit$Registers = Registers.class$("org.gjt.sp.jedit.Registers")) : class$org$gjt$sp$jedit$Registers, io);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                loading = false;
                try {
                    if (in != null) {
                        ((Reader)in).close();
                    }
                }
                catch (IOException io) {
                    Log.log(9, class$org$gjt$sp$jedit$Registers == null ? (class$org$gjt$sp$jedit$Registers = Registers.class$("org.gjt.sp.jedit.Registers")) : class$org$gjt$sp$jedit$Registers, io);
                }
                throw throwable;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Registers.registers[36] = new ClipboardRegister(Toolkit.getDefaultToolkit().getSystemClipboard());
    }

    static class RegistersHandler
    extends HandlerBase {
        private String registerName;
        private String charData;

        RegistersHandler() {
        }

        public Object resolveEntity(String publicId, String systemId) {
            if ("registers.dtd".equals(systemId)) {
                return new StringReader("<!-- -->");
            }
            return null;
        }

        public void attribute(String aname, String value, boolean isSpecified) {
            if (aname.equals("NAME")) {
                this.registerName = value;
            }
        }

        public void doctypeDecl(String name, String publicId, String systemId) throws Exception {
            if ("REGISTERS".equals(name)) {
                return;
            }
            Log.log(9, this, "registers.xml: DOCTYPE must be REGISTERS");
        }

        public void endElement(String name) {
            if (name.equals("REGISTER")) {
                if (this.registerName == null || this.registerName.length() != 1) {
                    Log.log(9, this, "Malformed NAME: " + this.registerName);
                } else {
                    Registers.setRegister(this.registerName.charAt(0), this.charData);
                }
            }
        }

        public void charData(char[] ch, int start, int length) {
            this.charData = new String(ch, start, length);
        }
    }

    public static class StringRegister
    implements Register {
        private String value;

        public StringRegister(String value) {
            this.value = value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public void dispose() {
        }
    }

    public static class ClipboardRegister
    implements Register {
        Clipboard clipboard;

        public ClipboardRegister(Clipboard clipboard) {
            this.clipboard = clipboard;
        }

        public void setValue(String value) {
            StringSelection selection = new StringSelection(value);
            this.clipboard.setContents(selection, null);
        }

        public String toString() {
            try {
                String line;
                String selection = (String)this.clipboard.getContents(this).getTransferData(DataFlavor.stringFlavor);
                boolean trailingEOL = selection.endsWith("\n") || selection.endsWith(System.getProperty("line.separator"));
                BufferedReader in = new BufferedReader(new StringReader(selection));
                StringBuffer buf = new StringBuffer();
                while ((line = in.readLine()) != null) {
                    if (line.endsWith("\u0000")) {
                        line = line.substring(0, line.length() - 1);
                    }
                    buf.append(line);
                    buf.append('\n');
                }
                if (!trailingEOL && buf.length() != 0) {
                    buf.setLength(buf.length() - 1);
                }
                return buf.toString();
            }
            catch (Exception e) {
                Log.log(5, this, e);
                return null;
            }
        }
    }

    public static interface Register {
        public String toString();

        public void setValue(String var1);
    }
}

