/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.Capabilities;
import bsh.InterpreterError;
import bsh.Primitive;
import bsh.Reflect;
import bsh.This;
import bsh.UtilEvalError;
import bsh.UtilTargetError;

class Types {
    static final int CAST = 0;
    static final int ASSIGNMENT = 1;
    static Primitive VALID_CAST = new Primitive(1);
    static Primitive INVALID_CAST = new Primitive(-1);
    static /* synthetic */ Class class$bsh$Primitive;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$bsh$This;

    Types() {
    }

    public static Class[] getTypes(Object[] args) {
        if (args == null) {
            return new Class[0];
        }
        Class[] types = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            types[i] = args[i] == null ? null : (args[i] instanceof Primitive ? ((Primitive)args[i]).getType() : args[i].getClass());
        }
        return types;
    }

    static boolean argsAssignable(Class[] parameters, Object[] args) {
        Class[] argTypes = Types.getTypes(args);
        return Types.isSignatureAssignable(argTypes, parameters);
    }

    static boolean isSignatureAssignable(Class[] from, Class[] to) {
        if (from.length != to.length) {
            return false;
        }
        for (int i = 0; i < from.length; ++i) {
            if (Types.isBshAssignable(to[i], from[i])) continue;
            return false;
        }
        return true;
    }

    static boolean isJavaAssignable(Class lhs, Class rhs) {
        if (rhs == null) {
            return !lhs.isPrimitive();
        }
        if (lhs.isPrimitive() && rhs.isPrimitive()) {
            if (lhs == rhs) {
                return true;
            }
            if (rhs == Byte.TYPE && (lhs == Short.TYPE || lhs == Integer.TYPE || lhs == Long.TYPE || lhs == Float.TYPE || lhs == Double.TYPE)) {
                return true;
            }
            if (rhs == Short.TYPE && (lhs == Integer.TYPE || lhs == Long.TYPE || lhs == Float.TYPE || lhs == Double.TYPE)) {
                return true;
            }
            if (rhs == Character.TYPE && (lhs == Integer.TYPE || lhs == Long.TYPE || lhs == Float.TYPE || lhs == Double.TYPE)) {
                return true;
            }
            if (rhs == Integer.TYPE && (lhs == Long.TYPE || lhs == Float.TYPE || lhs == Double.TYPE)) {
                return true;
            }
            if (rhs == Long.TYPE && (lhs == Float.TYPE || lhs == Double.TYPE)) {
                return true;
            }
            if (rhs == Float.TYPE && lhs == Double.TYPE) {
                return true;
            }
        } else if (lhs.isAssignableFrom(rhs)) {
            return true;
        }
        return false;
    }

    public static Object getAssignableForm(Object rhs, Class lhsType) throws UtilEvalError {
        return Types.castObject(rhs, lhsType, 1);
    }

    public static Object castObject(Object fromValue, Class toType, int operation) throws UtilEvalError {
        if (fromValue == null) {
            throw new InterpreterError("null fromValue");
        }
        Class fromType = fromValue instanceof Primitive ? ((Primitive)fromValue).getType() : fromValue.getClass();
        return Types.castObject(toType, fromType, fromValue, operation, false);
    }

    static boolean isBshAssignable(Class toType, Class fromType) {
        try {
            return Types.castObject(toType, fromType, null, 1, true) == VALID_CAST;
        }
        catch (UtilEvalError e) {
            throw new InterpreterError("err in cast check: " + e);
        }
    }

    static Object castObject(Class toType, Class fromType, Object fromValue, int operation, boolean checkOnly) throws UtilEvalError {
        if (checkOnly && fromValue != null) {
            throw new InterpreterError("bad cast params 1");
        }
        if (!checkOnly && fromValue == null) {
            throw new InterpreterError("bad cast params 2");
        }
        if (fromType == (class$bsh$Primitive == null ? (class$bsh$Primitive = Types.class$("bsh.Primitive")) : class$bsh$Primitive)) {
            throw new InterpreterError("bad from Type, need to unwrap");
        }
        if (fromValue == Primitive.NULL && fromType != null) {
            throw new InterpreterError("inconsistent args 1");
        }
        if (fromValue == Primitive.VOID && fromType != Void.TYPE) {
            throw new InterpreterError("inconsistent args 2");
        }
        if (toType == Void.TYPE) {
            throw new InterpreterError("loose toType should be null");
        }
        if (toType == null || toType == fromType) {
            return checkOnly ? VALID_CAST : fromValue;
        }
        if (toType.isPrimitive()) {
            if (fromType == Void.TYPE || fromType == null || fromType.isPrimitive()) {
                return Primitive.castPrimitive(toType, fromType, (Primitive)fromValue, checkOnly, operation);
            }
            if (Primitive.isWrapperType(fromType)) {
                Class unboxedFromType = Primitive.unboxType(fromType);
                Primitive primFromValue = checkOnly ? null : (Primitive)Primitive.wrap(fromValue, unboxedFromType);
                return Primitive.castPrimitive(toType, unboxedFromType, primFromValue, checkOnly, operation);
            }
            if (checkOnly) {
                return INVALID_CAST;
            }
            throw Types.castError(toType, fromType, operation);
        }
        if (fromType == Void.TYPE || fromType == null || fromType.isPrimitive()) {
            if (Primitive.isWrapperType(toType) && fromType != Void.TYPE && fromType != null) {
                return checkOnly ? VALID_CAST : Primitive.castWrapper(Primitive.unboxType(toType), ((Primitive)fromValue).getValue());
            }
            if (toType == (class$java$lang$Object == null ? (class$java$lang$Object = Types.class$("java.lang.Object")) : class$java$lang$Object) && fromType != Void.TYPE && fromType != null) {
                return checkOnly ? VALID_CAST : ((Primitive)fromValue).getValue();
            }
            return Primitive.castPrimitive(toType, fromType, (Primitive)fromValue, checkOnly, operation);
        }
        if (toType.isAssignableFrom(fromType)) {
            return checkOnly ? VALID_CAST : fromValue;
        }
        if (toType.isInterface() && (class$bsh$This == null ? (class$bsh$This = Types.class$("bsh.This")) : class$bsh$This).isAssignableFrom(fromType) && Capabilities.canGenerateInterfaces()) {
            return checkOnly ? VALID_CAST : ((This)fromValue).getInterface(toType);
        }
        if (Primitive.isWrapperType(toType) && Primitive.isWrapperType(fromType)) {
            return checkOnly ? VALID_CAST : Primitive.castWrapper(toType, fromValue);
        }
        if (checkOnly) {
            return INVALID_CAST;
        }
        throw Types.castError(toType, fromType, operation);
    }

    static UtilEvalError castError(Class lhsType, Class rhsType, int operation) {
        return Types.castError(Reflect.normalizeClassName(lhsType), Reflect.normalizeClassName(rhsType), operation);
    }

    static UtilEvalError castError(String lhs, String rhs, int operation) {
        if (operation == 1) {
            return new UtilEvalError("Can't assign " + rhs + " to " + lhs);
        }
        ClassCastException cce = new ClassCastException("Cannot cast " + rhs + " to " + lhs);
        return new UtilTargetError(cce);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

