/*
 * Decompiled with CFR 0.152.
 */
package errorlist;

import errorlist.ErrorHighlight;
import errorlist.ErrorOverview;
import errorlist.ErrorSource;
import errorlist.ErrorSourceUpdate;
import java.awt.Color;
import java.awt.Component;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EBPlugin;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.TextAreaExtension;

public class ErrorListPlugin
extends EBPlugin {
    private static boolean showOnError;
    private static boolean showErrorOverview;
    private static Color warningColor;
    private static Color errorColor;

    public void start() {
        for (View view = jEdit.getFirstView(); view != null; view = view.getNext()) {
            EditPane[] panes = view.getEditPanes();
            for (int i = 0; i < panes.length; ++i) {
                this.initEditPane(panes[i]);
                this.addErrorOverviewIfErrors(panes[i]);
            }
        }
        this.propertiesChanged();
    }

    public void stop() {
        for (View view = jEdit.getFirstView(); view != null; view = view.getNext()) {
            EditPane[] panes = view.getEditPanes();
            for (int i = 0; i < panes.length; ++i) {
                this.uninitTextArea(panes[i].getTextArea());
                ErrorListPlugin.removeErrorOverview(panes[i]);
            }
        }
    }

    public void handleMessage(EBMessage message) {
        if (message instanceof ErrorSourceUpdate) {
            this.handleErrorSourceMessage((ErrorSourceUpdate)message);
        } else if (message instanceof EditPaneUpdate) {
            this.handleEditPaneMessage((EditPaneUpdate)message);
        } else if (message instanceof PropertiesChanged) {
            this.propertiesChanged();
        }
    }

    public void showErrorOverviewIfNecessary() {
        for (View view = jEdit.getFirstView(); view != null; view = view.getNext()) {
            EditPane[] panes = view.getEditPanes();
            for (int i = 0; i < panes.length; ++i) {
                this.addErrorOverviewIfErrors(panes[i]);
            }
        }
    }

    public static void addErrorOverview(EditPane editPane) {
        ErrorOverview overview = ErrorListPlugin.getErrorOverview(editPane);
        if (overview != null) {
            overview.repaint();
        } else {
            overview = new ErrorOverview(editPane);
            JEditTextArea textArea = editPane.getTextArea();
            textArea.addLeftOfScrollBar((Component)overview);
            textArea.putClientProperty((Object)ErrorOverview.class, (Object)overview);
            textArea.revalidate();
        }
    }

    public static void removeErrorOverview(EditPane editPane) {
        ErrorOverview overview = ErrorListPlugin.getErrorOverview(editPane);
        if (overview != null) {
            JEditTextArea textArea = editPane.getTextArea();
            textArea.removeLeftOfScrollBar((Component)overview);
            textArea.revalidate();
            textArea.putClientProperty((Object)ErrorOverview.class, null);
        }
    }

    public static ErrorOverview getErrorOverview(EditPane editPane) {
        return (ErrorOverview)editPane.getTextArea().getClientProperty((Object)ErrorOverview.class);
    }

    static Color getErrorColor(int type) {
        return type == 1 ? warningColor : errorColor;
    }

    private void propertiesChanged() {
        showOnError = jEdit.getBooleanProperty((String)"error-list.showOnError");
        showErrorOverview = jEdit.getBooleanProperty((String)"error-list.showErrorOverview");
        warningColor = GUIUtilities.parseColor((String)jEdit.getProperty((String)"error-list.warningColor"));
        errorColor = GUIUtilities.parseColor((String)jEdit.getProperty((String)"error-list.errorColor"));
        for (View view = jEdit.getFirstView(); view != null; view = view.getNext()) {
            EditPane[] panes = view.getEditPanes();
            for (int i = 0; i < panes.length; ++i) {
                this.addErrorOverviewIfErrors(panes[i]);
            }
        }
    }

    private void initEditPane(EditPane editPane) {
        ErrorHighlight highlight = new ErrorHighlight(editPane);
        JEditTextArea textArea = editPane.getTextArea();
        textArea.getPainter().addExtension((TextAreaExtension)highlight);
        textArea.putClientProperty((Object)"ErrorHighlight", (Object)highlight);
    }

    private void uninitTextArea(JEditTextArea textArea) {
        ErrorHighlight highlight = (ErrorHighlight)((Object)textArea.getPainter().getClientProperty((Object)"ErrorHighlight"));
        if (highlight != null) {
            textArea.getPainter().removeExtension((TextAreaExtension)highlight);
            textArea.putClientProperty((Object)"ErrorHighlight", null);
        }
    }

    private void showErrorList(View view) {
        DockableWindowManager dockableWindowManager = view.getDockableWindowManager();
        dockableWindowManager.addDockableWindow("error-list");
    }

    private void handleErrorSourceMessage(ErrorSourceUpdate message) {
        Object what = message.getWhat();
        if (what == ErrorSourceUpdate.ERROR_ADDED) {
            ErrorSource.Error error = message.getError();
            Buffer buffer = error.getBuffer();
            if (buffer != null) {
                this.invalidateLineInAllViews(buffer, error.getLineNumber());
            }
            if (showOnError && jEdit.getActiveView() != null) {
                this.showErrorList(jEdit.getActiveView());
            }
        } else if (what == ErrorSourceUpdate.ERROR_REMOVED) {
            ErrorSource.Error error = message.getError();
            Buffer buffer = error.getBuffer();
            if (buffer != null) {
                this.invalidateLineInAllViews(buffer, error.getLineNumber());
            }
            if (showOnError && jEdit.getActiveView() != null) {
                this.showErrorList(jEdit.getActiveView());
            }
        } else if (what == ErrorSourceUpdate.ERRORS_CLEARED || what == ErrorSourceUpdate.ERROR_SOURCE_ADDED || what == ErrorSourceUpdate.ERROR_SOURCE_REMOVED) {
            for (View view = jEdit.getFirstView(); view != null; view = view.getNext()) {
                EditPane[] editPanes = view.getEditPanes();
                for (int i = 0; i < editPanes.length; ++i) {
                    EditPane pane = editPanes[i];
                    pane.getTextArea().getPainter().repaint();
                    this.addErrorOverviewIfErrors(pane);
                }
            }
            if (what == ErrorSourceUpdate.ERROR_SOURCE_ADDED && showOnError && jEdit.getActiveView() != null) {
                this.showErrorList(jEdit.getActiveView());
            }
        }
    }

    private void invalidateLineInAllViews(Buffer buffer, int line) {
        for (View view = jEdit.getFirstView(); view != null; view = view.getNext()) {
            EditPane[] editPanes = view.getEditPanes();
            for (int i = 0; i < editPanes.length; ++i) {
                EditPane pane = editPanes[i];
                if (pane.getBuffer() != buffer) continue;
                pane.getTextArea().invalidateLine(line);
                this.addErrorOverviewIfErrors(pane);
            }
        }
    }

    private void handleEditPaneMessage(EditPaneUpdate message) {
        EditPane editPane = message.getEditPane();
        JEditTextArea textArea = editPane.getTextArea();
        Object what = message.getWhat();
        if (what == EditPaneUpdate.CREATED) {
            this.initEditPane(editPane);
            this.addErrorOverviewIfErrors(editPane);
        } else if (what == EditPaneUpdate.DESTROYED) {
            this.uninitTextArea(textArea);
            ErrorListPlugin.removeErrorOverview(editPane);
        } else if (what == EditPaneUpdate.BUFFER_CHANGED) {
            this.addErrorOverviewIfErrors(editPane);
        }
    }

    private void addErrorOverviewIfErrors(EditPane editPane) {
        Buffer buffer = editPane.getBuffer();
        if (showErrorOverview) {
            ErrorSource[] errorSources = ErrorSource.getErrorSources();
            for (int i = 0; i < errorSources.length; ++i) {
                ErrorSource source = errorSources[i];
                if (source.getFileErrors(buffer.getSymlinkPath()) == null) continue;
                ErrorListPlugin.addErrorOverview(editPane);
                return;
            }
        }
        ErrorListPlugin.removeErrorOverview(editPane);
    }
}

