/*
 * Decompiled with CFR 0.152.
 */
package buffertabs;

import buffertabs.BufferTabs;
import buffertabs.BufferTabsOptionPane;
import java.awt.Component;
import java.awt.Container;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EBPlugin;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.textarea.JEditTextArea;

public class BufferTabsPlugin
extends EBPlugin {
    private static Hashtable tabsMap = new Hashtable();
    private static JPopupMenu popupMenu;

    public void handleMessage(EBMessage eBMessage) {
        if (eBMessage instanceof EditPaneUpdate) {
            EditPaneUpdate editPaneUpdate = (EditPaneUpdate)eBMessage;
            if (editPaneUpdate.getWhat() == EditPaneUpdate.CREATED) {
                this.editPaneCreated(editPaneUpdate.getEditPane());
            } else if (editPaneUpdate.getWhat() == EditPaneUpdate.DESTROYED) {
                this.editPaneDestroyed(editPaneUpdate.getEditPane());
            }
        } else if (eBMessage instanceof PropertiesChanged) {
            this.propertiesChanged();
        }
    }

    public void stop() {
        View[] viewArray = jEdit.getViews();
        for (int i = 0; i < viewArray.length; ++i) {
            EditPane[] editPaneArray = viewArray[i].getEditPanes();
            for (int j = 0; j < editPaneArray.length; ++j) {
                this.editPaneDestroyed(editPaneArray[j]);
            }
        }
    }

    public void start() {
        View[] viewArray = jEdit.getViews();
        for (int i = 0; i < viewArray.length; ++i) {
            EditPane[] editPaneArray = viewArray[i].getEditPanes();
            for (int j = 0; j < editPaneArray.length; ++j) {
                this.editPaneCreated(editPaneArray[j]);
            }
        }
    }

    private void editPaneCreated(EditPane editPane) {
        if (jEdit.getBooleanProperty((String)"buffertabs.enable", (boolean)false)) {
            BufferTabsPlugin.addBufferTabsToEditPane(editPane);
        }
    }

    private void editPaneDestroyed(EditPane editPane) {
        BufferTabsPlugin.removeBufferTabsFromEditPane(editPane);
    }

    private void propertiesChanged() {
        String string = BufferTabsOptionPane.getLocationProperty("buffertabs.location", "bottom");
        View[] viewArray = jEdit.getViews();
        for (int i = 0; i < viewArray.length; ++i) {
            EditPane[] editPaneArray = viewArray[i].getEditPanes();
            for (int j = 0; j < editPaneArray.length; ++j) {
                BufferTabs bufferTabs = (BufferTabs)tabsMap.get(editPaneArray[j]);
                if (bufferTabs == null) continue;
                bufferTabs.setTabPlacement(string);
                bufferTabs.updateTitles();
            }
        }
    }

    public static BufferTabs getBufferTabsForEditPane(EditPane editPane) {
        return editPane != null ? (BufferTabs)tabsMap.get(editPane) : null;
    }

    public static void toggleBufferTabsForEditPane(EditPane editPane) {
        boolean bl;
        boolean bl2 = bl = tabsMap.get(editPane) == null;
        if (bl) {
            BufferTabsPlugin.addBufferTabsToEditPane(editPane);
        } else {
            BufferTabsPlugin.removeBufferTabsFromEditPane(editPane);
        }
    }

    private static void addBufferTabsToEditPane(EditPane editPane) {
        JEditTextArea jEditTextArea = editPane.getTextArea();
        Container container = jEditTextArea.getParent();
        BufferTabs bufferTabs = new BufferTabs(editPane);
        bufferTabs.setTabPlacement(BufferTabsOptionPane.getLocationProperty("buffertabs.location", "bottom"));
        bufferTabs.start();
        container.add(bufferTabs);
        tabsMap.put(editPane, bufferTabs);
    }

    private static void removeBufferTabsFromEditPane(EditPane editPane) {
        Container container;
        JEditTextArea jEditTextArea = editPane.getTextArea();
        BufferTabs bufferTabs = BufferTabsPlugin.getBufferTabsForEditPane(editPane);
        if (bufferTabs == null) {
            return;
        }
        bufferTabs.stop();
        container.remove(bufferTabs);
        container.add((Component)jEditTextArea);
        tabsMap.remove(editPane);
        for (container = bufferTabs.getParent(); container != null && !(container instanceof JComponent); container = container.getParent()) {
        }
        if (container != null) {
            ((JComponent)container).revalidate();
        }
    }

    protected static JPopupMenu getRightClickPopup() {
        if (popupMenu == null) {
            popupMenu = GUIUtilities.loadPopupMenu((String)"buffertabs.popup");
            return popupMenu;
        }
        return popupMenu;
    }
}

