/*
 * Decompiled with CFR 0.152.
 */
package cartago.util.agent;

import cartago.ArtifactId;
import cartago.ArtifactObsProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ObsPropMap {
    private HashMap<String, ArrayList<cartago.util.agent.ArtifactObsProperty>> props = new HashMap();
    private HashMap<Long, ArrayList<cartago.util.agent.ArtifactObsProperty>> idListMap = new HashMap();

    public synchronized void addProperties(ArtifactId id, List<ArtifactObsProperty> list) {
        for (ArtifactObsProperty p : list) {
            this.add(new cartago.util.agent.ArtifactObsProperty(id, p.getId(), p.getName(), p.getValues()));
        }
    }

    public synchronized void updateProperty(ArtifactId aid, ArtifactObsProperty obs) {
        long id = obs.getId();
        List propList = this.idListMap.get(id);
        Iterator it = propList.iterator();
        while (it.hasNext()) {
            cartago.util.agent.ArtifactObsProperty prop = (cartago.util.agent.ArtifactObsProperty)it.next();
            if (prop.getId() != id) continue;
            it.remove();
            propList.add(new cartago.util.agent.ArtifactObsProperty(aid, obs.getId(), obs.getName(), obs.getValues()));
            break;
        }
    }

    public synchronized void remove(ArtifactObsProperty obs) {
        long id = obs.getId();
        List propList = this.idListMap.remove(id);
        if (propList != null) {
            Iterator it = propList.iterator();
            while (it.hasNext()) {
                cartago.util.agent.ArtifactObsProperty prop = (cartago.util.agent.ArtifactObsProperty)it.next();
                if (prop.getId() != id) continue;
                it.remove();
                break;
            }
        }
    }

    public synchronized void removeProperties(ArtifactId id) {
        for (Map.Entry<String, ArrayList<cartago.util.agent.ArtifactObsProperty>> entry : this.props.entrySet()) {
            Iterator<cartago.util.agent.ArtifactObsProperty> it2 = entry.getValue().iterator();
            while (it2.hasNext()) {
                cartago.util.agent.ArtifactObsProperty p = it2.next();
                if (!p.getArtifactId().equals(id)) continue;
                this.idListMap.remove(p.getId());
                it2.remove();
            }
        }
    }

    public synchronized void add(ArtifactId aid, ArtifactObsProperty prop) {
        this.add(new cartago.util.agent.ArtifactObsProperty(aid, prop.getId(), prop.getName(), prop.getValues()));
    }

    public synchronized void add(cartago.util.agent.ArtifactObsProperty prop) {
        ArrayList<cartago.util.agent.ArtifactObsProperty> list = this.props.get(prop.getName());
        if (list == null) {
            list = new ArrayList();
            this.props.put(prop.getName(), list);
        }
        list.add(prop);
        this.idListMap.put(prop.getId(), list);
    }

    public synchronized cartago.util.agent.ArtifactObsProperty getByName(String name) {
        ArrayList<cartago.util.agent.ArtifactObsProperty> list = this.props.get(name);
        if (list != null) {
            return list.get(0);
        }
        return null;
    }

    public synchronized cartago.util.agent.ArtifactObsProperty get(String name, Object ... values) {
        ArrayList<cartago.util.agent.ArtifactObsProperty> list = this.props.get(name);
        if (list != null) {
            if (values.length == 0) {
                return list.get(0);
            }
            for (cartago.util.agent.ArtifactObsProperty prop : list) {
                if (!prop.match(name, values)) continue;
                return prop;
            }
            return null;
        }
        return null;
    }

    public synchronized cartago.util.agent.ArtifactObsProperty getPropValue(String name, Object ... values) {
        return this.get(name, values);
    }

    public synchronized cartago.util.agent.ArtifactObsProperty getPropValueByName(String name) {
        return this.getByName(name);
    }
}

