/*
 * Decompiled with CFR 0.152.
 */
package cartago.util.agent;

import cartago.ArtifactId;
import cartago.ArtifactObsProperty;
import cartago.CartagoEvent;
import cartago.CartagoException;
import cartago.CartagoService;
import cartago.ICartagoListener;
import cartago.ICartagoSession;
import cartago.IEventFilter;
import cartago.Op;
import cartago.OpFeedbackParam;
import cartago.WorkspaceId;
import cartago.events.ActionFailedEvent;
import cartago.events.ArtifactObsEvent;
import cartago.events.CartagoActionEvent;
import cartago.events.FocusSucceededEvent;
import cartago.events.StopFocusSucceededEvent;
import cartago.security.AgentCredential;
import cartago.security.AgentIdCredential;
import cartago.util.agent.ActionFailedException;
import cartago.util.agent.ActionFeedback;
import cartago.util.agent.ActionFeedbackQueue;
import cartago.util.agent.ObsEventQueue;
import cartago.util.agent.ObsPropMap;
import cartago.util.agent.Percept;

public class CartagoBasicContext {
    public String name;
    private ICartagoSession session;
    private CartagoListener agentCallback;
    private ActionFeedbackQueue actionFeedbackQueue;
    private ObsEventQueue obsEventQueue;
    private ObsPropMap obsPropMap;
    private static final IEventFilter firstEventFilter = new IEventFilter(){

        @Override
        public boolean select(ArtifactObsEvent ev) {
            return true;
        }
    };

    public CartagoBasicContext(String name) {
        this.name = name;
        this.agentCallback = new CartagoListener();
        this.actionFeedbackQueue = new ActionFeedbackQueue();
        this.obsEventQueue = new ObsEventQueue();
        this.obsPropMap = new ObsPropMap();
        try {
            this.session = CartagoService.startSession("default", new AgentIdCredential(name), this.agentCallback);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public CartagoBasicContext(String name, String workspaceName) {
        this.name = name;
        this.agentCallback = new CartagoListener();
        this.actionFeedbackQueue = new ActionFeedbackQueue();
        this.obsEventQueue = new ObsEventQueue();
        this.obsPropMap = new ObsPropMap();
        try {
            this.session = CartagoService.startSession(workspaceName, new AgentIdCredential(name), this.agentCallback);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public CartagoBasicContext(String name, String workspaceName, String workspaceHost) {
        this.name = name;
        this.agentCallback = new CartagoListener();
        this.actionFeedbackQueue = new ActionFeedbackQueue();
        this.obsEventQueue = new ObsEventQueue();
        this.obsPropMap = new ObsPropMap();
        try {
            this.session = CartagoService.startRemoteSession(workspaceName, workspaceHost, "default", new AgentIdCredential(name), this.agentCallback);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public cartago.util.agent.ArtifactObsProperty getObsProperty(String name) {
        return this.obsPropMap.getByName(name);
    }

    public ActionFeedback doActionAsync(Op op) throws CartagoException {
        long id = this.session.doAction(op, null, -1L);
        ActionFeedback res = new ActionFeedback(id, this.actionFeedbackQueue);
        return res;
    }

    public ActionFeedback doActionAsync(ArtifactId aid, Op op, long timeout) throws CartagoException {
        long id = this.session.doAction(aid, op, null, timeout);
        ActionFeedback res = new ActionFeedback(id, this.actionFeedbackQueue);
        return res;
    }

    public ActionFeedback doActionAsync(Op op, long timeout) throws CartagoException {
        long id = this.session.doAction(op, null, timeout);
        ActionFeedback res = new ActionFeedback(id, this.actionFeedbackQueue);
        return res;
    }

    public void doAction(Op op, long timeout) throws ActionFailedException, CartagoException {
        long id = this.session.doAction(op, null, timeout);
        ActionFeedback res = new ActionFeedback(id, this.actionFeedbackQueue);
        try {
            res.waitForCompletion();
        }
        catch (Exception ex) {
            throw new CartagoException();
        }
        boolean failed = false;
        try {
            if (res.failed()) {
                failed = true;
            } else {
                Op retOp = res.getOp();
                if (retOp != op) {
                    Object[] params = op.getParamValues();
                    Object[] newParams = retOp.getParamValues();
                    for (int i = 0; i < params.length; ++i) {
                        if (!(params[i] instanceof OpFeedbackParam)) continue;
                        ((OpFeedbackParam)params[i]).copyFrom((OpFeedbackParam)newParams[i]);
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new CartagoException();
        }
        if (failed) {
            ActionFailedEvent ev = (ActionFailedEvent)res.getActionEvent();
            throw new ActionFailedException(ev.getFailureMsg(), ev.getFailureDescr());
        }
    }

    public void doAction(Op op) throws ActionFailedException, CartagoException {
        this.doAction(op, -1L);
    }

    public void doAction(ArtifactId aid, Op op, long timeout) throws ActionFailedException, CartagoException {
        long id = this.session.doAction(aid, op, null, timeout);
        ActionFeedback res = new ActionFeedback(id, this.actionFeedbackQueue);
        try {
            res.waitForCompletion();
        }
        catch (Exception ex) {
            throw new CartagoException();
        }
        boolean failed = false;
        try {
            if (res.failed()) {
                failed = true;
            } else {
                Op retOp = res.getOp();
                if (retOp != op) {
                    Object[] params = op.getParamValues();
                    Object[] newParams = retOp.getParamValues();
                    for (int i = 0; i < params.length; ++i) {
                        if (!(params[i] instanceof OpFeedbackParam)) continue;
                        ((OpFeedbackParam)params[i]).copyFrom((OpFeedbackParam)newParams[i]);
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new CartagoException();
        }
        if (failed) {
            ActionFailedEvent ev = (ActionFailedEvent)res.getActionEvent();
            throw new ActionFailedException(ev.getFailureMsg(), ev.getFailureDescr());
        }
    }

    public void doAction(ArtifactId aid, Op op) throws ActionFailedException, CartagoException {
        this.doAction(aid, op, -1L);
    }

    public void doAction(WorkspaceId wspId, Op op, long timeout) throws ActionFailedException, CartagoException {
        long id = this.session.doAction(wspId, op, null, timeout);
        ActionFeedback res = new ActionFeedback(id, this.actionFeedbackQueue);
        try {
            res.waitForCompletion();
        }
        catch (Exception ex) {
            throw new CartagoException();
        }
        boolean failed = false;
        try {
            if (res.failed()) {
                failed = true;
            } else {
                Op retOp = res.getOp();
                if (retOp != op) {
                    Object[] params = op.getParamValues();
                    Object[] newParams = retOp.getParamValues();
                    for (int i = 0; i < params.length; ++i) {
                        if (!(params[i] instanceof OpFeedbackParam)) continue;
                        ((OpFeedbackParam)params[i]).copyFrom((OpFeedbackParam)newParams[i]);
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new CartagoException();
        }
        if (failed) {
            ActionFailedEvent ev = (ActionFailedEvent)res.getActionEvent();
            throw new ActionFailedException(ev.getFailureMsg(), ev.getFailureDescr());
        }
    }

    public void doAction(WorkspaceId wspId, Op op) throws ActionFailedException, CartagoException {
        this.doAction(wspId, op, -1L);
    }

    public Percept fetchPercept() throws InterruptedException {
        ArtifactObsEvent ev = this.obsEventQueue.fetch(firstEventFilter);
        if (ev != null) {
            return new Percept(ev);
        }
        return null;
    }

    public Percept fetchPercept(IEventFilter filter) throws InterruptedException {
        ArtifactObsEvent ev = this.obsEventQueue.fetch(filter);
        if (ev != null) {
            return new Percept(ev);
        }
        return null;
    }

    public Percept waitForPercept() throws InterruptedException {
        ArtifactObsEvent ev = this.obsEventQueue.waitFor(firstEventFilter);
        return new Percept(ev);
    }

    public Percept waitForPercept(IEventFilter filter) throws InterruptedException {
        ArtifactObsEvent ev = this.obsEventQueue.waitFor(filter);
        return new Percept(ev);
    }

    public WorkspaceId joinWorkspace(String wspName, AgentCredential cred) throws CartagoException {
        OpFeedbackParam res = new OpFeedbackParam();
        try {
            this.doAction(new Op("joinWorkspace", wspName, cred, res), -1L);
        }
        catch (Exception ex) {
            throw new CartagoException();
        }
        return (WorkspaceId)res.get();
    }

    public WorkspaceId joinRemoteWorkspace(String wspName, String address, String roleName, AgentCredential cred) throws CartagoException {
        OpFeedbackParam res = new OpFeedbackParam();
        try {
            this.doAction(new Op("joinRemoteWorkspace", address, wspName, roleName, cred, res));
        }
        catch (Exception ex) {
            throw new CartagoException();
        }
        return (WorkspaceId)res.get();
    }

    public ArtifactId lookupArtifact(String artifactName) throws CartagoException {
        OpFeedbackParam res = new OpFeedbackParam();
        try {
            this.doAction(new Op("lookupArtifact", artifactName, res));
        }
        catch (Exception ex) {
            throw new CartagoException();
        }
        return (ArtifactId)res.get();
    }

    public ArtifactId makeArtifact(String artifactName, String templateName) throws CartagoException {
        OpFeedbackParam res = new OpFeedbackParam();
        try {
            this.doAction(new Op("makeArtifact", artifactName, templateName, new Object[0], res));
        }
        catch (Exception ex) {
            throw new CartagoException();
        }
        return (ArtifactId)res.get();
    }

    public ArtifactId makeArtifact(String artifactName, String templateName, Object[] params) throws CartagoException {
        OpFeedbackParam res = new OpFeedbackParam();
        try {
            this.doAction(new Op("makeArtifact", artifactName, templateName, params, res));
        }
        catch (Exception ex) {
            throw new CartagoException();
        }
        return (ArtifactId)res.get();
    }

    public void disposeArtifact(ArtifactId artifactId) throws CartagoException {
        try {
            this.doAction(new Op("disposeArtifact", artifactId));
        }
        catch (Exception ex) {
            throw new CartagoException();
        }
    }

    public void focus(ArtifactId artifactId) throws CartagoException {
        try {
            this.doAction(new Op("focus", artifactId));
        }
        catch (Exception ex) {
            throw new CartagoException();
        }
    }

    public void focus(ArtifactId artifactId, IEventFilter filter) throws CartagoException {
        try {
            this.doAction(new Op("focus", artifactId, filter));
        }
        catch (Exception ex) {
            throw new CartagoException();
        }
    }

    public void stopFocus(ArtifactId artifactId) throws CartagoException {
        try {
            this.doAction(new Op("stopFocus", artifactId));
        }
        catch (Exception ex) {
            throw new CartagoException();
        }
    }

    public void log(String msg) {
        System.out.println("[" + this.name + "] " + msg);
    }

    public String getName() {
        return this.name;
    }

    class CartagoListener
    implements ICartagoListener {
        @Override
        public boolean notifyCartagoEvent(CartagoEvent ev) {
            try {
                if (ev instanceof CartagoActionEvent) {
                    CartagoBasicContext.this.actionFeedbackQueue.add((CartagoActionEvent)ev);
                    if (ev instanceof FocusSucceededEvent) {
                        FocusSucceededEvent ev1 = (FocusSucceededEvent)ev;
                        CartagoBasicContext.this.obsPropMap.addProperties(ev1.getTargetArtifact(), ev1.getObsProperties());
                    } else if (ev instanceof StopFocusSucceededEvent) {
                        StopFocusSucceededEvent ev1 = (StopFocusSucceededEvent)ev;
                        CartagoBasicContext.this.obsPropMap.removeProperties(ev1.getTargetArtifact());
                    }
                } else if (ev instanceof ArtifactObsEvent) {
                    CartagoBasicContext.this.obsEventQueue.add((ArtifactObsEvent)ev);
                    ArtifactObsEvent ev1 = (ArtifactObsEvent)ev;
                    ArtifactObsProperty[] added = ev1.getAddedProperties();
                    ArtifactObsProperty[] changed = ev1.getChangedProperties();
                    ArtifactObsProperty[] removed = ev1.getRemovedProperties();
                    if (added != null) {
                        for (ArtifactObsProperty prop : added) {
                            CartagoBasicContext.this.obsPropMap.add(ev1.getArtifactId(), prop);
                        }
                    }
                    if (changed != null) {
                        for (ArtifactObsProperty prop : changed) {
                            CartagoBasicContext.this.obsPropMap.updateProperty(ev1.getArtifactId(), prop);
                        }
                    }
                    if (removed != null) {
                        for (ArtifactObsProperty prop : removed) {
                            CartagoBasicContext.this.obsPropMap.remove(prop);
                        }
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return false;
        }
    }
}

