/*
 * Decompiled with CFR 0.152.
 */
package cartago.util.agent;

import cartago.ArtifactId;
import cartago.CartagoException;
import cartago.CartagoNode;
import cartago.IEventFilter;
import cartago.Op;
import cartago.WorkspaceId;
import cartago.security.AgentCredential;
import cartago.util.agent.ActionFailedException;
import cartago.util.agent.ActionFeedback;
import cartago.util.agent.ArtifactObsProperty;
import cartago.util.agent.CartagoBasicContext;
import cartago.util.agent.Percept;

public class Agent
extends Thread {
    private CartagoBasicContext ctx;
    protected static Object[] NO_PARAMS = new Object[0];

    public Agent(String agentName) {
        super(agentName);
        this.ctx = new CartagoBasicContext(agentName, CartagoNode.MAIN_WSP_NAME);
    }

    public Agent(String agentName, String workspaceName, String workspaceHost) {
        super(agentName);
        this.ctx = new CartagoBasicContext(agentName, workspaceName, workspaceHost);
    }

    protected String getAgentName() {
        return this.ctx.getName();
    }

    protected ActionFeedback doActionAsync(Op op) throws CartagoException {
        return this.ctx.doActionAsync(op);
    }

    protected ActionFeedback doActionAsync(ArtifactId aid, Op op, long timeout) throws CartagoException {
        return this.ctx.doActionAsync(aid, op, timeout);
    }

    protected ActionFeedback doActionAsync(Op op, long timeout) throws CartagoException {
        return this.ctx.doActionAsync(op, timeout);
    }

    protected void doAction(Op op, long timeout) throws ActionFailedException, CartagoException {
        this.ctx.doAction(op, timeout);
    }

    protected void doAction(Op op) throws ActionFailedException, CartagoException {
        this.doAction(op, -1L);
    }

    protected void doAction(ArtifactId aid, Op op, long timeout) throws ActionFailedException, CartagoException {
        this.ctx.doAction(aid, op, timeout);
    }

    protected void doAction(ArtifactId aid, Op op) throws ActionFailedException, CartagoException {
        this.doAction(aid, op, -1L);
    }

    protected Percept fetchPercept() throws InterruptedException {
        return this.ctx.fetchPercept();
    }

    protected Percept waitForPercept() throws InterruptedException {
        return this.ctx.waitForPercept();
    }

    protected Percept waitForPercept(IEventFilter filter) throws InterruptedException {
        return this.ctx.waitForPercept(filter);
    }

    protected void waitFor(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void log(String msg) {
        System.out.println("[" + this.ctx.getName() + "] " + msg);
    }

    protected WorkspaceId joinWorkspace(String wspName, AgentCredential cred) throws CartagoException {
        return this.ctx.joinWorkspace(wspName, cred);
    }

    protected WorkspaceId joinRemoteWorkspace(String wspName, String address, String roleName, AgentCredential cred) throws CartagoException {
        return this.ctx.joinRemoteWorkspace(wspName, address, roleName, cred);
    }

    protected ArtifactId lookupArtifact(String artifactName) throws CartagoException {
        return this.ctx.lookupArtifact(artifactName);
    }

    protected ArtifactId discoverArtifact(String artifactName) throws CartagoException {
        ArtifactId aid = null;
        while (aid == null) {
            try {
                aid = this.lookupArtifact(artifactName);
            }
            catch (Exception ex) {
                this.waitFor(100L);
            }
        }
        return aid;
    }

    protected ArtifactId makeArtifact(String artifactName, String templateName) throws CartagoException {
        return this.ctx.makeArtifact(artifactName, templateName);
    }

    protected ArtifactId makeArtifact(String artifactName, String templateName, Object[] params) throws CartagoException {
        return this.ctx.makeArtifact(artifactName, templateName, params);
    }

    protected void disposeArtifact(ArtifactId artifactId) throws CartagoException {
        this.ctx.disposeArtifact(artifactId);
    }

    protected void focus(ArtifactId artifactId) throws CartagoException {
        this.ctx.focus(artifactId);
    }

    protected void focus(ArtifactId artifactId, IEventFilter filter) throws CartagoException {
        this.ctx.focus(artifactId, filter);
    }

    protected void stopFocus(ArtifactId aid) throws CartagoException {
        this.ctx.stopFocus(aid);
    }

    protected ArtifactObsProperty getObsProperty(String name) {
        return this.ctx.getObsProperty(name);
    }
}

