/*
 * Decompiled with CFR 0.152.
 */
package cartago.util;

import cartago.AgentId;
import cartago.ArtifactId;
import cartago.ArtifactObsProperty;
import cartago.ICartagoLogger;
import cartago.IEventFilter;
import cartago.Op;
import cartago.OpId;
import cartago.Tuple;
import java.io.FileWriter;
import java.io.IOException;

public class BasicLoggerOnFile
implements ICartagoLogger {
    private FileWriter fw;

    public BasicLoggerOnFile(String fileName) throws IOException {
        this.fw = new FileWriter(fileName);
    }

    @Override
    public void agentJoined(long when, AgentId id) {
        this.log(when, "agent " + id + " joined the workspace.");
    }

    @Override
    public void agentQuit(long when, AgentId id) {
        this.log(when, "agent " + id + " quit the workspace.");
    }

    @Override
    public void artifactCreated(long when, ArtifactId id, AgentId creator) {
        this.log(when, "artifact " + id.getName() + " type: " + id.getArtifactType() + " has been created by " + creator);
    }

    @Override
    public void artifactDisposed(long when, ArtifactId id, AgentId disposer) {
        this.log(when, "artifact " + id + " has been disposed by " + disposer);
    }

    @Override
    public void artifactFocussed(long when, AgentId who, ArtifactId id, IEventFilter ev) {
        this.log(when, "artifact " + id + " focussed by " + who);
    }

    @Override
    public void artifactNoMoreFocussed(long when, AgentId who, ArtifactId id) {
        this.log(when, "artifact " + id + " no more focussed by " + who);
    }

    @Override
    public void artifactsLinked(long when, AgentId id, ArtifactId linking, ArtifactId linked) {
        this.log(when, "artifact " + linking + " linked to " + linked + " by " + id);
    }

    @Override
    public void newPercept(long when, ArtifactId aid, Tuple signal, ArtifactObsProperty[] added, ArtifactObsProperty[] removed, ArtifactObsProperty[] changed) {
        StringBuffer buffer = new StringBuffer("new percept generated about artifact " + aid + " ");
        if (signal != null) {
            buffer.append("signal: " + signal + " ");
        }
        if (added != null) {
            buffer.append("added properties: " + added);
        }
        if (changed != null) {
            buffer.append("changed properties: " + changed);
        }
        if (removed != null) {
            buffer.append("removed properties: " + removed);
        }
        this.log(when, buffer.toString());
    }

    @Override
    public void opCompleted(long when, OpId oid, ArtifactId aid, Op op) {
        this.log(when, "operation " + op + " completed in artifact " + aid);
    }

    @Override
    public void opFailed(long when, OpId oid, ArtifactId aid, Op op, String msg, Tuple descr) {
        this.log(when, "operation " + op + " failed in artifact " + aid + " - msg:" + msg + " desc:" + descr);
    }

    @Override
    public void opRequested(long when, AgentId who, ArtifactId aid, Op op) {
        StringBuffer buffer = new StringBuffer("operation " + op + " requested ");
        if (aid != null) {
            buffer.append("in artifact " + aid + " ");
        }
        if (who != null) {
            buffer.append("by agent " + who + " ");
        }
        this.log(when, buffer.toString());
    }

    @Override
    public void opResumed(long when, OpId oid, ArtifactId aid, Op op) {
        this.log(when, "operation " + op + " resumed in artifact " + aid);
    }

    @Override
    public void opStarted(long when, OpId oid, ArtifactId aid, Op op) {
        this.log(when, "operation " + op + " started in artifact " + aid);
    }

    @Override
    public void opSuspended(long when, OpId oid, ArtifactId aid, Op op) {
        this.log(when, "operation " + op + " suspended in artifact " + aid);
    }

    protected void log(long when, String msg) {
        try {
            this.fw.write("[ " + when + " ] " + msg + "\n");
            this.fw.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

