/*
 * Decompiled with CFR 0.152.
 */
package cartago.tools.inspector;

import cartago.AgentId;
import cartago.ArtifactId;
import cartago.Op;
import cartago.OpId;
import cartago.tools.inspector.AgentMarker;
import cartago.tools.inspector.ArtifactMarker;
import cartago.tools.inspector.FocussedArtifactInfo;
import cartago.tools.inspector.OpInfo;
import cartago.tools.inspector.P2d;
import cartago.tools.inspector.V2d;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class WorkspaceScene {
    ArrayList<AgentMarker> agents;
    ArrayList<ArtifactMarker> artifacts;
    HashMap<String, OpInfo> ongoingOp;
    LinkedList<FocussedArtifactInfo> focussedArt;
    Random rand;
    Lock lock;
    int currentIndex = 0;
    P2d[] pos = new P2d[]{new P2d(0.25, 0.0), new P2d(0.25, 0.25), new P2d(0.0, 0.25), new P2d(-0.25, 0.25), new P2d(-0.25, 0.0), new P2d(-0.25, -0.25), new P2d(0.0, -0.25), new P2d(0.25, -0.25)};
    P2d currentPos;

    public WorkspaceScene() {
        this.rand = new Random();
        this.agents = new ArrayList();
        this.artifacts = new ArrayList();
        this.ongoingOp = new HashMap();
        this.focussedArt = new LinkedList();
        this.lock = new ReentrantLock();
        this.currentPos = new P2d(0.0, 0.0);
    }

    public void addAgent(AgentId id) {
        try {
            this.lock.lock();
            P2d pos = this.nextPos();
            this.agents.add(new AgentMarker(id, pos));
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeAgent(AgentId id) {
        try {
            this.lock.lock();
            this.agents.remove(id);
        }
        finally {
            this.lock.unlock();
        }
    }

    private P2d nextPos() {
        int index = this.currentIndex;
        this.currentIndex = (this.currentIndex + 1) % this.pos.length;
        P2d p = this.pos[index].copy();
        p.scale(1.5);
        double x = this.rand.nextDouble() * 0.1 - 0.05;
        double y = this.rand.nextDouble() * 0.1 - 0.05;
        p.sum(new V2d(x, y));
        return p;
    }

    private P2d nextPosNear(P2d p0) {
        P2d p = p0.copy();
        double x = this.rand.nextDouble() * 0.25 - 0.125;
        double y = this.rand.nextDouble() * 0.25 - 0.125;
        p.sum(new V2d(x, y));
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addArtifact(ArtifactId id, AgentId creator) {
        try {
            P2d posOwner;
            P2d pos = null;
            this.lock.lock();
            if (creator != null && (posOwner = this.getAgentPos(creator)) != null) {
                pos = this.nextPosNear(posOwner);
            }
            if (pos == null) {
                pos = this.nextPos();
            }
            this.artifacts.add(new ArtifactMarker(id, pos));
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeArtifact(ArtifactId id) {
        try {
            this.lock.lock();
            this.artifacts.remove(id);
        }
        finally {
            this.lock.unlock();
        }
    }

    public ArrayList<AgentMarker> getAgents() {
        return this.agents;
    }

    public ArrayList<ArtifactMarker> getArtifacts() {
        return this.artifacts;
    }

    public Collection<OpInfo> getOngoingOps() {
        return this.ongoingOp.values();
    }

    public Collection<FocussedArtifactInfo> getFocussedArtifacts() {
        return this.focussedArt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOngoingOp(AgentId who, ArtifactId aid, Op op, OpId oid) {
        try {
            this.lock.lock();
            String key = oid.getArtifactId().getName() + oid.getId();
            OpInfo info = new OpInfo(who, aid, op);
            info.changeStateToStarted(oid);
            this.ongoingOp.put(key, info);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFocus(AgentId who, ArtifactId aid) {
        try {
            this.lock.lock();
            FocussedArtifactInfo info = new FocussedArtifactInfo(who, aid);
            this.focussedArt.add(info);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeOpStateToCompleted(OpId id) {
        try {
            this.lock.lock();
            String key = id.getArtifactId().getName() + id.getId();
            OpInfo opInfo = this.ongoingOp.get(key);
            opInfo.changeStateToCompleted(id);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeOpStateToFailed(OpId id) {
        try {
            this.lock.lock();
            String key = id.getArtifactId().getName() + id.getId();
            OpInfo opInfo = this.ongoingOp.get(key);
            opInfo.changeStateToFailed(id);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update() {
        try {
            V2d vect;
            this.lock.lock();
            for (AgentMarker agentMarker : this.agents) {
                for (AgentMarker m1 : this.agents) {
                    if (agentMarker == m1) continue;
                    vect = new V2d(agentMarker.getPos(), m1.getPos());
                    this.applyForce(vect, agentMarker.getPos());
                }
                for (ArtifactMarker m2 : this.artifacts) {
                    vect = new V2d(agentMarker.getPos(), m2.getPos());
                    this.applyForce(vect, agentMarker.getPos());
                }
            }
            for (ArtifactMarker artifactMarker : this.artifacts) {
                for (AgentMarker m1 : this.agents) {
                    vect = new V2d(artifactMarker.getPos(), m1.getPos());
                    this.applyForce(vect, artifactMarker.getPos());
                }
                for (ArtifactMarker m2 : this.artifacts) {
                    if (artifactMarker == m2) continue;
                    vect = new V2d(artifactMarker.getPos(), m2.getPos());
                    this.applyForce(vect, artifactMarker.getPos());
                }
            }
            Iterator<OpInfo> it = this.ongoingOp.values().iterator();
            while (it.hasNext()) {
                OpInfo opInfo = it.next();
                long time = System.currentTimeMillis();
                if (!opInfo.hasCompleted() && !opInfo.hasFailed() || time - opInfo.getTimestamp() <= 50L) continue;
                it.remove();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void applyForce(V2d force, P2d pos) {
        double alfa = 1.0E-4;
        double dist = force.abs();
        if (dist == 0.0) {
            double x = this.rand.nextDouble() * 0.2 - 0.1;
            double y = this.rand.nextDouble() * 0.2 - 0.1;
            pos.sum(new V2d(x, y));
        } else {
            double forceMod = alfa / (dist * dist * dist);
            if (forceMod > 5.0E-4) {
                force.normalize();
                if (forceMod > 0.25) {
                    forceMod = 0.25;
                }
                force.mul(forceMod);
                pos.sum(force);
            }
        }
    }

    private void applyForce2(V2d force, P2d pos) {
        double alfa = 5.0E-4;
        double dist = force.abs();
        if (dist == 0.0) {
            double x = this.rand.nextDouble() * 0.1 - 0.05;
            double y = this.rand.nextDouble() * 0.1 - 0.05;
            pos.sum(new V2d(x, y));
        } else {
            double forceMod = alfa * dist;
            if (forceMod > 5.0E-4) {
                force.normalize();
                if (forceMod > 0.25) {
                    forceMod = 0.25;
                }
                force.mul(forceMod);
                pos.sum(force);
            }
        }
    }

    private void log(String msg) {
        System.out.println("[SCENE] " + msg);
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    private P2d getAgentPos(AgentId id) {
        for (AgentMarker marker : this.agents) {
            if (!marker.getAgentId().equals(id)) continue;
            return marker.getPos();
        }
        return null;
    }

    private P2d getArtifactPos(ArtifactId id) {
        for (ArtifactMarker marker : this.artifacts) {
            if (!marker.getArtifactId().equals(id)) continue;
            return marker.getPos();
        }
        return null;
    }
}

