/*
 * Decompiled with CFR 0.152.
 */
package cartago.tools.inspector;

import cartago.tools.inspector.AgentJoined;
import cartago.tools.inspector.AgentQuit;
import cartago.tools.inspector.ArtifactCreated;
import cartago.tools.inspector.ArtifactDisposed;
import cartago.tools.inspector.Inspector;
import cartago.tools.inspector.LoggerEvent;
import cartago.tools.inspector.OpCompleted;
import cartago.tools.inspector.OpFailed;
import cartago.tools.inspector.OpRequested;
import cartago.tools.inspector.OpStarted;
import cartago.tools.inspector.WorkspaceScene;
import java.util.HashMap;

public class Updater
extends Thread {
    Inspector insp;
    WorkspaceScene scene;
    HashMap<Class<? extends LoggerEvent>, Command> commands = new HashMap();

    public Updater(Inspector insp) {
        this.insp = insp;
        this.scene = insp.getWorkspaceScene();
        this.commands.put(AgentJoined.class, new Command(){

            @Override
            public void process(LoggerEvent event) {
                AgentJoined ev = (AgentJoined)event;
                Updater.this.scene.addAgent(ev.getAgentId());
            }
        });
        this.commands.put(AgentQuit.class, new Command(){

            @Override
            public void process(LoggerEvent event) {
                AgentQuit ev = (AgentQuit)event;
                Updater.this.scene.removeAgent(ev.getAgentId());
            }
        });
        this.commands.put(ArtifactCreated.class, new Command(){

            @Override
            public void process(LoggerEvent event) {
                ArtifactCreated ev = (ArtifactCreated)event;
                Updater.this.scene.addArtifact(ev.getArtifactId(), ev.getCreatorId());
            }
        });
        this.commands.put(ArtifactDisposed.class, new Command(){

            @Override
            public void process(LoggerEvent event) {
                ArtifactDisposed ev = (ArtifactDisposed)event;
                Updater.this.scene.removeArtifact(ev.getArtifactId());
            }
        });
        this.commands.put(OpRequested.class, new Command(){

            @Override
            public void process(LoggerEvent event) {
                OpRequested ev = (OpRequested)event;
            }
        });
        this.commands.put(OpStarted.class, new Command(){

            @Override
            public void process(LoggerEvent event) {
                OpStarted ev = (OpStarted)event;
                Updater.this.scene.addOngoingOp(ev.getOpId().getAgentBodyId(), ev.getArtifactId(), ev.getOp(), ev.getOpId());
            }
        });
        this.commands.put(OpCompleted.class, new Command(){

            @Override
            public void process(LoggerEvent event) {
            }
        });
        this.commands.put(OpFailed.class, new Command(){

            @Override
            public void process(LoggerEvent event) {
            }
        });
    }

    @Override
    public void run() {
        while (true) {
            LoggerEvent event;
            Command cmd;
            if ((cmd = this.commands.get((event = this.insp.fetchEvent()).getClass())) != null) {
                this.log("new event: " + event);
                cmd.process(event);
                continue;
            }
            this.log("unrecognized event: " + event);
        }
    }

    private void log(String msg) {
        System.out.println("[UPDATER] " + msg);
    }

    static interface Command {
        public void process(LoggerEvent var1);
    }
}

