/*
 * Decompiled with CFR 0.152.
 */
package cartago.tools.inspector;

import cartago.AgentId;
import cartago.ArtifactId;
import cartago.Op;
import cartago.OpId;

public class OpInfo {
    private ArtifactId targetId;
    private Op op;
    private AgentId agentId;
    private OpId oid;
    private OpState opState;
    private long timestamp;

    public OpInfo(AgentId agentId, ArtifactId targetId, Op op) {
        this.agentId = agentId;
        this.targetId = targetId;
        this.op = op;
        this.opState = OpState.requested;
        this.timestamp = System.currentTimeMillis();
    }

    public boolean hasCompleted() {
        return this.opState.equals((Object)OpState.completed);
    }

    public boolean hasFailed() {
        return this.opState.equals((Object)OpState.failed);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean hasStarted() {
        return this.opState.equals((Object)OpState.started);
    }

    public void changeStateToStarted(OpId oid) {
        this.opState = OpState.started;
        this.oid = oid;
        this.timestamp = System.currentTimeMillis();
    }

    public void changeStateToCompleted(OpId oid) {
        this.opState = OpState.completed;
        this.timestamp = System.currentTimeMillis();
    }

    public void changeStateToFailed(OpId oid) {
        this.opState = OpState.failed;
        this.timestamp = System.currentTimeMillis();
    }

    public Op getOp() {
        return this.op;
    }

    public OpId getOpId() {
        return this.oid;
    }

    public ArtifactId getTargetId() {
        return this.targetId;
    }

    public AgentId getAgentId() {
        return this.agentId;
    }

    public OpState getOpState() {
        return this.opState;
    }

    public static enum OpState {
        requested,
        started,
        completed,
        failed;

    }
}

