/*
 * Decompiled with CFR 0.152.
 */
package cartago.tools.inspector;

import cartago.AgentId;
import cartago.ArtifactId;
import cartago.tools.inspector.AgentMarker;
import cartago.tools.inspector.ArtifactMarker;
import cartago.tools.inspector.FocussedArtifactInfo;
import cartago.tools.inspector.OpInfo;
import cartago.tools.inspector.P2d;
import cartago.tools.inspector.WorkspaceScene;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JPanel;

class InspectorPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
ActionListener {
    WorkspaceScene scene;
    int cx;
    int cy;
    int x0;
    int y0;
    int x1;
    int y1;
    double posX0 = 0.0;
    double posY0 = 0.0;
    double factor = 1.0;
    boolean pressedLeft;
    boolean pressedRight;
    int xpos;
    int xposPrev;
    int ypos;
    int yposPrev;
    JButton zoomIn;
    JButton zoomOut;
    AgentMarker draggedAgent;
    ArtifactMarker draggedArtifact;

    public InspectorPanel(WorkspaceScene scene, int x0, int y0, int x1, int y1) {
        this.scene = scene;
        this.cx = (x1 - x0) / 2 + x0;
        this.cy = (y1 - y0) / 2 + y0;
        this.pressedLeft = false;
        this.pressedRight = false;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.zoomIn = new JButton("zoom +");
        this.zoomOut = new JButton("zoom -");
        this.add(this.zoomIn);
        this.add(this.zoomOut);
        this.zoomIn.addActionListener(this);
        this.zoomOut.addActionListener(this);
    }

    private void log(String msg) {
        System.out.println("[VIEW] " + msg);
    }

    @Override
    public void paintComponent(Graphics g) {
        int by;
        int bx;
        P2d pos1;
        int ay;
        int ax;
        int y;
        int x;
        P2d pos;
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.WHITE);
        g2.fillRect(0, 0, 800, 600);
        this.scene.lock();
        ArrayList<AgentMarker> agList = this.scene.getAgents();
        ArrayList<ArtifactMarker> arList = this.scene.getArtifacts();
        Collection<OpInfo> ops = this.scene.getOngoingOps();
        Collection<FocussedArtifactInfo> obs = this.scene.getFocussedArtifacts();
        g2.setColor(Color.BLUE);
        for (AgentMarker agentMarker : agList) {
            pos = agentMarker.getPos();
            x = (int)((double)this.cx + (pos.x - this.posX0) * (double)(this.x1 - this.cx) * this.factor);
            y = (int)((double)this.cy - (pos.y - this.posY0) * (double)(this.cy - this.y0) * this.factor);
            agentMarker.cacheViewPos(x, y);
            g2.fillOval(x - 4, y - 4, 8, 8);
            g2.drawString(agentMarker.getAgentId().getAgentName(), x - 32, y + 20);
        }
        g2.setColor(Color.BLACK);
        for (ArtifactMarker artifactMarker : arList) {
            pos = artifactMarker.getPos();
            x = (int)((double)this.cx + (pos.x - this.posX0) * (double)(this.x1 - this.cx) * this.factor);
            y = (int)((double)this.cy - (pos.y - this.posY0) * (double)(this.cy - this.y0) * this.factor);
            artifactMarker.cacheViewPos(x, y);
            g2.fillRect(x - 4, y - 4, 8, 8);
            g2.drawString(artifactMarker.getArtifactId().getName(), x - 32, y + 20);
        }
        g2.setColor(Color.BLUE);
        for (OpInfo opInfo : ops) {
            pos = this.getAgentPos(agList, opInfo.getAgentId());
            if (pos == null) continue;
            ax = (int)((double)this.cx + (pos.x - this.posX0) * (double)(this.x1 - this.cx) * this.factor);
            ay = (int)((double)this.cy - (pos.y - this.posY0) * (double)(this.cy - this.y0) * this.factor);
            pos1 = this.getArtifactPos(arList, opInfo.getTargetId());
            if (pos1 == null) continue;
            bx = (int)((double)this.cx + (pos1.x - this.posX0) * (double)(this.x1 - this.cx) * this.factor);
            by = (int)((double)this.cy - (pos1.y - this.posY0) * (double)(this.cy - this.y0) * this.factor);
            g2.drawLine(ax, ay, bx, by);
            g2.drawString(opInfo.getOp().getName(), (ax + bx) / 2, (ay + by) / 2);
        }
        g2.setColor(Color.YELLOW);
        for (FocussedArtifactInfo focussedArtifactInfo : obs) {
            pos = this.getAgentPos(agList, focussedArtifactInfo.getAgentId());
            if (pos != null) {
                ax = (int)((double)this.cx + (pos.x - this.posX0) * (double)(this.x1 - this.cx) * this.factor);
                ay = (int)((double)this.cy - (pos.y - this.posY0) * (double)(this.cy - this.y0) * this.factor);
                pos1 = this.getArtifactPos(arList, focussedArtifactInfo.getTargetId());
                if (pos1 != null) {
                    bx = (int)((double)this.cx + (pos1.x - this.posX0) * (double)(this.x1 - this.cx) * this.factor);
                    by = (int)((double)this.cy - (pos1.y - this.posY0) * (double)(this.cy - this.y0) * this.factor);
                    g2.drawLine(ax, ay, bx, by);
                    continue;
                }
                this.log("!ERROR! artifact not avail: " + focussedArtifactInfo.getTargetId());
                continue;
            }
            this.log("!ERROR! agent not avail: " + focussedArtifactInfo.getAgentId());
        }
        this.scene.unlock();
    }

    private P2d getAgentPos(ArrayList<AgentMarker> list, AgentId id) {
        for (AgentMarker marker : list) {
            if (!marker.getAgentId().equals(id)) continue;
            return marker.getPos();
        }
        return null;
    }

    private P2d getArtifactPos(ArrayList<ArtifactMarker> list, ArtifactId id) {
        for (ArtifactMarker marker : list) {
            if (!marker.getArtifactId().equals(id)) continue;
            return marker.getPos();
        }
        return null;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            this.pressedLeft = true;
        } else if (e.getButton() == 2) {
            this.pressedRight = true;
        }
        this.scene.lock();
        this.draggedArtifact = null;
        for (ArtifactMarker artifactMarker : this.scene.getArtifacts()) {
            if (!artifactMarker.hit(e.getX(), e.getY(), 5)) continue;
            this.draggedArtifact = artifactMarker;
            break;
        }
        this.draggedAgent = null;
        if (this.draggedArtifact == null) {
            for (AgentMarker agentMarker : this.scene.getAgents()) {
                if (!agentMarker.hit(e.getX(), e.getY(), 5)) continue;
                this.draggedAgent = agentMarker;
                break;
            }
        }
        this.scene.unlock();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 1) {
            this.pressedLeft = false;
        } else if (e.getButton() == 2) {
            this.pressedRight = false;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.xposPrev = this.xpos;
        this.yposPrev = this.ypos;
        this.xpos = e.getX();
        this.ypos = e.getY();
        int dx = this.xpos - this.xposPrev;
        int dy = this.ypos - this.yposPrev;
        if (this.pressedLeft) {
            if (this.draggedArtifact != null) {
                double newx = ((double)this.draggedArtifact.getViewPosX() + (double)dx - (double)this.cx) / (this.factor * (double)(this.x1 - this.cx)) + this.draggedArtifact.getPos().x;
                double newy = (double)(this.cy - (this.draggedArtifact.getViewPosY() + dy)) / (this.factor * (double)(this.cy - this.y0)) + this.draggedArtifact.getPos().y;
                this.draggedArtifact.getPos().x = newx;
                this.draggedArtifact.getPos().y = newy;
            } else if (this.draggedAgent == null) {
                if (dx > 2) {
                    this.posX0 += 0.01;
                } else if (dx < -2) {
                    this.posX0 -= 0.01;
                }
                if (dy > 2) {
                    this.posY0 += 0.01;
                } else if (dy < -2) {
                    this.posY0 -= 0.01;
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.zoomIn) {
            this.factor *= 1.05;
        } else if (e.getSource() == this.zoomOut) {
            this.factor /= 1.05;
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

