/*
 * Decompiled with CFR 0.152.
 */
package cartago.tools.inspector;

import cartago.AgentId;
import cartago.ArtifactId;
import cartago.ArtifactObsProperty;
import cartago.ICartagoLogger;
import cartago.IEventFilter;
import cartago.Op;
import cartago.OpId;
import cartago.Tuple;
import cartago.tools.inspector.Inspector;
import cartago.tools.inspector.WorkspaceScene;

public class InspectorLogger
implements ICartagoLogger {
    private Inspector insp;
    private WorkspaceScene scene;

    public InspectorLogger(Inspector insp) {
        this.insp = insp;
        this.scene = insp.getWorkspaceScene();
    }

    @Override
    public void agentJoined(long when, AgentId id) {
        this.scene.addAgent(id);
    }

    @Override
    public void agentQuit(long when, AgentId id) {
        this.scene.removeAgent(id);
    }

    @Override
    public void artifactCreated(long when, ArtifactId id, AgentId creator) {
        this.scene.addArtifact(id, creator);
    }

    @Override
    public void artifactDisposed(long when, ArtifactId id, AgentId disposer) {
        this.scene.removeArtifact(id);
    }

    @Override
    public void artifactFocussed(long when, AgentId who, ArtifactId id, IEventFilter ev) {
        this.scene.addFocus(who, id);
    }

    @Override
    public void artifactNoMoreFocussed(long when, AgentId who, ArtifactId id) {
    }

    @Override
    public void artifactsLinked(long when, AgentId id, ArtifactId linking, ArtifactId linked) {
    }

    @Override
    public void newPercept(long when, ArtifactId aid, Tuple signal, ArtifactObsProperty[] added, ArtifactObsProperty[] removed, ArtifactObsProperty[] changed) {
    }

    @Override
    public void opCompleted(long when, OpId oid, ArtifactId aid, Op op) {
        this.scene.changeOpStateToCompleted(oid);
    }

    @Override
    public void opFailed(long when, OpId oid, ArtifactId aid, Op op, String msg, Tuple descr) {
        this.scene.changeOpStateToFailed(oid);
    }

    @Override
    public void opRequested(long when, AgentId who, ArtifactId aid, Op op) {
    }

    @Override
    public void opResumed(long when, OpId oid, ArtifactId aid, Op op) {
    }

    @Override
    public void opStarted(long when, OpId oid, ArtifactId aid, Op op) {
        this.scene.addOngoingOp(oid.getAgentBodyId(), aid, op, oid);
    }

    @Override
    public void opSuspended(long when, OpId oid, ArtifactId aid, Op op) {
    }
}

