/*
 * Decompiled with CFR 0.152.
 */
package cartago.tools.inspector;

import cartago.ICartagoLogger;
import cartago.tools.inspector.InspectorLogger;
import cartago.tools.inspector.InspectorView;
import cartago.tools.inspector.LoggerEvent;
import cartago.tools.inspector.Renderer;
import cartago.tools.inspector.Updater;
import cartago.tools.inspector.WorkspaceScene;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class Inspector {
    private LinkedBlockingQueue<LoggerEvent> eventQueue = new LinkedBlockingQueue();
    private InspectorLogger logger;
    private WorkspaceScene scene = new WorkspaceScene();
    private Updater updater;
    private Renderer renderer;
    private InspectorView view;

    public Inspector() {
        this.logger = new InspectorLogger(this);
        this.updater = new Updater(this);
        this.view = new InspectorView(this.scene);
        this.view.setVisible(true);
        this.renderer = new Renderer(this.scene, this.view);
    }

    public void start() {
        this.updater.start();
        this.renderer.start();
    }

    public ICartagoLogger getLogger() {
        return this.logger;
    }

    public WorkspaceScene getWorkspaceScene() {
        return this.scene;
    }

    public void notifyEvent(LoggerEvent ev) {
        this.eventQueue.add(ev);
    }

    public LoggerEvent fetchEvent() {
        try {
            return this.eventQueue.poll(1000000L, TimeUnit.MILLISECONDS);
        }
        catch (Exception ex) {
            return null;
        }
    }
}

