/*
 * Decompiled with CFR 0.152.
 */
package cartago.tools;

import cartago.OpFeedbackParam;
import cartago.Tuple;
import java.io.Serializable;

public class TupleTemplate
implements Serializable {
    private String name;
    private Object[] args;
    private static final Object[] EMPTY = new Object[0];
    public static final Object ANY = null;
    public static final Object UNKNOWN = null;

    public TupleTemplate(String name) {
        this.args = EMPTY;
        this.name = name;
    }

    public TupleTemplate(String name, Object ... objs) {
        this.name = name;
        this.args = objs;
        if (this.args == null) {
            this.args = EMPTY;
        }
    }

    public TupleTemplate(Object[] objs) {
        this.name = (String)objs[0];
        this.args = new Object[objs.length - 1];
        for (int i = 1; i < objs.length; ++i) {
            this.args[i - 1] = objs[i];
        }
    }

    public String getLabel() {
        return this.name;
    }

    public Object getContent(int index) {
        return this.args[index];
    }

    public Object[] getContents() {
        return this.args;
    }

    public int intContent(int index) {
        return ((Number)this.args[index]).intValue();
    }

    public double doubleContent(int index) {
        return ((Number)this.args[index]).doubleValue();
    }

    public boolean booleanContent(int index) {
        return (Boolean)this.args[index];
    }

    public String stringContent(int index) {
        return (String)this.args[index];
    }

    public int getNArgs() {
        return this.args.length;
    }

    public boolean match(Tuple t) {
        if (!t.getLabel().equals(this.name) || t.getNArgs() != this.args.length) {
            return false;
        }
        Object[] objs = t.getContents();
        for (int i = 0; i < objs.length; ++i) {
            if (this.args[i] == null || this.args[i] instanceof OpFeedbackParam || objs[i] == null || this.args[i].equals(objs[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer st = new StringBuffer(this.name);
        if (this.args.length > 0) {
            st.append("(" + this.args[0]);
            for (int i = 1; i < this.args.length; ++i) {
                st.append(",");
                String s = this.args[i].toString();
                if (s.equals("")) {
                    s = "\"\"";
                }
                st.append(s);
            }
            st.append(")");
        }
        return st.toString();
    }
}

