/*
 * Decompiled with CFR 0.152.
 */
package cartago.tools;

import cartago.Artifact;
import cartago.GUARD;
import cartago.OPERATION;
import cartago.OpFeedbackParam;
import cartago.Tuple;
import cartago.tools.TupleSet;
import cartago.tools.TupleTemplate;

public class TupleSpace
extends Artifact {
    TupleSet tset;

    void init() {
        this.tset = new TupleSet();
    }

    @OPERATION
    void out(String name, Object ... args) {
        this.tset.add(new Tuple(name, args));
    }

    @OPERATION
    void in(String name, Object ... params) {
        TupleTemplate tt = new TupleTemplate(name, params);
        this.await("foundMatch", tt);
        Tuple t = this.tset.removeMatching(tt);
        this.bind(tt, t);
    }

    @OPERATION
    void inp(String name, Object ... params) {
        TupleTemplate tt = new TupleTemplate(name, params);
        if (this.foundMatch(tt)) {
            Tuple t = this.tset.removeMatching(tt);
            this.bind(tt, t);
        } else {
            this.failed("no_match");
        }
    }

    @OPERATION
    void rd(String name, Object ... params) {
        TupleTemplate tt = new TupleTemplate(name, params);
        this.await("foundMatch", tt);
        Tuple t = this.tset.readMatching(tt);
        this.bind(tt, t);
    }

    @OPERATION
    void rdp(String name, Object ... params) {
        TupleTemplate tt = new TupleTemplate(name, params);
        if (this.foundMatch(tt)) {
            Tuple t = this.tset.readMatching(tt);
            this.bind(tt, t);
        } else {
            this.failed("no_match");
        }
    }

    private void bind(TupleTemplate tt, Tuple t) {
        Object[] tparams = t.getContents();
        int index = 0;
        for (Object p : tt.getContents()) {
            if (p instanceof OpFeedbackParam) {
                ((OpFeedbackParam)p).set(tparams[index]);
            }
            ++index;
        }
    }

    @GUARD
    boolean foundMatch(TupleTemplate tt) {
        return this.tset.hasTupleMatching(tt);
    }
}

