/*
 * Decompiled with CFR 0.152.
 */
package cartago.tools;

import cartago.Artifact;
import cartago.IBlockingCmd;
import cartago.INTERNAL_OPERATION;
import cartago.OPERATION;
import cartago.OpFeedbackParam;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.Socket;

public class SocketChannel
extends Artifact {
    Socket socket;
    DataInputStream input;
    DataOutputStream output;
    ReadCmd cmd;
    boolean stopped;

    @OPERATION
    void init(String addr, int port) throws Exception {
        this.socket = new Socket(addr, port);
        this.cmd = new ReadCmd();
        this.stopped = false;
        this.input = new DataInputStream(this.socket.getInputStream());
        this.output = new DataOutputStream(this.socket.getOutputStream());
    }

    @OPERATION
    void writeByte(int v) {
        try {
            this.output.writeByte(v);
        }
        catch (Exception ex) {
            this.failed(ex.toString());
        }
    }

    @OPERATION
    void readByte(OpFeedbackParam<Integer> value) {
        this.await(this.cmd);
        if (this.cmd.isLastExecSucceeded()) {
            value.set(this.cmd.getLastFetched());
        } else {
            this.failed("read_failure");
        }
    }

    @OPERATION
    void startReadStream() {
        this.stopped = false;
        this.execInternalOp("genReadStream", new Object[0]);
    }

    @OPERATION
    void stopReadStream() {
        this.stopped = true;
    }

    @INTERNAL_OPERATION
    void genReadStream() {
        while (!this.stopped) {
            this.await(this.cmd);
            if (!this.cmd.isLastExecSucceeded()) break;
            this.signal("value", this.cmd.getLastFetched());
        }
    }

    class ReadCmd
    implements IBlockingCmd {
        private int fetched;
        private boolean succeeded = false;

        @Override
        public void exec() {
            try {
                this.fetched = SocketChannel.this.input.readByte();
                this.succeeded = true;
            }
            catch (Exception ex) {
                this.succeeded = false;
            }
        }

        public int getLastFetched() {
            return this.fetched;
        }

        public boolean isLastExecSucceeded() {
            return this.succeeded;
        }
    }
}

