/*
 * Decompiled with CFR 0.152.
 */
package cartago.tools;

import cartago.Artifact;
import cartago.INTERNAL_OPERATION;
import cartago.OPERATION;
import cartago.OpFeedbackParam;
import cartago.tools.CommonEventListener;
import cartago.tools.EventOpInfo;
import java.awt.ItemSelectable;
import java.io.File;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileNameExtensionFilter;

public abstract class GUIArtifact
extends Artifact {
    private HashMap<Object, HashMap<String, String>> evToOpLinks = new HashMap();
    private boolean stopped = false;
    private CommonEventListener proc = new CommonEventListener();
    private JFrame mainFrame;

    protected GUIArtifact() {
    }

    protected void init() {
        this.setup();
        this.execInternalOp("fetchGUIEvents", new Object[0]);
    }

    protected void init(Object ... params) {
        this.init();
    }

    protected void setMainFrame(JFrame frame) {
        this.mainFrame = frame;
    }

    public void setup() {
    }

    public void setup(Object ... param) {
    }

    @OPERATION
    void selectFileToOpen(String currentDir, String fileDesc, String[] extensions, OpFeedbackParam<String> selectedFile) {
        File file = new File(currentDir);
        JFileChooser chooser = new JFileChooser(file);
        FileNameExtensionFilter filter = new FileNameExtensionFilter(fileDesc, extensions);
        chooser.setFileFilter(filter);
        int returnVal = chooser.showOpenDialog(this.mainFrame);
        if (returnVal == 0) {
            selectedFile.set(chooser.getSelectedFile().getAbsolutePath());
        } else {
            this.failed("no_file_selected");
        }
    }

    @INTERNAL_OPERATION
    void fetchGUIEvents() {
        while (!this.stopped) {
            String opName;
            this.await(this.proc);
            EventOpInfo eventOp = this.proc.getCurrentEventFetched();
            HashMap<String, String> map = this.evToOpLinks.get(eventOp.getEvent().getSource());
            if (map == null || (opName = map.get(eventOp.getListenerName())) == null) continue;
            this.execInternalOp(opName, eventOp.getEvent());
        }
    }

    protected void linkActionEventToOp(AbstractButton source, String opName) {
        this.insertEventToOp(source, "actionPerformed", opName);
        source.addActionListener(this.getEventListenerInstance());
    }

    protected void linkActionEventToOp(JComboBox source, String opName) {
        this.insertEventToOp(source, "actionPerformed", opName);
        source.addActionListener(this.getEventListenerInstance());
    }

    protected void linkMouseEventToOp(JComponent source, String mouseEventType, String opName) {
        this.insertEventToOp(source, mouseEventType, opName);
        source.addMouseListener(this.getEventListenerInstance());
        source.addMouseMotionListener(this.getEventListenerInstance());
    }

    protected void linkMouseEventToOp(JFrame source, String mouseEventType, String opName) {
        this.insertEventToOp(source, mouseEventType, opName);
        source.addMouseListener(this.getEventListenerInstance());
        source.addMouseMotionListener(this.getEventListenerInstance());
    }

    protected void linkItemEventToOp(ItemSelectable source, String opName) {
        this.insertEventToOp(source, "itemStateChanged", opName);
        source.addItemListener(this.getEventListenerInstance());
    }

    protected void linkListSelectionEventToOp(JList source, String opName) {
        this.insertEventToOp(source, "valueChanged", opName);
        source.addListSelectionListener(this.getEventListenerInstance());
    }

    protected void linkWindowClosingEventToOp(JFrame source, String opName) {
        this.insertEventToOp(source, "windowClosing", opName);
        source.addWindowListener(this.getEventListenerInstance());
    }

    protected void linkKeyStrokeToOp(JComponent source, String key, String opName) {
        this.insertEventToOp(source, "keyPressed", opName);
        source.getInputMap().put(KeyStroke.getKeyStroke(key), "myAction");
        source.getActionMap().put("myAction", this.getEventListenerInstance().getAbstractAction());
    }

    protected void linkChangeEventToOp(JSlider source, String opName) {
        this.insertEventToOp(source, "stateChanged", opName);
        source.addChangeListener(this.getEventListenerInstance());
    }

    protected void insertEventToOp(Object obj, String type, String opName) {
        HashMap<String, String> map = this.evToOpLinks.get(obj);
        if (map == null) {
            map = new HashMap();
            this.evToOpLinks.put(obj, map);
        }
        map.put(type, opName);
    }

    protected CommonEventListener getEventListenerInstance() {
        return this.proc;
    }
}

