/*
 * Decompiled with CFR 0.152.
 */
package cartago.tools;

import cartago.Artifact;
import cartago.INTERNAL_OPERATION;
import cartago.OPERATION;
import cartago.ObsProperty;

public class Clock
extends Artifact {
    private boolean stopped;
    private int nwaits;

    @OPERATION
    void init() {
        this.defineObsProperty("nticks", 0);
        this.stopped = false;
        this.nwaits = 10;
    }

    @OPERATION
    void start() {
        this.stopped = false;
        this.execInternalOp("ticketing", new Object[0]);
    }

    @OPERATION
    void setFrequency(int hz) {
        this.nwaits = 1000 / hz;
    }

    @OPERATION
    void stop() {
        this.stopped = true;
    }

    @INTERNAL_OPERATION
    void ticketing() {
        while (!this.stopped) {
            ObsProperty prop = this.getObsPropertyByTemplate("nticks", new Object[0]);
            prop.updateValue(prop.intValue() + this.nwaits);
            this.signal("tick", new Object[0]);
            this.await_time(this.nwaits);
        }
    }
}

