/*
 * Decompiled with CFR 0.152.
 */
package cartago.security;

import cartago.AgentId;
import cartago.ArtifactId;
import cartago.Op;
import cartago.security.IArtifactUsePolicy;
import cartago.security.IWorkspaceSecurityManager;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class Role {
    private ReentrantReadWriteLock rwl;
    private String name;
    private IArtifactUsePolicy useDefaultPolicy;
    private HashMap<String, IArtifactUsePolicy> usePolicyMap;

    public Role(String name) {
        this.name = name;
        this.rwl = new ReentrantReadWriteLock();
        this.usePolicyMap = new HashMap();
        this.useDefaultPolicy = IWorkspaceSecurityManager.ALWAYS_ALLOW_USE;
    }

    public String getName() {
        return this.name;
    }

    public void addPolicyForUse(String artifactName, IArtifactUsePolicy policy) {
        this.usePolicyMap.put(artifactName, policy);
    }

    public void removePolicyForUse(String artifactName) {
        this.usePolicyMap.remove(artifactName);
    }

    public void setUseDefaultPolicy(IArtifactUsePolicy policy) {
        this.useDefaultPolicy = policy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canUse(AgentId aid, ArtifactId id, Op opDetail) {
        try {
            this.rwl.readLock().lock();
            IArtifactUsePolicy p = this.usePolicyMap.get(id.getName());
            if (p != null) {
                boolean bl = p.allow(aid, id, opDetail);
                return bl;
            }
            boolean bl = this.useDefaultPolicy.allow(aid, id, opDetail);
            return bl;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }
}

