/*
 * Decompiled with CFR 0.152.
 */
package cartago.security;

import cartago.AgentId;
import cartago.ArtifactId;
import cartago.Op;
import cartago.security.IArtifactUsePolicy;
import cartago.security.IWorkspaceSecurityManager;
import cartago.security.Role;
import cartago.security.SecurityException;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class DefaultSecurityManager
implements IWorkspaceSecurityManager {
    public static String DEFAULT_ROLE = "user";
    private HashMap<String, Role> roles = new HashMap();
    private ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();

    public DefaultSecurityManager() {
        Role def = new Role(DEFAULT_ROLE);
        this.roles.put(DEFAULT_ROLE, def);
    }

    @Override
    public void addRole(String roleName) throws SecurityException {
        block4: {
            try {
                this.rwl.writeLock().lock();
                Role role = this.roles.get(roleName);
                if (role == null) {
                    role = new Role(roleName);
                    this.roles.put(roleName, role);
                    break block4;
                }
                throw new SecurityException("Role " + roleName + " already exists.");
            }
            finally {
                this.rwl.writeLock().unlock();
            }
        }
    }

    @Override
    public void removeRole(String roleName) {
        this.rwl.writeLock().lock();
        this.roles.remove(roleName);
        this.rwl.writeLock().unlock();
    }

    @Override
    public boolean hasRole(String roleName) {
        try {
            this.rwl.readLock().lock();
            boolean bl = this.roles.get(roleName) != null;
            return bl;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    @Override
    public void setDefaultRoleName(String roleName) throws SecurityException {
        this.rwl.readLock().lock();
        Role role = this.roles.get(roleName);
        this.rwl.readLock().unlock();
        if (role == null) {
            throw new SecurityException("Role " + roleName + " does not exist.");
        }
        DEFAULT_ROLE = roleName;
    }

    @Override
    public String getDefaultRoleName() {
        return DEFAULT_ROLE;
    }

    @Override
    public void addRolePolicy(String roleName, String artifactName, IArtifactUsePolicy policy) throws SecurityException {
        this.rwl.readLock().lock();
        Role role = this.roles.get(roleName);
        this.rwl.readLock().unlock();
        if (role == null) {
            throw new SecurityException("Unknown role: " + roleName);
        }
        role.addPolicyForUse(artifactName, policy);
    }

    @Override
    public void removeRolePolicy(String roleName, String artifactName) throws SecurityException {
        this.rwl.readLock().lock();
        Role role = this.roles.get(roleName);
        this.rwl.readLock().unlock();
        if (role == null) {
            throw new SecurityException("Unknown role: " + roleName);
        }
        role.removePolicyForUse(artifactName);
    }

    @Override
    public void setDefaultRolePolicy(String roleName, IArtifactUsePolicy policy) throws SecurityException {
        Role role = this.roles.get(roleName);
        if (role == null) {
            throw new SecurityException("Unknown role: " + roleName);
        }
        role.setUseDefaultPolicy(policy);
    }

    @Override
    public boolean canDoAction(AgentId aid, ArtifactId id, Op opDetail) {
        this.rwl.readLock().lock();
        Role role = this.roles.get(aid.getAgentRole());
        this.rwl.readLock().unlock();
        if (role == null) {
            return false;
        }
        return role.canUse(aid, id, opDetail);
    }

    @Override
    public String[] getRoleList() {
        String[] roleList = new String[this.roles.size()];
        int i = 0;
        for (Role r : this.roles.values()) {
            roleList[i++] = r.getName();
        }
        return roleList;
    }
}

