/*
 * Decompiled with CFR 0.152.
 */
package cartago.manual.syntax;

import cartago.manual.syntax.Structure;
import cartago.manual.syntax.Term;
import java.util.Iterator;
import java.util.logging.Logger;

public class UsageProtBody
extends Structure
implements Iterable<UsageProtBody> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(UsageProtBody.class.getName());
    public static final String BODY_PLAN_FUNCTOR = ";";
    private Term term = null;
    private UsageProtBody next = null;
    private BodyType formType = BodyType.none;
    private boolean isTerm = false;

    public UsageProtBody() {
        super(BODY_PLAN_FUNCTOR, 0);
    }

    public UsageProtBody(BodyType t, Term b) {
        super(BODY_PLAN_FUNCTOR, 0);
        this.formType = t;
        if (b != null) {
            this.srcInfo = b.getSrcInfo();
        }
        this.term = b;
    }

    public void setBodyNext(UsageProtBody next) {
        this.next = next;
    }

    public UsageProtBody getBodyNext() {
        return this.next;
    }

    public boolean isEmptyBody() {
        return this.term == null;
    }

    public BodyType getBodyType() {
        return this.formType;
    }

    public void setBodyType(BodyType bt) {
        this.formType = bt;
    }

    public Term getBodyTerm() {
        return this.term;
    }

    public void setBodyTerm(Term t) {
        this.term = t;
    }

    public boolean isBodyTerm() {
        return this.isTerm;
    }

    @Override
    public boolean isAtom() {
        return false;
    }

    public void setAsBodyTerm(boolean b) {
        this.isTerm = b;
        if (this.getBodyNext() != null) {
            this.getBodyNext().setAsBodyTerm(b);
        }
    }

    @Override
    public boolean isPlanBody() {
        return true;
    }

    @Override
    public Iterator<UsageProtBody> iterator() {
        return new Iterator<UsageProtBody>(){
            UsageProtBody current;
            {
                this.current = UsageProtBody.this;
            }

            @Override
            public boolean hasNext() {
                return this.current != null && this.current.getBodyTerm() != null;
            }

            @Override
            public UsageProtBody next() {
                UsageProtBody r = this.current;
                if (this.current != null) {
                    this.current = this.current.getBodyNext();
                }
                return r;
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public int getArity() {
        if (this.term == null) {
            return 0;
        }
        if (this.next == null) {
            return 1;
        }
        return 2;
    }

    @Override
    public Term getTerm(int i) {
        if (i == 0) {
            return this.term;
        }
        if (i == 1) {
            if (this.next != null && this.next.getBodyTerm().isVar() && this.next.getBodyNext() == null) {
                return this.next.getBodyTerm();
            }
            return this.next;
        }
        return null;
    }

    @Override
    public void setTerm(int i, Term t) {
        if (i == 0) {
            this.term = t;
        }
        if (i == 1) {
            System.out.println("Should not setTerm(1) of body literal!");
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof UsageProtBody) {
            UsageProtBody b = (UsageProtBody)o;
            return this.formType == b.getBodyType() && super.equals(o);
        }
        return false;
    }

    @Override
    public int calcHashCode() {
        return this.formType.hashCode() + super.calcHashCode();
    }

    public boolean add(UsageProtBody bl) {
        if (this.term == null) {
            bl = bl.clonePB();
            this.swap(bl);
            this.next = bl.getBodyNext();
        } else if (this.next == null) {
            this.next = bl;
        } else {
            this.next.add(bl);
        }
        return true;
    }

    public UsageProtBody getLastBody() {
        if (this.next == null) {
            return this;
        }
        return this.next.getLastBody();
    }

    public boolean add(int index, UsageProtBody bl) {
        if (index == 0) {
            UsageProtBody newpb = new UsageProtBody(this.formType, this.term);
            newpb.setBodyNext(this.next);
            this.swap(bl);
            this.next = bl.getBodyNext();
            this.getLastBody().setBodyNext(newpb);
        } else if (this.next != null) {
            this.next.add(index - 1, bl);
        } else {
            this.next = bl;
        }
        return true;
    }

    public Term removeBody(int index) {
        if (index == 0) {
            Term oldvalue = this.term;
            if (this.next == null) {
                this.term = null;
            } else {
                this.swap(this.next);
                this.next = this.next.getBodyNext();
            }
            return oldvalue;
        }
        return this.next.removeBody(index - 1);
    }

    public int getPlanSize() {
        if (this.term == null) {
            return 0;
        }
        if (this.next == null) {
            return 1;
        }
        return this.next.getPlanSize() + 1;
    }

    private void swap(UsageProtBody bl) {
        BodyType bt = this.formType;
        this.formType = bl.getBodyType();
        bl.setBodyType(bt);
        Term l = this.term;
        this.term = bl.getBodyTerm();
        bl.setBodyTerm(l);
    }

    @Override
    public UsageProtBody clone() {
        if (this.term == null) {
            return new UsageProtBody();
        }
        UsageProtBody c = new UsageProtBody(this.formType, this.term.clone());
        c.isTerm = this.isTerm;
        if (this.next != null) {
            c.setBodyNext(this.getBodyNext().clonePB());
        }
        return c;
    }

    public UsageProtBody clonePB() {
        return this.clone();
    }

    @Override
    public String toString() {
        if (this.term == null) {
            return "";
        }
        StringBuilder out = new StringBuilder();
        if (this.isTerm) {
            out.append("{ ");
        }
        UsageProtBody pb = this;
        while (pb != null) {
            if (pb.getBodyTerm() != null) {
                out.append((Object)pb.getBodyType());
                out.append(pb.getBodyTerm());
            }
            if ((pb = pb.getBodyNext()) == null) continue;
            out.append("; ");
        }
        if (this.isTerm) {
            out.append(" }");
        }
        return out.toString();
    }

    public static enum BodyType {
        none{

            public String toString() {
                return "";
            }
        }
        ,
        action{

            public String toString() {
                return "";
            }
        }
        ,
        internalAction{

            public String toString() {
                return "";
            }
        }
        ,
        achieve{

            public String toString() {
                return "!";
            }
        }
        ,
        test{

            public String toString() {
                return "?";
            }
        }
        ,
        addBel{

            public String toString() {
                return "+";
            }
        }
        ,
        delBel{

            public String toString() {
                return "-";
            }
        }
        ,
        delAddBel{

            public String toString() {
                return "-+";
            }
        }
        ,
        achieveNF{

            public String toString() {
                return "!!";
            }
        }
        ,
        constraint{

            public String toString() {
                return "";
            }
        };

    }
}

