/*
 * Decompiled with CFR 0.152.
 */
package cartago.manual.syntax;

import cartago.manual.syntax.DefaultTerm;

public final class StringTerm
extends DefaultTerm {
    private static final long serialVersionUID = 1L;
    private final String value;

    public StringTerm() {
        this.value = null;
    }

    public StringTerm(String fs) {
        this.value = fs;
    }

    public StringTerm(StringTerm t) {
        this.value = t.getString();
        this.srcInfo = t.srcInfo;
    }

    public String getString() {
        return this.value;
    }

    @Override
    public StringTerm clone() {
        return this;
    }

    @Override
    public boolean isString() {
        return true;
    }

    public int length() {
        if (this.value == null) {
            return 0;
        }
        return this.value.length();
    }

    @Override
    public boolean equals(Object t) {
        if (t == this) {
            return true;
        }
        if (t != null && t instanceof StringTerm) {
            StringTerm st = (StringTerm)t;
            if (this.value == null) {
                return st.getString() == null;
            }
            return this.value.equals(st.getString());
        }
        return false;
    }

    @Override
    protected int calcHashCode() {
        if (this.value == null) {
            return 0;
        }
        return this.value.hashCode();
    }

    public String toString() {
        return "\"" + this.value + "\"";
    }
}

